/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.endpoints;

import io.github.thibaultbee.streampack.internal.data.Packet;
import io.github.thibaultbee.streampack.internal.endpoints.IEndpoint;
import io.github.thibaultbee.streampack.internal.utils.ByteBufferExtensionsKt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R(\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lio/github/thibaultbee/streampack/internal/endpoints/FileWriter;", "Lio/github/thibaultbee/streampack/internal/endpoints/IEndpoint;", "()V", "value", "Ljava/io/File;", "file", "getFile", "()Ljava/io/File;", "setFile", "(Ljava/io/File;)V", "outputStream", "Ljava/io/OutputStream;", "getOutputStream", "()Ljava/io/OutputStream;", "setOutputStream", "(Ljava/io/OutputStream;)V", "configure", "", "config", "", "release", "startStream", "stopStream", "write", "packet", "Lio/github/thibaultbee/streampack/internal/data/Packet;", "core_release"})
public final class FileWriter
implements IEndpoint {
    @Nullable
    private File file;
    @Nullable
    private OutputStream outputStream;

    @Nullable
    public final File getFile() {
        return this.file;
    }

    public final void setFile(@Nullable File value) {
        File file = value;
        if (file != null) {
            File it = file;
            boolean bl = false;
            this.setOutputStream(new FileOutputStream(value, false));
        }
        this.file = value;
    }

    @Nullable
    public final OutputStream getOutputStream() {
        return this.outputStream;
    }

    public final void setOutputStream(@Nullable OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void startStream() {
        if (this.outputStream == null) {
            throw new UnsupportedOperationException("Set a file before trying to write it");
        }
    }

    @Override
    public void configure(int config) {
    }

    @Override
    public void write(@NotNull Packet packet) {
        Unit unit;
        Unit unit2;
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        OutputStream outputStream = this.outputStream;
        if (outputStream == null) {
            unit2 = null;
        } else {
            outputStream.write(ByteBufferExtensionsKt.extractArray(packet.getBuffer()));
            unit2 = unit = Unit.INSTANCE;
        }
        if (unit == null) {
            throw new UnsupportedOperationException("Set a file before trying to write it");
        }
    }

    @Override
    public void stopStream() {
        OutputStream outputStream = this.outputStream;
        if (outputStream != null) {
            outputStream.close();
        }
    }

    @Override
    public void release() {
    }
}

