/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.flv.packet;

import io.github.thibaultbee.streampack.data.AudioConfig;
import io.github.thibaultbee.streampack.data.Config;
import io.github.thibaultbee.streampack.data.VideoConfig;
import io.github.thibaultbee.streampack.internal.data.Frame;
import io.github.thibaultbee.streampack.internal.muxers.flv.packet.AudioTag;
import io.github.thibaultbee.streampack.internal.muxers.flv.packet.TagType;
import io.github.thibaultbee.streampack.internal.muxers.flv.packet.VideoTag;
import io.github.thibaultbee.streampack.internal.utils.BitOperationExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.ByteBufferExtensionsKt;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H$J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H$R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/packet/FlvTag;", "", "ts", "", "type", "Lio/github/thibaultbee/streampack/internal/muxers/flv/packet/TagType;", "isEncrypted", "", "(JLio/github/thibaultbee/streampack/internal/muxers/flv/packet/TagType;Z)V", "payloadSize", "", "getPayloadSize", "()I", "tagHeaderSize", "getTagHeaderSize", "write", "Ljava/nio/ByteBuffer;", "writePayload", "", "buffer", "writeTagHeader", "Companion", "core_release"})
public abstract class FlvTag {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long ts;
    @NotNull
    private final TagType type;
    private final boolean isEncrypted;
    private static final int FLV_HEADER_TAG_SIZE = 11;

    public FlvTag(long ts, @NotNull TagType type, boolean isEncrypted) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.ts = ts;
        this.type = type;
        this.isEncrypted = isEncrypted;
    }

    public /* synthetic */ FlvTag(long l, TagType tagType, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(l, tagType, bl);
    }

    protected abstract void writeTagHeader(@NotNull ByteBuffer var1);

    protected abstract int getTagHeaderSize();

    protected abstract void writePayload(@NotNull ByteBuffer var1);

    protected abstract int getPayloadSize();

    @NotNull
    public final ByteBuffer write() {
        int dataSize = this.getTagHeaderSize() + this.getPayloadSize();
        int flvTagSize = 11 + dataSize;
        ByteBuffer buffer = ByteBuffer.allocateDirect(flvTagSize + 4);
        Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
        ByteBufferExtensionsKt.put(buffer, BitOperationExtensionsKt.shl(this.isEncrypted, 5) | this.type.getValue());
        ByteBufferExtensionsKt.putInt24(buffer, dataSize);
        int tsInMs = (int)(this.ts / (long)1000);
        ByteBufferExtensionsKt.putInt24(buffer, tsInMs);
        buffer.put((byte)(tsInMs >> 24));
        ByteBufferExtensionsKt.putInt24(buffer, 0);
        this.writeTagHeader(buffer);
        if (this.isEncrypted) {
            throw new NotImplementedError("Filter/encryption is not implemented yet");
        }
        this.writePayload(buffer);
        buffer.putInt(flvTagSize);
        buffer.rewind();
        return buffer;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/packet/FlvTag$Companion;", "", "()V", "FLV_HEADER_TAG_SIZE", "", "createFlvTag", "Lio/github/thibaultbee/streampack/internal/muxers/flv/packet/FlvTag;", "frame", "Lio/github/thibaultbee/streampack/internal/data/Frame;", "isSequenceHeader", "", "config", "Lio/github/thibaultbee/streampack/data/Config;", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FlvTag createFlvTag(@NotNull Frame frame, boolean isSequenceHeader, @NotNull Config config) {
            FlvTag flvTag;
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            if (frame.isAudio()) {
                AudioTag audioTag;
                if (isSequenceHeader) {
                    long l = frame.getPts();
                    List<ByteBuffer> list = frame.getExtra();
                    Intrinsics.checkNotNull(list);
                    audioTag = new AudioTag(l, list.get(0), true, (AudioConfig)config);
                } else {
                    audioTag = new AudioTag(frame.getPts(), frame.getBuffer(), false, (AudioConfig)config);
                }
                flvTag = audioTag;
            } else if (frame.isVideo()) {
                VideoTag videoTag;
                if (isSequenceHeader) {
                    long l = frame.getPts();
                    List<ByteBuffer> list = frame.getExtra();
                    Intrinsics.checkNotNull(list);
                    videoTag = new VideoTag(l, list, frame.isKeyFrame(), true, (VideoConfig)config);
                } else {
                    videoTag = new VideoTag(frame.getPts(), frame.getBuffer(), frame.isKeyFrame(), false, (VideoConfig)config);
                }
                flvTag = videoTag;
            } else {
                throw new IOException(Intrinsics.stringPlus((String)"Frame is neither video nor audio: ", (Object)frame.getMimeType()));
            }
            return flvTag;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

