/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.flv.packet;

import io.github.thibaultbee.streampack.data.VideoConfig;
import io.github.thibaultbee.streampack.internal.muxers.flv.packet.AVCPacketType;
import io.github.thibaultbee.streampack.internal.muxers.flv.packet.CodecID;
import io.github.thibaultbee.streampack.internal.muxers.flv.packet.FlvTag;
import io.github.thibaultbee.streampack.internal.muxers.flv.packet.FrameType;
import io.github.thibaultbee.streampack.internal.muxers.flv.packet.TagType;
import io.github.thibaultbee.streampack.internal.utils.ByteBufferExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.av.video.H26XKt;
import io.github.thibaultbee.streampack.internal.utils.av.video.avc.AVCDecoderConfigurationRecord;
import io.github.thibaultbee.streampack.internal.utils.av.video.hevc.HEVCDecoderConfigurationRecord;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0015\u001a\u00020\u0010H\u0002J\b\u0010\u0016\u001a\u00020\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005H\u0014R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/packet/VideoTag;", "Lio/github/thibaultbee/streampack/internal/muxers/flv/packet/FlvTag;", "pts", "", "buffer", "Ljava/nio/ByteBuffer;", "isKeyFrame", "", "isSequenceHeader", "videoConfig", "Lio/github/thibaultbee/streampack/data/VideoConfig;", "(JLjava/nio/ByteBuffer;ZZLio/github/thibaultbee/streampack/data/VideoConfig;)V", "buffers", "", "(JLjava/util/List;ZZLio/github/thibaultbee/streampack/data/VideoConfig;)V", "payloadSize", "", "getPayloadSize", "()I", "tagHeaderSize", "getTagHeaderSize", "computeHeaderSize", "computePayloadSize", "writePayload", "", "writeTagHeader", "Companion", "core_release"})
public final class VideoTag
extends FlvTag {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ByteBuffer> buffers;
    private final boolean isKeyFrame;
    private final boolean isSequenceHeader;
    @NotNull
    private final VideoConfig videoConfig;
    private final int tagHeaderSize;
    private final int payloadSize;
    private static final int VIDEO_TAG_HEADER_SIZE = 1;

    public VideoTag(long pts, @NotNull List<? extends ByteBuffer> buffers, boolean isKeyFrame, boolean isSequenceHeader, @NotNull VideoConfig videoConfig) {
        Intrinsics.checkNotNullParameter(buffers, (String)"buffers");
        Intrinsics.checkNotNullParameter((Object)videoConfig, (String)"videoConfig");
        super(pts, TagType.VIDEO, false, 4, null);
        this.buffers = buffers;
        this.isKeyFrame = isKeyFrame;
        this.isSequenceHeader = isSequenceHeader;
        this.videoConfig = videoConfig;
        if (Intrinsics.areEqual((Object)this.videoConfig.getMimeType(), (Object)"video/avc")) {
            if (!this.isSequenceHeader) {
                if (!(this.buffers.size() == 1)) {
                    boolean $i$a$-require-VideoTag$52 = false;
                    String $i$a$-require-VideoTag$52 = "Only one buffer is expected for raw frame";
                    throw new IllegalArgumentException($i$a$-require-VideoTag$52.toString());
                }
            } else if (!(this.buffers.size() == 2)) {
                boolean $i$a$-require-VideoTag$62 = false;
                String $i$a$-require-VideoTag$62 = "Both SPS and PPS are expected in sequence mode";
                throw new IllegalArgumentException($i$a$-require-VideoTag$62.toString());
            }
        }
        if (Intrinsics.areEqual((Object)this.videoConfig.getMimeType(), (Object)"video/hevc")) {
            if (!this.isSequenceHeader) {
                if (!(this.buffers.size() == 1)) {
                    boolean $i$a$-require-VideoTag$72 = false;
                    String $i$a$-require-VideoTag$72 = "Only one buffer is expected for raw frame";
                    throw new IllegalArgumentException($i$a$-require-VideoTag$72.toString());
                }
            } else if (!(this.buffers.size() == 3)) {
                boolean bl = false;
                String string = "Both SPS, PPS and VPS are expected in sequence mode";
                throw new IllegalArgumentException(string.toString());
            }
        }
        this.tagHeaderSize = this.computeHeaderSize();
        this.payloadSize = this.computePayloadSize();
    }

    public /* synthetic */ VideoTag(long l, List list, boolean bl, boolean bl2, VideoConfig videoConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl2 = false;
        }
        this(l, list, bl, bl2, videoConfig);
    }

    public VideoTag(long pts, @NotNull ByteBuffer buffer, boolean isKeyFrame, boolean isSequenceHeader, @NotNull VideoConfig videoConfig) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)videoConfig, (String)"videoConfig");
        this(pts, CollectionsKt.listOf((Object)buffer), isKeyFrame, isSequenceHeader, videoConfig);
    }

    public /* synthetic */ VideoTag(long l, ByteBuffer byteBuffer, boolean bl, boolean bl2, VideoConfig videoConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl2 = false;
        }
        this(l, byteBuffer, bl, bl2, videoConfig);
    }

    @Override
    protected void writeTagHeader(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        FrameType frameType = this.isKeyFrame ? FrameType.KEY : FrameType.INTER;
        ByteBufferExtensionsKt.put(buffer, frameType.getValue() << 4 | CodecID.Companion.fromMimeType(this.videoConfig.getMimeType()).getValue());
        if (Intrinsics.areEqual((Object)this.videoConfig.getMimeType(), (Object)"video/avc") || Intrinsics.areEqual((Object)this.videoConfig.getMimeType(), (Object)"video/hevc")) {
            if (this.isSequenceHeader) {
                ByteBufferExtensionsKt.put(buffer, AVCPacketType.SEQUENCE.getValue());
            } else {
                ByteBufferExtensionsKt.put(buffer, AVCPacketType.NALU.getValue());
            }
            ByteBufferExtensionsKt.putInt24(buffer, 0);
        }
    }

    @Override
    protected int getTagHeaderSize() {
        return this.tagHeaderSize;
    }

    private final int computeHeaderSize() {
        int size = 1;
        if (Intrinsics.areEqual((Object)this.videoConfig.getMimeType(), (Object)"video/avc") || Intrinsics.areEqual((Object)this.videoConfig.getMimeType(), (Object)"video/hevc")) {
            size += 4;
        }
        return size;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void writePayload(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (this.isSequenceHeader) {
            String string = this.videoConfig.getMimeType();
            if (Intrinsics.areEqual((Object)string, (Object)"video/avc")) {
                AVCDecoderConfigurationRecord.Companion.fromParameterSets(this.buffers.get(0), this.buffers.get(1)).write(buffer);
                return;
            } else {
                if (!Intrinsics.areEqual((Object)string, (Object)"video/hevc")) throw new IOException("Mimetype " + this.videoConfig.getMimeType() + " is not supported");
                HEVCDecoderConfigurationRecord.Companion.fromParameterSets(this.buffers.get(0), this.buffers.get(1), this.buffers.get(2)).write(buffer);
            }
            return;
        } else {
            ByteBuffer noStartCodeBuffer = H26XKt.removeStartCode(this.buffers.get(0));
            buffer.putInt(noStartCodeBuffer.remaining());
            buffer.put(noStartCodeBuffer);
        }
    }

    @Override
    protected int getPayloadSize() {
        return this.payloadSize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int computePayloadSize() {
        int n;
        if (!this.isSequenceHeader) return this.buffers.get(0).remaining() - H26XKt.getStartCodeSize(this.buffers.get(0)) + 4;
        String string = this.videoConfig.getMimeType();
        if (Intrinsics.areEqual((Object)string, (Object)"video/avc")) {
            n = AVCDecoderConfigurationRecord.Companion.getSize(this.buffers.get(0), this.buffers.get(1));
            return n;
        } else {
            if (!Intrinsics.areEqual((Object)string, (Object)"video/hevc")) throw new IOException("Mimetype " + this.videoConfig.getMimeType() + " is not supported");
            n = HEVCDecoderConfigurationRecord.Companion.getSize(this.buffers.get(0), this.buffers.get(1), this.buffers.get(2));
        }
        return n;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/packet/VideoTag$Companion;", "", "()V", "VIDEO_TAG_HEADER_SIZE", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

