/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils.av.audio;

import io.github.thibaultbee.streampack.data.AudioConfig;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0007\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\b\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioSpecificConfig;", "", "decoderSpecificInformation", "Ljava/nio/ByteBuffer;", "audioConfig", "Lio/github/thibaultbee/streampack/data/AudioConfig;", "(Ljava/nio/ByteBuffer;Lio/github/thibaultbee/streampack/data/AudioConfig;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "write", "", "buffer", "core_release"})
public final class AudioSpecificConfig {
    @NotNull
    private final ByteBuffer decoderSpecificInformation;
    @NotNull
    private final AudioConfig audioConfig;

    public AudioSpecificConfig(@NotNull ByteBuffer decoderSpecificInformation, @NotNull AudioConfig audioConfig) {
        Intrinsics.checkNotNullParameter((Object)decoderSpecificInformation, (String)"decoderSpecificInformation");
        Intrinsics.checkNotNullParameter((Object)audioConfig, (String)"audioConfig");
        this.decoderSpecificInformation = decoderSpecificInformation;
        this.audioConfig = audioConfig;
    }

    public final void write(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (!Intrinsics.areEqual((Object)this.audioConfig.getMimeType(), (Object)"audio/mp4a-latm")) {
            throw new NotImplementedError(Intrinsics.stringPlus((String)"No support for ", (Object)this.audioConfig.getMimeType()));
        }
        buffer.put(this.decoderSpecificInformation);
    }

    private final ByteBuffer component1() {
        return this.decoderSpecificInformation;
    }

    private final AudioConfig component2() {
        return this.audioConfig;
    }

    @NotNull
    public final AudioSpecificConfig copy(@NotNull ByteBuffer decoderSpecificInformation, @NotNull AudioConfig audioConfig) {
        Intrinsics.checkNotNullParameter((Object)decoderSpecificInformation, (String)"decoderSpecificInformation");
        Intrinsics.checkNotNullParameter((Object)audioConfig, (String)"audioConfig");
        return new AudioSpecificConfig(decoderSpecificInformation, audioConfig);
    }

    public static /* synthetic */ AudioSpecificConfig copy$default(AudioSpecificConfig audioSpecificConfig, ByteBuffer byteBuffer, AudioConfig audioConfig, int n, Object object) {
        if ((n & 1) != 0) {
            byteBuffer = audioSpecificConfig.decoderSpecificInformation;
        }
        if ((n & 2) != 0) {
            audioConfig = audioSpecificConfig.audioConfig;
        }
        return audioSpecificConfig.copy(byteBuffer, audioConfig);
    }

    @NotNull
    public String toString() {
        return "AudioSpecificConfig(decoderSpecificInformation=" + this.decoderSpecificInformation + ", audioConfig=" + this.audioConfig + ')';
    }

    public int hashCode() {
        int result = this.decoderSpecificInformation.hashCode();
        result = result * 31 + this.audioConfig.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AudioSpecificConfig)) {
            return false;
        }
        AudioSpecificConfig audioSpecificConfig = (AudioSpecificConfig)other;
        if (!Intrinsics.areEqual((Object)this.decoderSpecificInformation, (Object)audioSpecificConfig.decoderSpecificInformation)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.audioConfig, (Object)audioSpecificConfig.audioConfig);
    }
}

