/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.utils;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.Rect;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.MeteringRectangle;
import android.os.Build;
import android.util.Rational;
import io.github.thibaultbee.streampack.internal.sources.camera.CameraController;
import io.github.thibaultbee.streampack.logger.ILogger;
import io.github.thibaultbee.streampack.logger.Logger;
import io.github.thibaultbee.streampack.utils.CameraExtensionsKt;
import io.github.thibaultbee.streampack.utils.Exposure;
import io.github.thibaultbee.streampack.utils.ExtensionsKt;
import io.github.thibaultbee.streampack.utils.Focus;
import io.github.thibaultbee.streampack.utils.OrientationUtils;
import io.github.thibaultbee.streampack.utils.WhiteBalance;
import io.github.thibaultbee.streampack.utils.Zoom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ,2\u00020\u0001:\u0001,B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ2\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\b\u0010\u001b\u001a\u00020\u0015H\u0002J\u0006\u0010\u001c\u001a\u00020\u0015J\b\u0010\u001d\u001a\u00020\u0015H\u0002J\u001e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J:\u0010%\u001a\u00020\u00152\f\u0010&\u001a\b\u0012\u0004\u0012\u00020 0\u00172\f\u0010'\u001a\b\u0012\u0004\u0012\u00020 0\u00172\f\u0010(\u001a\b\u0012\u0004\u0012\u00020 0\u00172\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020\u0015H\u0002R\u0014\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lio/github/thibaultbee/streampack/utils/FocusMetering;", "", "context", "Landroid/content/Context;", "cameraController", "Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;", "zoom", "Lio/github/thibaultbee/streampack/utils/Zoom;", "focus", "Lio/github/thibaultbee/streampack/utils/Focus;", "exposure", "Lio/github/thibaultbee/streampack/utils/Exposure;", "whiteBalance", "Lio/github/thibaultbee/streampack/utils/WhiteBalance;", "(Landroid/content/Context;Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;Lio/github/thibaultbee/streampack/utils/Zoom;Lio/github/thibaultbee/streampack/utils/Focus;Lio/github/thibaultbee/streampack/utils/Exposure;Lio/github/thibaultbee/streampack/utils/WhiteBalance;)V", "autoCancelHandle", "Ljava/util/concurrent/ScheduledFuture;", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "addFocusMetering", "", "afRects", "", "Landroid/hardware/camera2/params/MeteringRectangle;", "aeRects", "awbRects", "cancelAfAeTrigger", "cancelFocusAndMetering", "disableAutoCancel", "onTap", "point", "Landroid/graphics/PointF;", "fovRect", "Landroid/graphics/Rect;", "fovRotationDegree", "", "startFocusAndMetering", "afPoints", "aePoints", "awbPoints", "fovAspectRatio", "Landroid/util/Rational;", "triggerAf", "Companion", "core_release"})
public final class FocusMetering {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final CameraController cameraController;
    @NotNull
    private final Zoom zoom;
    @NotNull
    private final Focus focus;
    @NotNull
    private final Exposure exposure;
    @NotNull
    private final WhiteBalance whiteBalance;
    private final ScheduledExecutorService scheduler;
    @Nullable
    private ScheduledFuture<?> autoCancelHandle;
    private static final float DEFAULT_AF_SIZE = 0.16666667f;
    private static final float DEFAULT_AE_SIZE = 0.25f;
    private static final int DEFAULT_METERING_WEIGHT_MAX = 1000;
    private static final long DEFAULT_AUTO_CANCEL_DURATION_MS = 5000L;

    public FocusMetering(@NotNull Context context, @NotNull CameraController cameraController, @NotNull Zoom zoom, @NotNull Focus focus, @NotNull Exposure exposure, @NotNull WhiteBalance whiteBalance) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cameraController, (String)"cameraController");
        Intrinsics.checkNotNullParameter((Object)zoom, (String)"zoom");
        Intrinsics.checkNotNullParameter((Object)focus, (String)"focus");
        Intrinsics.checkNotNullParameter((Object)exposure, (String)"exposure");
        Intrinsics.checkNotNullParameter((Object)whiteBalance, (String)"whiteBalance");
        this.context = context;
        this.cameraController = cameraController;
        this.zoom = zoom;
        this.focus = focus;
        this.exposure = exposure;
        this.whiteBalance = whiteBalance;
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
    }

    private final void cancelAfAeTrigger() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)CaptureRequest.CONTROL_AF_TRIGGER, (Object)2)};
        Map cancelTriggerMap = MapsKt.mutableMapOf((Pair[])pairArray);
        if (Build.VERSION.SDK_INT >= 23) {
            cancelTriggerMap.put(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, 2);
        }
        this.cameraController.setBurstSettings(cancelTriggerMap);
    }

    private final void addFocusMetering(List<MeteringRectangle> afRects, List<MeteringRectangle> aeRects, List<MeteringRectangle> awbRects) {
        Collection thisCollection$iv;
        boolean $i$f$toTypedArray;
        Collection $this$toTypedArray$iv;
        CaptureRequest.Key key;
        Integer n;
        String string2 = this.cameraController.getCameraId();
        if (string2 == null) {
            n = null;
        } else {
            String it = string2;
            boolean bl = false;
            n = FocusMetering.Companion.getPreferredAFMode(this.context, it, 1);
        }
        Integer n2 = n;
        if (n2 == null) {
            throw new IllegalStateException("Camera ID is null");
        }
        int afMode = n2;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)CaptureRequest.CONTROL_AF_MODE, (Object)afMode), TuplesKt.to((Object)CaptureRequest.CONTROL_AF_TRIGGER, (Object)2)};
        Map settingsMap = MapsKt.mutableMapOf((Pair[])pairArray);
        if (!((Collection)afRects).isEmpty()) {
            key = CaptureRequest.CONTROL_AF_REGIONS;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AF_REGIONS");
            $this$toTypedArray$iv = afRects;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            MeteringRectangle[] meteringRectangleArray = thisCollection$iv.toArray(new MeteringRectangle[0]);
            if (meteringRectangleArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            settingsMap.put(key, meteringRectangleArray);
        }
        if (!((Collection)aeRects).isEmpty()) {
            key = CaptureRequest.CONTROL_AE_REGIONS;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AE_REGIONS");
            $this$toTypedArray$iv = aeRects;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            MeteringRectangle[] meteringRectangleArray = thisCollection$iv.toArray(new MeteringRectangle[0]);
            if (meteringRectangleArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            settingsMap.put(key, meteringRectangleArray);
        }
        if (!((Collection)awbRects).isEmpty()) {
            key = CaptureRequest.CONTROL_AWB_REGIONS;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AWB_REGIONS");
            $this$toTypedArray$iv = awbRects;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            MeteringRectangle[] meteringRectangleArray = thisCollection$iv.toArray(new MeteringRectangle[0]);
            if (meteringRectangleArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            settingsMap.put(key, meteringRectangleArray);
        }
        this.cameraController.setRepeatingSettings(settingsMap);
    }

    private final void triggerAf() {
        Integer n;
        String string2 = this.cameraController.getCameraId();
        if (string2 == null) {
            n = null;
        } else {
            String it = string2;
            boolean bl = false;
            n = FocusMetering.Companion.getPreferredAEMode(this.context, it, 1);
        }
        Integer n2 = n;
        if (n2 == null) {
            throw new IllegalStateException("Camera ID is null");
        }
        int aeMode = n2;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)CaptureRequest.CONTROL_AF_TRIGGER, (Object)1), TuplesKt.to((Object)CaptureRequest.CONTROL_AE_MODE, (Object)aeMode)};
        Map settingsMap = MapsKt.mutableMapOf((Pair[])pairArray);
        this.cameraController.setBurstSettings(settingsMap);
    }

    private final void startFocusAndMetering(List<? extends PointF> afPoints, List<? extends PointF> aePoints, List<? extends PointF> awbPoints, Rational fovAspectRatio) {
        if (afPoints.isEmpty() && aePoints.isEmpty() && awbPoints.isEmpty()) {
            ILogger.DefaultImpls.e$default(Logger.INSTANCE, ExtensionsKt.getTAG(this), "No focus/metering points provided", null, 4, null);
            return;
        }
        String string2 = this.cameraController.getCameraId();
        if (string2 == null) {
            throw new IllegalStateException("Camera ID is null");
        }
        String cameraId2 = string2;
        this.disableAutoCancel();
        int maxAFRegion = this.focus.getMaxNumOfMeteringRegions();
        int maxAERegion = this.exposure.getMaxNumOfMeteringRegions();
        int maxWbRegion = this.whiteBalance.getMaxNumOfMeteringRegions();
        if (maxAFRegion == 0 && maxAERegion == 0 && maxWbRegion == 0) {
            ILogger.DefaultImpls.w$default(Logger.INSTANCE, ExtensionsKt.getTAG(this), "No metering regions available", null, 4, null);
            return;
        }
        Rect cropRegion = Zoom.Companion.getCropRegion$core_release(CameraExtensionsKt.getCameraCharacteristics(this.context, cameraId2), this.zoom.getZoomRatio());
        List afRectangles = FocusMetering.Companion.getMeteringRectangles(afPoints, 0.16666667f, maxAFRegion, cropRegion, fovAspectRatio);
        List aeRectangles = FocusMetering.Companion.getMeteringRectangles(aePoints, 0.25f, maxAERegion, cropRegion, fovAspectRatio);
        List awbRectangles = FocusMetering.Companion.getMeteringRectangles(awbPoints, 0.16666667f, maxWbRegion, cropRegion, fovAspectRatio);
        this.addFocusMetering(afRectangles, aeRectangles, awbRectangles);
        this.triggerAf();
        this.autoCancelHandle = this.scheduler.schedule(() -> FocusMetering.startFocusAndMetering$lambda-2(this), 5000L, TimeUnit.MILLISECONDS);
    }

    private final void disableAutoCancel() {
        ScheduledFuture<?> scheduledFuture = this.autoCancelHandle;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        this.autoCancelHandle = null;
    }

    public final void onTap(@NotNull PointF point, @NotNull Rect fovRect, int fovRotationDegree) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)fovRect, (String)"fovRect");
        String string2 = this.cameraController.getCameraId();
        if (string2 == null) {
            throw new IllegalStateException("Camera ID is null");
        }
        String cameraId2 = string2;
        int relativeRotation = CameraExtensionsKt.computeRelativeRotation(this.context, cameraId2, fovRotationDegree);
        PointF normalizedPoint = io.github.thibaultbee.streampack.internal.utils.ExtensionsKt.normalize(point, fovRect);
        normalizedPoint = io.github.thibaultbee.streampack.internal.utils.ExtensionsKt.rotate(normalizedPoint, relativeRotation);
        this.startFocusAndMetering(CollectionsKt.listOf((Object)normalizedPoint), CollectionsKt.listOf((Object)normalizedPoint), CollectionsKt.emptyList(), OrientationUtils.INSTANCE.isPortrait(relativeRotation) ? new Rational(fovRect.height(), fovRect.width()) : new Rational(fovRect.width(), fovRect.height()));
    }

    public final void cancelFocusAndMetering() {
        this.disableAutoCancel();
        this.cancelAfAeTrigger();
        this.cameraController.updateRepeatingSession();
    }

    private static final void startFocusAndMetering$lambda-2(FocusMetering this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.cancelFocusAndMetering();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J<\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00172\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J \u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\tH\u0002J \u0010!\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/github/thibaultbee/streampack/utils/FocusMetering$Companion;", "", "()V", "DEFAULT_AE_SIZE", "", "DEFAULT_AF_SIZE", "DEFAULT_AUTO_CANCEL_DURATION_MS", "", "DEFAULT_METERING_WEIGHT_MAX", "", "getFovAdjustedPoint", "Landroid/graphics/PointF;", "point", "cropRegionAspectRatio", "Landroid/util/Rational;", "previewAspectRatio", "getMeteringRect", "Landroid/hardware/camera2/params/MeteringRectangle;", "size", "adjustedPoint", "cropRegion", "Landroid/graphics/Rect;", "getMeteringRectangles", "", "points", "maxNumOfRegions", "fovAspectRatio", "getPreferredAEMode", "context", "Landroid/content/Context;", "cameraId", "", "preferredMode", "getPreferredAFMode", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        private final int getPreferredAFMode(Context context, String cameraId2, int preferredMode) {
            List<Integer> supportedAFModes = CameraExtensionsKt.getAutoFocusModes(context, cameraId2);
            if (supportedAFModes.contains(preferredMode)) {
                return preferredMode;
            }
            if (supportedAFModes.contains(4)) {
                return 4;
            }
            if (supportedAFModes.contains(1)) {
                return 1;
            }
            return 0;
        }

        private final int getPreferredAEMode(Context context, String cameraId2, int preferredMode) {
            List<Integer> supportedAEModes = CameraExtensionsKt.getAutoExposureModes(context, cameraId2);
            if (supportedAEModes.isEmpty()) {
                return 0;
            }
            if (supportedAEModes.contains(preferredMode)) {
                return preferredMode;
            }
            if (supportedAEModes.contains(1)) {
                return 1;
            }
            return 0;
        }

        private final List<MeteringRectangle> getMeteringRectangles(List<? extends PointF> points, float size, int maxNumOfRegions, Rect cropRegion, Rational fovAspectRatio) {
            if (maxNumOfRegions == 0) {
                return CollectionsKt.emptyList();
            }
            List meteringRectangles = new ArrayList();
            Rational cropRegionAspectRatio = new Rational(cropRegion.width(), cropRegion.height());
            for (PointF pointF : points) {
                if (meteringRectangles.size() >= maxNumOfRegions) break;
                if (!io.github.thibaultbee.streampack.internal.utils.ExtensionsKt.isNormalized(pointF)) continue;
                PointF adjustedPoint = this.getFovAdjustedPoint(pointF, cropRegionAspectRatio, fovAspectRatio);
                MeteringRectangle meteringRectangle = this.getMeteringRect(size, adjustedPoint, cropRegion);
                meteringRectangles.add(meteringRectangle);
            }
            return meteringRectangles;
        }

        private final PointF getFovAdjustedPoint(PointF point, Rational cropRegionAspectRatio, Rational previewAspectRatio) {
            if (!Intrinsics.areEqual((Object)previewAspectRatio, (Object)cropRegionAspectRatio)) {
                if (previewAspectRatio.compareTo(cropRegionAspectRatio) > 0) {
                    float heightOfCropRegion = (float)(previewAspectRatio.doubleValue() / cropRegionAspectRatio.doubleValue());
                    float topPadding = (float)(((double)heightOfCropRegion - 1.0) / (double)2);
                    point.y = (topPadding + point.y) * (1.0f / heightOfCropRegion);
                } else {
                    float widthOfCropRegion = (float)(cropRegionAspectRatio.doubleValue() / previewAspectRatio.doubleValue());
                    float leftPadding = (float)(((double)widthOfCropRegion - 1.0) / (double)2);
                    point.x = (leftPadding + point.x) * (1.0f / widthOfCropRegion);
                }
            }
            return point;
        }

        private final MeteringRectangle getMeteringRect(float size, PointF adjustedPoint, Rect cropRegion) {
            int centerX = (int)((float)cropRegion.left + adjustedPoint.x * (float)cropRegion.width());
            int centerY = (int)((float)cropRegion.top + adjustedPoint.y * (float)cropRegion.height());
            float width = size * (float)cropRegion.width();
            float height = size * (float)cropRegion.height();
            Rect focusRect = new Rect((int)((float)centerX - width / (float)2), (int)((float)centerY - height / (float)2), (int)((float)centerX + width / (float)2), (int)((float)centerY + height / (float)2));
            focusRect.left = ((Number)((Object)io.github.thibaultbee.streampack.internal.utils.ExtensionsKt.clamp(focusRect.left, cropRegion.right, cropRegion.left))).intValue();
            focusRect.right = ((Number)((Object)io.github.thibaultbee.streampack.internal.utils.ExtensionsKt.clamp(focusRect.right, cropRegion.right, cropRegion.left))).intValue();
            focusRect.top = ((Number)((Object)io.github.thibaultbee.streampack.internal.utils.ExtensionsKt.clamp(focusRect.top, cropRegion.bottom, cropRegion.top))).intValue();
            focusRect.bottom = ((Number)((Object)io.github.thibaultbee.streampack.internal.utils.ExtensionsKt.clamp(focusRect.bottom, cropRegion.bottom, cropRegion.top))).intValue();
            return new MeteringRectangle(focusRect, 1000);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

