/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.data;

import android.media.MediaFormat;
import io.github.thibaultbee.streampack.internal.utils.extensions.ByteBufferExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.extensions.MediaFormatExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.extensions.StringExtensionsKt;
import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010(\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\t\u0010)\u001a\u00020\bH\u00c6\u0003J\t\u0010*\u001a\u00020\nH\u00c6\u0003JB\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001\u00a2\u0006\u0002\u0010,J\u0013\u0010-\u001a\u00020\b2\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0019\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u000e\u00a8\u00062"}, d2={"Lio/github/thibaultbee/streampack/internal/data/Frame;", "", "rawBuffer", "Ljava/nio/ByteBuffer;", "pts", "", "dts", "isKeyFrame", "", "format", "Landroid/media/MediaFormat;", "(Ljava/nio/ByteBuffer;JLjava/lang/Long;ZLandroid/media/MediaFormat;)V", "buffer", "getBuffer", "()Ljava/nio/ByteBuffer;", "getDts", "()Ljava/lang/Long;", "setDts", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "extra", "", "getExtra", "()Ljava/util/List;", "getFormat", "()Landroid/media/MediaFormat;", "isAudio", "()Z", "isVideo", "mimeType", "", "getMimeType", "()Ljava/lang/String;", "getPts", "()J", "setPts", "(J)V", "getRawBuffer", "component1", "component2", "component3", "component4", "component5", "copy", "(Ljava/nio/ByteBuffer;JLjava/lang/Long;ZLandroid/media/MediaFormat;)Lio/github/thibaultbee/streampack/internal/data/Frame;", "equals", "other", "hashCode", "", "toString", "core_release"})
public final class Frame {
    @NotNull
    private final ByteBuffer rawBuffer;
    private long pts;
    @Nullable
    private Long dts;
    private final boolean isKeyFrame;
    @NotNull
    private final MediaFormat format;
    @NotNull
    private final String mimeType;
    private final boolean isVideo;
    private final boolean isAudio;
    @Nullable
    private final List<ByteBuffer> extra;
    @NotNull
    private final ByteBuffer buffer;

    public Frame(@NotNull ByteBuffer rawBuffer, long pts, @Nullable Long dts, boolean isKeyFrame, @NotNull MediaFormat format) {
        List<ByteBuffer> list;
        Frame frame;
        Intrinsics.checkNotNullParameter((Object)rawBuffer, (String)"rawBuffer");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.rawBuffer = rawBuffer;
        this.pts = pts;
        this.dts = dts;
        this.isKeyFrame = isKeyFrame;
        this.format = format;
        String string2 = this.format.getString("mime");
        Intrinsics.checkNotNull((Object)string2);
        this.mimeType = string2;
        this.isVideo = StringExtensionsKt.isVideo(this.mimeType);
        this.isAudio = StringExtensionsKt.isAudio(this.mimeType);
        Frame frame2 = this;
        try {
            frame = frame2;
            list = this.isKeyFrame || StringExtensionsKt.isAudio(this.mimeType) ? MediaFormatExtensionsKt.getExtra(this.format) : null;
        }
        catch (Exception exception) {
            frame = frame2;
            list = null;
        }
        frame.extra = list;
        this.buffer = this.extra != null ? ByteBufferExtensionsKt.removePrefixes(this.rawBuffer, this.extra) : this.rawBuffer;
    }

    public /* synthetic */ Frame(ByteBuffer byteBuffer, long l, Long l2, boolean bl, MediaFormat mediaFormat, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l2 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(byteBuffer, l, l2, bl, mediaFormat);
    }

    @NotNull
    public final ByteBuffer getRawBuffer() {
        return this.rawBuffer;
    }

    public final long getPts() {
        return this.pts;
    }

    public final void setPts(long l) {
        this.pts = l;
    }

    @Nullable
    public final Long getDts() {
        return this.dts;
    }

    public final void setDts(@Nullable Long l) {
        this.dts = l;
    }

    public final boolean isKeyFrame() {
        return this.isKeyFrame;
    }

    @NotNull
    public final MediaFormat getFormat() {
        return this.format;
    }

    @NotNull
    public final String getMimeType() {
        return this.mimeType;
    }

    public final boolean isVideo() {
        return this.isVideo;
    }

    public final boolean isAudio() {
        return this.isAudio;
    }

    @Nullable
    public final List<ByteBuffer> getExtra() {
        return this.extra;
    }

    @NotNull
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    @NotNull
    public final ByteBuffer component1() {
        return this.rawBuffer;
    }

    public final long component2() {
        return this.pts;
    }

    @Nullable
    public final Long component3() {
        return this.dts;
    }

    public final boolean component4() {
        return this.isKeyFrame;
    }

    @NotNull
    public final MediaFormat component5() {
        return this.format;
    }

    @NotNull
    public final Frame copy(@NotNull ByteBuffer rawBuffer, long pts, @Nullable Long dts, boolean isKeyFrame, @NotNull MediaFormat format) {
        Intrinsics.checkNotNullParameter((Object)rawBuffer, (String)"rawBuffer");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return new Frame(rawBuffer, pts, dts, isKeyFrame, format);
    }

    public static /* synthetic */ Frame copy$default(Frame frame, ByteBuffer byteBuffer, long l, Long l2, boolean bl, MediaFormat mediaFormat, int n, Object object) {
        if ((n & 1) != 0) {
            byteBuffer = frame.rawBuffer;
        }
        if ((n & 2) != 0) {
            l = frame.pts;
        }
        if ((n & 4) != 0) {
            l2 = frame.dts;
        }
        if ((n & 8) != 0) {
            bl = frame.isKeyFrame;
        }
        if ((n & 0x10) != 0) {
            mediaFormat = frame.format;
        }
        return frame.copy(byteBuffer, l, l2, bl, mediaFormat);
    }

    @NotNull
    public String toString() {
        return "Frame(rawBuffer=" + this.rawBuffer + ", pts=" + this.pts + ", dts=" + this.dts + ", isKeyFrame=" + this.isKeyFrame + ", format=" + this.format + ')';
    }

    public int hashCode() {
        int result = this.rawBuffer.hashCode();
        result = result * 31 + Long.hashCode(this.pts);
        result = result * 31 + (this.dts == null ? 0 : ((Object)this.dts).hashCode());
        result = result * 31 + Boolean.hashCode(this.isKeyFrame);
        result = result * 31 + this.format.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Frame)) {
            return false;
        }
        Frame frame = (Frame)other;
        if (!Intrinsics.areEqual((Object)this.rawBuffer, (Object)frame.rawBuffer)) {
            return false;
        }
        if (this.pts != frame.pts) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.dts, (Object)frame.dts)) {
            return false;
        }
        if (this.isKeyFrame != frame.isKeyFrame) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.format, (Object)frame.format);
    }
}

