/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.flv;

import io.github.thibaultbee.streampack.data.Config;
import io.github.thibaultbee.streampack.internal.data.Frame;
import io.github.thibaultbee.streampack.internal.data.Packet;
import io.github.thibaultbee.streampack.internal.data.PacketType;
import io.github.thibaultbee.streampack.internal.muxers.IMuxer;
import io.github.thibaultbee.streampack.internal.muxers.IMuxerListener;
import io.github.thibaultbee.streampack.internal.muxers.flv.FlvMuxerHelper;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.AVTagsFactory;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.FlvHeader;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.FlvTag;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.OnMetadata;
import io.github.thibaultbee.streampack.internal.orientation.ISourceOrientationProvider;
import io.github.thibaultbee.streampack.internal.utils.TimeUtils;
import io.github.thibaultbee.streampack.internal.utils.extensions.StringExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B+\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\"\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020%0$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020%H\u0016J\b\u0010,\u001a\u00020(H\u0016J\b\u0010-\u001a\u00020(H\u0002J\b\u0010.\u001a\u00020(H\u0016J\b\u0010/\u001a\u00020(H\u0016R\u0014\u0010\n\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010 R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/FlvMuxer;", "Lio/github/thibaultbee/streampack/internal/muxers/IMuxer;", "listener", "Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;", "initialStreams", "", "Lio/github/thibaultbee/streampack/data/Config;", "writeToFile", "", "(Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;Ljava/util/List;Z)V", "hasAudio", "getHasAudio", "()Z", "hasFirstFrame", "hasVideo", "getHasVideo", "helper", "Lio/github/thibaultbee/streampack/internal/muxers/flv/FlvMuxerHelper;", "getHelper", "()Lio/github/thibaultbee/streampack/internal/muxers/flv/FlvMuxerHelper;", "getListener", "()Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;", "setListener", "(Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;)V", "sourceOrientationProvider", "Lio/github/thibaultbee/streampack/internal/orientation/ISourceOrientationProvider;", "getSourceOrientationProvider", "()Lio/github/thibaultbee/streampack/internal/orientation/ISourceOrientationProvider;", "setSourceOrientationProvider", "(Lio/github/thibaultbee/streampack/internal/orientation/ISourceOrientationProvider;)V", "startUpTime", "", "Ljava/lang/Long;", "streams", "", "addStreams", "", "", "streamsConfig", "encode", "", "frame", "Lio/github/thibaultbee/streampack/internal/data/Frame;", "streamPid", "release", "requireStreams", "startStream", "stopStream", "core_release"})
@SourceDebugExtension(value={"SMAP\nFlvMuxer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlvMuxer.kt\nio/github/thibaultbee/streampack/internal/muxers/flv/FlvMuxer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1#2:136\n1747#3,3:137\n1747#3,3:140\n1855#3,2:143\n1864#3,3:145\n1774#3,4:148\n1774#3,4:152\n*S KotlinDebug\n*F\n+ 1 FlvMuxer.kt\nio/github/thibaultbee/streampack/internal/muxers/flv/FlvMuxer\n*L\n40#1:137,3\n42#1:140,3\n76#1:143,2\n93#1:145,3\n131#1:148,4\n132#1:152,4\n*E\n"})
public final class FlvMuxer
implements IMuxer {
    @Nullable
    private IMuxerListener listener;
    private final boolean writeToFile;
    @NotNull
    private final FlvMuxerHelper helper;
    @NotNull
    private final List<Config> streams;
    @Nullable
    private Long startUpTime;
    private boolean hasFirstFrame;
    @Nullable
    private ISourceOrientationProvider sourceOrientationProvider;

    public FlvMuxer(@Nullable IMuxerListener listener, @Nullable List<? extends Config> initialStreams, boolean writeToFile) {
        block0: {
            this.listener = listener;
            this.writeToFile = writeToFile;
            this.helper = new FlvMuxerHelper();
            this.streams = new ArrayList();
            List<? extends Config> list = initialStreams;
            if (list == null) break block0;
            List<? extends Config> it = list;
            boolean bl = false;
            this.streams.addAll((Collection<Config>)it);
        }
    }

    public /* synthetic */ FlvMuxer(IMuxerListener iMuxerListener, List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            iMuxerListener = null;
        }
        if ((n & 2) != 0) {
            list = null;
        }
        this(iMuxerListener, list, bl);
    }

    @Override
    @Nullable
    public IMuxerListener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(@Nullable IMuxerListener iMuxerListener) {
        this.listener = iMuxerListener;
    }

    @Override
    @NotNull
    public FlvMuxerHelper getHelper() {
        return this.helper;
    }

    private final boolean getHasAudio() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.streams;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Config it = (Config)element$iv;
                    boolean bl2 = false;
                    if (!StringExtensionsKt.isAudio(it.getMimeType())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean getHasVideo() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.streams;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Config it = (Config)element$iv;
                    boolean bl2 = false;
                    if (!StringExtensionsKt.isVideo(it.getMimeType())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public ISourceOrientationProvider getSourceOrientationProvider() {
        return this.sourceOrientationProvider;
    }

    @Override
    public void setSourceOrientationProvider(@Nullable ISourceOrientationProvider iSourceOrientationProvider) {
        this.sourceOrientationProvider = iSourceOrientationProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void encode(@NotNull Frame frame, int streamPid) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        if (!this.hasFirstFrame) {
            if (this.getHasVideo()) {
                if (!frame.isVideo() || !frame.isKeyFrame()) return;
                this.startUpTime = frame.getPts();
                this.hasFirstFrame = true;
            } else {
                this.startUpTime = frame.getPts();
                this.hasFirstFrame = true;
            }
        }
        long l = frame.getPts();
        Long l2 = this.startUpTime;
        Intrinsics.checkNotNull((Object)l2);
        if (l < l2) {
            return;
        }
        long l3 = frame.getPts();
        Long l4 = this.startUpTime;
        Intrinsics.checkNotNull((Object)l4);
        frame.setPts(l3 - l4);
        List<FlvTag> flvTags = new AVTagsFactory(frame, this.streams.get(streamPid)).build();
        Iterable $this$forEach$iv = flvTags;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FlvTag it = (FlvTag)element$iv;
            boolean bl = false;
            IMuxerListener iMuxerListener = this.getListener();
            if (iMuxerListener == null) continue;
            iMuxerListener.onOutputFrame(new Packet(it.write(), frame.getPts(), frame.isVideo() ? PacketType.VIDEO : PacketType.AUDIO));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Config, Integer> addStreams(@NotNull List<? extends Config> streamsConfig) {
        Intrinsics.checkNotNullParameter(streamsConfig, (String)"streamsConfig");
        Map streamMap = new LinkedHashMap();
        this.streams.addAll((Collection<Config>)streamsConfig);
        this.requireStreams();
        Iterable $this$forEachIndexed$iv = this.streams;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void config;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Config config2 = (Config)item$iv;
            int index = n;
            boolean bl = false;
            Integer n2 = index;
            streamMap.put(config, n2);
        }
        return streamMap;
    }

    @Override
    public void startStream() {
        block2: {
            if (this.writeToFile) {
                IMuxerListener iMuxerListener = this.getListener();
                if (iMuxerListener != null) {
                    iMuxerListener.onOutputFrame(new Packet(new FlvHeader(this.getHasAudio(), this.getHasVideo()).write(), 0L, null, 4, null));
                }
            }
            IMuxerListener iMuxerListener = this.getListener();
            if (iMuxerListener == null) break block2;
            iMuxerListener.onOutputFrame(new Packet(OnMetadata.Companion.fromConfigs(this.streams, this.getSourceOrientationProvider()).write(), TimeUtils.INSTANCE.currentTime(), null, 4, null));
        }
    }

    @Override
    public void stopStream() {
        this.startUpTime = null;
        this.hasFirstFrame = false;
        this.streams.clear();
    }

    @Override
    public void release() {
    }

    /*
     * WARNING - void declaration
     */
    private final void requireStreams() {
        boolean bl;
        Config it;
        int count$iv;
        int n;
        Iterable $this$count$iv = this.streams;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (Config)element$iv;
                boolean bl2 = false;
                if (!StringExtensionsKt.isAudio(it.getMimeType()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        if (!(n <= 1)) {
            boolean $i$a$-require-FlvMuxer$requireStreams$32 = false;
            String $i$a$-require-FlvMuxer$requireStreams$32 = "Only one audio stream is supported by FLV";
            throw new IllegalArgumentException($i$a$-require-FlvMuxer$requireStreams$32.toString());
        }
        $this$count$iv = this.streams;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            bl = false;
        } else {
            void var3_5;
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (Config)element$iv;
                boolean bl3 = false;
                if (!StringExtensionsKt.isVideo(it.getMimeType()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            bl = var3_5;
        }
        if (!(bl <= true)) {
            boolean bl4 = false;
            String string2 = "Only one video stream is supported by FLV";
            throw new IllegalArgumentException(string2.toString());
        }
    }
}

