/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.flv.tags;

import io.github.thibaultbee.streampack.data.AudioConfig;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.AACPacketType;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.FlvTag;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.SoundFormat;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.SoundRate;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.SoundSize;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.SoundType;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.TagType;
import io.github.thibaultbee.streampack.internal.utils.av.audio.AudioSpecificConfig;
import io.github.thibaultbee.streampack.internal.utils.extensions.ByteBufferExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u00020\fH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0014J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0014R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/AudioTag;", "Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/FlvTag;", "pts", "", "frameBuffer", "Ljava/nio/ByteBuffer;", "aacPacketType", "Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/AACPacketType;", "audioConfig", "Lio/github/thibaultbee/streampack/data/AudioConfig;", "(JLjava/nio/ByteBuffer;Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/AACPacketType;Lio/github/thibaultbee/streampack/data/AudioConfig;)V", "bodySize", "", "getBodySize", "()I", "tagHeaderSize", "getTagHeaderSize", "computeHeaderSize", "writeBody", "", "output", "writeTagHeader", "Companion", "core_release"})
public final class AudioTag
extends FlvTag {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBuffer frameBuffer;
    @Nullable
    private final AACPacketType aacPacketType;
    @NotNull
    private final AudioConfig audioConfig;
    private final int tagHeaderSize;
    private final int bodySize;
    private static final int AUDIO_TAG_HEADER_SIZE = 1;

    public AudioTag(long pts, @NotNull ByteBuffer frameBuffer, @Nullable AACPacketType aacPacketType, @NotNull AudioConfig audioConfig) {
        Intrinsics.checkNotNullParameter((Object)frameBuffer, (String)"frameBuffer");
        Intrinsics.checkNotNullParameter((Object)audioConfig, (String)"audioConfig");
        super(pts, TagType.AUDIO, false, 4, null);
        this.frameBuffer = frameBuffer;
        this.aacPacketType = aacPacketType;
        this.audioConfig = audioConfig;
        this.tagHeaderSize = this.computeHeaderSize();
        this.bodySize = this.frameBuffer.remaining();
    }

    @Override
    protected void writeTagHeader(@NotNull ByteBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        ByteBufferExtensionsKt.put(output, SoundFormat.Companion.fromMimeType(this.audioConfig.getMimeType()).getValue() << 4 | SoundRate.Companion.fromSampleRate(this.audioConfig.getSampleRate()).getValue() << 2 | SoundSize.Companion.fromByteFormat(this.audioConfig.getByteFormat()).getValue() << 1 | SoundType.Companion.fromChannelConfig(this.audioConfig.getChannelConfig()).getValue());
        if (Intrinsics.areEqual((Object)this.audioConfig.getMimeType(), (Object)"audio/mp4a-latm")) {
            AACPacketType aACPacketType = this.aacPacketType;
            Intrinsics.checkNotNull((Object)((Object)aACPacketType));
            ByteBufferExtensionsKt.put(output, aACPacketType.getValue());
        }
    }

    @Override
    protected int getTagHeaderSize() {
        return this.tagHeaderSize;
    }

    private final int computeHeaderSize() {
        int size2 = 1;
        if (Intrinsics.areEqual((Object)this.audioConfig.getMimeType(), (Object)"audio/mp4a-latm")) {
            ++size2;
        }
        return size2;
    }

    @Override
    protected void writeBody(@NotNull ByteBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (Intrinsics.areEqual((Object)this.audioConfig.getMimeType(), (Object)"audio/mp4a-latm")) {
            if (this.aacPacketType == AACPacketType.SEQUENCE_HEADER) {
                AudioSpecificConfig.Companion.writeFromByteBuffer(output, this.frameBuffer, this.audioConfig);
            } else {
                output.put(this.frameBuffer);
            }
        } else {
            output.put(this.frameBuffer);
        }
    }

    @Override
    protected int getBodySize() {
        return this.bodySize;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/AudioTag$Companion;", "", "()V", "AUDIO_TAG_HEADER_SIZE", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

