/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.mp4.boxes;

import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.FullBox;
import io.github.thibaultbee.streampack.internal.utils.extensions.ByteBufferExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/HandlerBox;", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/FullBox;", "type", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/HandlerBox$HandlerType;", "name", "", "(Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/HandlerBox$HandlerType;Ljava/lang/String;)V", "size", "", "getSize", "()I", "write", "", "output", "Ljava/nio/ByteBuffer;", "HandlerType", "core_release"})
public final class HandlerBox
extends FullBox {
    @NotNull
    private final HandlerType type;
    @NotNull
    private final String name;
    private final int size;

    public HandlerBox(@NotNull HandlerType type, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super("hdlr", (byte)0, 0, false, 8, null);
        this.type = type;
        this.name = name;
        this.size = super.getSize() + this.type.getValue().length() + this.name.length() + 17;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void write(@NotNull ByteBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super.write(output);
        output.putInt(0);
        ByteBufferExtensionsKt.putString(output, this.type.getValue());
        output.put(new byte[12]);
        ByteBufferExtensionsKt.putString(output, this.name);
        output.put((byte)0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/HandlerBox$HandlerType;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "VIDEO", "AUXILIARY_VIDEO", "SOUND", "core_release"})
    public static final class HandlerType
    extends Enum<HandlerType> {
        @NotNull
        private final String value;
        public static final /* enum */ HandlerType VIDEO = new HandlerType("vide");
        public static final /* enum */ HandlerType AUXILIARY_VIDEO = new HandlerType("auxv");
        public static final /* enum */ HandlerType SOUND = new HandlerType("soun");
        private static final /* synthetic */ HandlerType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private HandlerType(String value) {
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public static HandlerType[] values() {
            return (HandlerType[])$VALUES.clone();
        }

        public static HandlerType valueOf(String value) {
            return Enum.valueOf(HandlerType.class, value);
        }

        @NotNull
        public static EnumEntries<HandlerType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = handlerTypeArray = new HandlerType[]{HandlerType.VIDEO, HandlerType.AUXILIARY_VIDEO, HandlerType.SOUND};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

