/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.ts.packets;

import io.github.thibaultbee.streampack.internal.muxers.IMuxerListener;
import io.github.thibaultbee.streampack.internal.muxers.ts.packets.TS;
import io.github.thibaultbee.streampack.internal.muxers.ts.packets.TableHeader;
import io.github.thibaultbee.streampack.internal.muxers.ts.utils.CRC32;
import io.github.thibaultbee.streampack.internal.utils.extensions.ByteBufferExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB]\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\f\u001a\u00020\u0007\u0012\b\b\u0002\u0010\r\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0015H\u0004R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/ts/packets/Psi;", "Lio/github/thibaultbee/streampack/internal/muxers/ts/packets/TS;", "listener", "Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;", "pid", "", "tableId", "", "sectionSyntaxIndicator", "", "reservedFutureUse", "tableIdExtension", "versionNumber", "sectionNumber", "lastSectionNumber", "(Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;SBZZSBBB)V", "getVersionNumber", "()B", "setVersionNumber", "(B)V", "toByteBuffer", "Ljava/nio/ByteBuffer;", "payload", "write", "", "buffer", "Companion", "core_release"})
public class Psi
extends TS {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final byte tableId;
    private final boolean sectionSyntaxIndicator;
    private final boolean reservedFutureUse;
    private final short tableIdExtension;
    private byte versionNumber;
    private final byte sectionNumber;
    private final byte lastSectionNumber;
    public static final int CRC_SIZE = 4;
    public static final int PSI_HEADER_SIZE = 9;

    public Psi(@Nullable IMuxerListener listener, short pid, byte tableId, boolean sectionSyntaxIndicator, boolean reservedFutureUse, short tableIdExtension, byte versionNumber, byte sectionNumber, byte lastSectionNumber) {
        super(listener, pid, false, false, (byte)0, (byte)0, 60, null);
        this.tableId = tableId;
        this.sectionSyntaxIndicator = sectionSyntaxIndicator;
        this.reservedFutureUse = reservedFutureUse;
        this.tableIdExtension = tableIdExtension;
        this.versionNumber = versionNumber;
        this.sectionNumber = sectionNumber;
        this.lastSectionNumber = lastSectionNumber;
    }

    public /* synthetic */ Psi(IMuxerListener iMuxerListener, short s, byte by, boolean bl, boolean bl2, short s2, byte by2, byte by3, byte by4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            iMuxerListener = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            s2 = 0;
        }
        if ((n & 0x40) != 0) {
            by2 = 0;
        }
        if ((n & 0x80) != 0) {
            by3 = 0;
        }
        if ((n & 0x100) != 0) {
            by4 = 0;
        }
        this(iMuxerListener, s, by, bl, bl2, s2, by2, by3, by4);
    }

    public final byte getVersionNumber() {
        return this.versionNumber;
    }

    public final void setVersionNumber(byte by) {
        this.versionNumber = by;
    }

    protected final void write(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        TS.write$default(this, this.toByteBuffer(buffer), null, null, false, 0L, 30, null);
    }

    @NotNull
    public final ByteBuffer toByteBuffer(@NotNull ByteBuffer payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        ByteBuffer table = ByteBuffer.allocate(payload.limit() + 9 + 4);
        table.put((byte)0);
        byte by = this.tableId;
        short s = (short)payload.remaining();
        short s2 = this.tableIdExtension;
        boolean bl = this.sectionSyntaxIndicator;
        boolean bl2 = this.reservedFutureUse;
        byte by2 = this.versionNumber;
        byte by3 = this.sectionNumber;
        byte by4 = this.lastSectionNumber;
        TableHeader tableHeader = new TableHeader(by, bl, bl2, s, s2, by2, false, by3, by4, 64, null);
        table.put(tableHeader.toByteBuffer());
        table.put(payload);
        Intrinsics.checkNotNull((Object)table);
        int crc32 = CRC32.INSTANCE.get(table, 1, table.position());
        ByteBufferExtensionsKt.put(table, crc32 >> 24 & 0xFF);
        ByteBufferExtensionsKt.put(table, crc32 >> 16 & 0xFF);
        ByteBufferExtensionsKt.put(table, crc32 >> 8 & 0xFF);
        ByteBufferExtensionsKt.put(table, crc32 & 0xFF);
        table.rewind();
        return table;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/ts/packets/Psi$Companion;", "", "()V", "CRC_SIZE", "", "PSI_HEADER_SIZE", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

