/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils.av.buffer;

import io.github.thibaultbee.streampack.internal.utils.extensions.BitOperationExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0017\u001a\u00020\u0005J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\b\u0010\u001b\u001a\u00020\u0005H\u0002J\u0006\u0010\u001c\u001a\u00020\u0012J\u000e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u0002\u001a\u00020\u0000J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0012J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00192\b\b\u0002\u0010%\u001a\u00020\u0005J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u00052\b\b\u0002\u0010%\u001a\u00020\u0005J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020!2\b\b\u0002\u0010%\u001a\u00020\u0005R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\t\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\t\u00a8\u0006&"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/buffer/BitBuffer;", "", "buffer", "Ljava/nio/ByteBuffer;", "bitPosition", "", "bitEnd", "(Ljava/nio/ByteBuffer;II)V", "getBitEnd", "()I", "getBitPosition", "setBitPosition", "(I)V", "bitRemaining", "getBitRemaining", "getBuffer", "()Ljava/nio/ByteBuffer;", "hasRemaining", "", "getHasRemaining", "()Z", "remaining", "getRemaining", "align", "get", "", "i", "get1Bit", "getBoolean", "getInt", "getLong", "", "getShort", "", "put", "", "b", "numBits", "core_release"})
@SourceDebugExtension(value={"SMAP\nBitBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitBuffer.kt\nio/github/thibaultbee/streampack/internal/utils/av/buffer/BitBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1#2:143\n*E\n"})
public class BitBuffer {
    @NotNull
    private final ByteBuffer buffer;
    private int bitPosition;
    private final int bitEnd;

    public BitBuffer(@NotNull ByteBuffer buffer, int bitPosition, int bitEnd) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        this.bitPosition = bitPosition;
        this.bitEnd = bitEnd;
        if (!(this.bitPosition >= 0)) {
            boolean $i$a$-require-BitBuffer$42 = false;
            String $i$a$-require-BitBuffer$42 = "bitPosition must be >= 0";
            throw new IllegalArgumentException($i$a$-require-BitBuffer$42.toString());
        }
        if (!(this.bitEnd >= 0)) {
            boolean $i$a$-require-BitBuffer$52 = false;
            String $i$a$-require-BitBuffer$52 = "bitSize must be >= 0";
            throw new IllegalArgumentException($i$a$-require-BitBuffer$52.toString());
        }
        if (!(this.buffer.limit() * 8 >= this.bitEnd)) {
            boolean bl = false;
            String string2 = "Buffer must be longer then buffer end";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public /* synthetic */ BitBuffer(ByteBuffer byteBuffer, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = byteBuffer.position() * 8;
        }
        if ((n3 & 4) != 0) {
            n2 = byteBuffer.limit() * 8 - 1;
        }
        this(byteBuffer, n, n2);
    }

    @NotNull
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    public final int getBitPosition() {
        return this.bitPosition;
    }

    public final void setBitPosition(int n) {
        this.bitPosition = n;
    }

    public final int getBitEnd() {
        return this.bitEnd;
    }

    public final boolean getHasRemaining() {
        return this.getBitRemaining() > 0;
    }

    public final int getBitRemaining() {
        return this.bitEnd - this.bitPosition + 1;
    }

    public final int getRemaining() {
        return (int)Math.ceil((float)this.getBitRemaining() / (float)8);
    }

    public final boolean getBoolean() {
        return this.get1Bit() == 1;
    }

    private final int get1Bit() {
        return this.getInt(1);
    }

    public final byte get(int i) {
        return (byte)this.getLong(i);
    }

    public final short getShort(int i) {
        return (short)this.getLong(i);
    }

    public final int getInt(int i) {
        return (int)this.getLong(i);
    }

    public final long getLong(int i) {
        if (!this.getHasRemaining()) {
            throw new IllegalStateException("No more bits to read");
        }
        int b = this.buffer.get(this.bitPosition / 8);
        int v = b < 0 ? b + 256 : b;
        int left = 8 - this.bitPosition % 8;
        long rc = 0L;
        if (i <= left) {
            rc = (v << this.bitPosition % 8 & 0xFF) >> this.bitPosition % 8 + (left - i);
            this.bitPosition += i;
        } else {
            int then = i - left;
            rc = this.getLong(left);
            rc <<= then;
            rc += this.getLong(then);
        }
        this.buffer.position((int)Math.ceil((double)this.bitPosition / (double)8));
        return rc;
    }

    public final void put(boolean b) {
        this.put(BitOperationExtensionsKt.toInt(b), 1);
    }

    public final void put(int i, int numBits) {
        if (!this.getHasRemaining()) {
            throw new IllegalStateException("No more bits to write");
        }
        int left = 8 - this.bitPosition % 8;
        if (numBits <= left) {
            int currentPos = this.bitPosition / 8;
            int current = this.buffer.get(currentPos);
            current = current < 0 ? current + 256 : current;
            this.buffer.put(currentPos, (byte)((current += i << left - numBits) > 127 ? current - 256 : current));
            this.bitPosition += numBits;
        } else {
            int bitsSecondWrite = numBits - left;
            this.put(i >> bitsSecondWrite, left);
            this.put(i & (1 << bitsSecondWrite) - 1, bitsSecondWrite);
        }
        this.buffer.position((int)Math.ceil((double)this.bitPosition / (double)8));
    }

    public static /* synthetic */ void put$default(BitBuffer bitBuffer, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: put");
        }
        if ((n3 & 2) != 0) {
            n2 = 32;
        }
        bitBuffer.put(n, n2);
    }

    public final void put(short b, int numBits) {
        this.put(b < 0 ? b + 256 : b, numBits);
    }

    public static /* synthetic */ void put$default(BitBuffer bitBuffer, short s, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: put");
        }
        if ((n2 & 2) != 0) {
            n = 8;
        }
        bitBuffer.put(s, n);
    }

    public final void put(byte b, int numBits) {
        this.put(b < 0 ? b + 256 : b, numBits);
    }

    public static /* synthetic */ void put$default(BitBuffer bitBuffer, byte by, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: put");
        }
        if ((n2 & 2) != 0) {
            n = 8;
        }
        bitBuffer.put(by, n);
    }

    public final void put(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        while (buffer.hasRemaining()) {
            BitBuffer.put$default(this, buffer.get(), 0, 2, null);
        }
    }

    public final void put(@NotNull BitBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        while (buffer.getBitRemaining() > 8) {
            this.put(buffer.get(8), 8);
        }
        if (buffer.getHasRemaining()) {
            int bitRemaining = buffer.getBitRemaining();
            this.put(buffer.get(bitRemaining), bitRemaining);
        }
    }

    public final int align() {
        int left = 8 - this.bitPosition % 8;
        if (left == 8) {
            left = 0;
        }
        this.getLong(left);
        return left;
    }
}

