/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.utils;

import android.content.Context;
import android.graphics.Rect;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.os.Build;
import android.util.Range;
import androidx.annotation.RequiresApi;
import io.github.thibaultbee.streampack.internal.sources.camera.CameraController;
import io.github.thibaultbee.streampack.internal.utils.extensions.ExtensionsKt;
import io.github.thibaultbee.streampack.utils.ContextExtensionsForCameraKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000  2\u00020\u0001:\u0003 !\"B\u0017\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tJ\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\u00020\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u0082\u0001\u0002#$\u00a8\u0006%"}, d2={"Lio/github/thibaultbee/streampack/utils/Zoom;", "", "context", "Landroid/content/Context;", "cameraController", "Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;", "(Landroid/content/Context;Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;)V", "availableRatioRange", "Landroid/util/Range;", "", "getAvailableRatioRange", "()Landroid/util/Range;", "getCameraController", "()Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;", "getContext", "()Landroid/content/Context;", "cropSensorRegion", "Landroid/graphics/Rect;", "getCropSensorRegion$core_release", "()Landroid/graphics/Rect;", "zoomRatio", "getZoomRatio", "()F", "setZoomRatio", "(F)V", "onPinch", "", "scale", "speedUpZoomByX", "scaleFactor", "ratio", "", "Companion", "CropScalerRegionZoom", "RZoom", "Lio/github/thibaultbee/streampack/utils/Zoom$CropScalerRegionZoom;", "Lio/github/thibaultbee/streampack/utils/Zoom$RZoom;", "core_release"})
public abstract class Zoom {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final CameraController cameraController;
    public static final float DEFAULT_ZOOM_RATIO = 1.0f;
    @NotNull
    private static final Range<Float> DEFAULT_ZOOM_RATIO_RANGE = new Range((Comparable)Float.valueOf(1.0f), (Comparable)Float.valueOf(1.0f));

    private Zoom(Context context, CameraController cameraController) {
        this.context = context;
        this.cameraController = cameraController;
    }

    @NotNull
    protected final Context getContext() {
        return this.context;
    }

    @NotNull
    protected final CameraController getCameraController() {
        return this.cameraController;
    }

    @NotNull
    public abstract Range<Float> getAvailableRatioRange();

    @NotNull
    public abstract Rect getCropSensorRegion$core_release();

    public abstract float getZoomRatio();

    public abstract void setZoomRatio(float var1);

    public final void onPinch(float scale) {
        float scaledRatio = this.getZoomRatio() * this.speedUpZoomByX(scale, 2);
        Comparable comparable = Float.valueOf(scaledRatio);
        Comparable comparable2 = this.getAvailableRatioRange().getLower();
        Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"getLower(...)");
        Comparable comparable3 = this.getAvailableRatioRange().getUpper();
        Intrinsics.checkNotNullExpressionValue((Object)comparable3, (String)"getUpper(...)");
        this.setZoomRatio(((Number)((Object)ExtensionsKt.clamp(comparable, comparable2, comparable3))).floatValue());
    }

    private final float speedUpZoomByX(float scaleFactor, int ratio) {
        return scaleFactor > 1.0f ? 1.0f + (scaleFactor - 1.0f) * (float)ratio : 1.0f - (1.0f - scaleFactor) * (float)ratio;
    }

    public /* synthetic */ Zoom(Context context, CameraController cameraController, DefaultConstructorMarker $constructor_marker) {
        this(context, cameraController);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00040\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lio/github/thibaultbee/streampack/utils/Zoom$Companion;", "", "()V", "DEFAULT_ZOOM_RATIO", "", "DEFAULT_ZOOM_RATIO_RANGE", "Landroid/util/Range;", "kotlin.jvm.PlatformType", "getDEFAULT_ZOOM_RATIO_RANGE", "()Landroid/util/Range;", "build", "Lio/github/thibaultbee/streampack/utils/Zoom;", "context", "Landroid/content/Context;", "cameraController", "Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Range<Float> getDEFAULT_ZOOM_RATIO_RANGE() {
            return DEFAULT_ZOOM_RATIO_RANGE;
        }

        @NotNull
        public final Zoom build(@NotNull Context context, @NotNull CameraController cameraController) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)cameraController, (String)"cameraController");
            return Build.VERSION.SDK_INT >= 30 ? (Zoom)new RZoom(context, cameraController) : (Zoom)new CropScalerRegionZoom(context, cameraController);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lio/github/thibaultbee/streampack/utils/Zoom$CropScalerRegionZoom;", "Lio/github/thibaultbee/streampack/utils/Zoom;", "context", "Landroid/content/Context;", "cameraController", "Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;", "(Landroid/content/Context;Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;)V", "availableRatioRange", "Landroid/util/Range;", "", "getAvailableRatioRange", "()Landroid/util/Range;", "cropSensorRegion", "Landroid/graphics/Rect;", "getCropSensorRegion$core_release", "()Landroid/graphics/Rect;", "currentCropRect", "persistentZoomRatio", "value", "zoomRatio", "getZoomRatio", "()F", "setZoomRatio", "(F)V", "Companion", "core_release"})
    public static final class CropScalerRegionZoom
    extends Zoom {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private float persistentZoomRatio;
        @Nullable
        private Rect currentCropRect;

        public CropScalerRegionZoom(@NotNull Context context, @NotNull CameraController cameraController) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)cameraController, (String)"cameraController");
            super(context, cameraController, null);
            this.persistentZoomRatio = 1.0f;
        }

        @Override
        @NotNull
        public Range<Float> getAvailableRatioRange() {
            Range range;
            String string2 = this.getCameraController().getCameraId();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                range = new Range((Comparable)Float.valueOf(1.0f), (Comparable)Float.valueOf(ContextExtensionsForCameraKt.getScalerMaxZoom(this.getContext(), it)));
            } else {
                range = Companion.getDEFAULT_ZOOM_RATIO_RANGE();
            }
            return range;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public float getZoomRatio() {
            float f;
            CropScalerRegionZoom cropScalerRegionZoom = this;
            synchronized (cropScalerRegionZoom) {
                boolean bl = false;
                f = this.persistentZoomRatio;
            }
            return f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setZoomRatio(float value) {
            CropScalerRegionZoom cropScalerRegionZoom = this;
            synchronized (cropScalerRegionZoom) {
                boolean bl = false;
                float clampedValue = ((Number)ExtensionsKt.clamp((Comparable)Float.valueOf(value), this.getAvailableRatioRange())).floatValue();
                String string2 = this.getCameraController().getCameraId();
                if (string2 != null) {
                    String cameraId2 = string2;
                    boolean bl2 = false;
                    this.currentCropRect = CropScalerRegionZoom.Companion.getCropRegion(ContextExtensionsForCameraKt.getCameraCharacteristics(this.getContext(), cameraId2), clampedValue);
                    CameraController cameraController = this.getCameraController();
                    CaptureRequest.Key key = CaptureRequest.SCALER_CROP_REGION;
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"SCALER_CROP_REGION");
                    cameraController.setRepeatingSetting(key, this.currentCropRect);
                }
                this.persistentZoomRatio = clampedValue;
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Rect getCropSensorRegion$core_release() {
            CropScalerRegionZoom cropScalerRegionZoom = this;
            synchronized (cropScalerRegionZoom) {
                boolean bl = false;
                if (this.currentCropRect == null) {
                    String string2 = this.getCameraController().getCameraId();
                    if (string2 == null) {
                        throw new IllegalStateException("Camera ID is null");
                    }
                    String cameraId2 = string2;
                    Object object = ContextExtensionsForCameraKt.getCameraCharacteristics(this.getContext(), cameraId2).get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
                    Intrinsics.checkNotNull((Object)object);
                    Rect rect = (Rect)object;
                    return rect;
                }
                Rect rect = this.currentCropRect;
                Rect rect2 = rect;
                Intrinsics.checkNotNull((Object)rect);
                Rect rect3 = rect2;
                return rect3;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lio/github/thibaultbee/streampack/utils/Zoom$CropScalerRegionZoom$Companion;", "", "()V", "getCropRegion", "Landroid/graphics/Rect;", "sensorRect", "zoomRatio", "", "characteristics", "Landroid/hardware/camera2/CameraCharacteristics;", "core_release"})
        public static final class Companion {
            private Companion() {
            }

            private final Rect getCropRegion(Rect sensorRect, float zoomRatio) {
                int xCenter = sensorRect.width() / 2;
                int yCenter = sensorRect.height() / 2;
                int xDelta = (int)(0.5f * (float)sensorRect.width() / zoomRatio);
                int yDelta = (int)(0.5f * (float)sensorRect.height() / zoomRatio);
                return new Rect(xCenter - xDelta, yCenter - yDelta, xCenter + xDelta, yCenter + yDelta);
            }

            private final Rect getCropRegion(CameraCharacteristics characteristics, float zoomRatio) {
                Rect rect = (Rect)characteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
                if (rect == null) {
                    throw new IllegalStateException("Sensor rect is null");
                }
                Rect sensorRect = rect;
                return this.getCropRegion(sensorRect, zoomRatio);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lio/github/thibaultbee/streampack/utils/Zoom$RZoom;", "Lio/github/thibaultbee/streampack/utils/Zoom;", "context", "Landroid/content/Context;", "cameraController", "Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;", "(Landroid/content/Context;Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;)V", "availableRatioRange", "Landroid/util/Range;", "", "getAvailableRatioRange", "()Landroid/util/Range;", "cropSensorRegion", "Landroid/graphics/Rect;", "getCropSensorRegion$core_release", "()Landroid/graphics/Rect;", "value", "zoomRatio", "getZoomRatio", "()F", "setZoomRatio", "(F)V", "core_release"})
    @RequiresApi(value=30)
    @SourceDebugExtension(value={"SMAP\nCameraSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraSettings.kt\nio/github/thibaultbee/streampack/utils/Zoom$RZoom\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1049:1\n1#2:1050\n*E\n"})
    public static final class RZoom
    extends Zoom {
        public RZoom(@NotNull Context context, @NotNull CameraController cameraController) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)cameraController, (String)"cameraController");
            super(context, cameraController, null);
        }

        @Override
        @NotNull
        public Range<Float> getAvailableRatioRange() {
            Range<Float> range;
            block3: {
                block2: {
                    range = this.getCameraController().getCameraId();
                    if (range == null) break block2;
                    Range<Float> it = range;
                    boolean bl = false;
                    Range<Float> range2 = ContextExtensionsForCameraKt.getZoomRatioRange(this.getContext(), it);
                    range = range2;
                    if (range2 != null) break block3;
                }
                range = Companion.getDEFAULT_ZOOM_RATIO_RANGE();
            }
            return range;
        }

        @Override
        public float getZoomRatio() {
            Float f = (Float)this.getCameraController().getSetting(CaptureRequest.CONTROL_ZOOM_RATIO);
            return f != null ? f.floatValue() : 1.0f;
        }

        @Override
        public void setZoomRatio(float value) {
            CameraController cameraController = this.getCameraController();
            CaptureRequest.Key key = CaptureRequest.CONTROL_ZOOM_RATIO;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_ZOOM_RATIO");
            cameraController.setRepeatingSetting(key, ExtensionsKt.clamp((Comparable)Float.valueOf(value), this.getAvailableRatioRange()));
        }

        @Override
        @NotNull
        public Rect getCropSensorRegion$core_release() {
            String string2 = this.getCameraController().getCameraId();
            if (string2 == null) {
                throw new IllegalStateException("Camera ID is null");
            }
            String cameraId2 = string2;
            Object object = ContextExtensionsForCameraKt.getCameraCharacteristics(this.getContext(), cameraId2).get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
            Intrinsics.checkNotNull((Object)object);
            return (Rect)object;
        }
    }
}

