/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.sources;

import android.media.AudioRecord;
import android.media.AudioTimestamp;
import android.media.MediaFormat;
import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.NoiseSuppressor;
import android.os.Build;
import androidx.annotation.RequiresPermission;
import io.github.thibaultbee.streampack.data.AudioConfig;
import io.github.thibaultbee.streampack.internal.data.Frame;
import io.github.thibaultbee.streampack.internal.sources.IAudioSource;
import io.github.thibaultbee.streampack.internal.utils.TimeUtils;
import io.github.thibaultbee.streampack.logger.ILogger;
import io.github.thibaultbee.streampack.logger.Logger;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u001c\u001a\u00020\u0006H\u0002J\b\u0010\u001d\u001a\u00020\u0013H\u0016J\b\u0010\u001e\u001a\u00020\u0013H\u0016J\b\u0010\u001f\u001a\u00020\u0013H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/github/thibaultbee/streampack/internal/sources/AudioSource;", "Lio/github/thibaultbee/streampack/internal/sources/IAudioSource;", "()V", "audioRecord", "Landroid/media/AudioRecord;", "isMuted", "", "()Z", "setMuted", "(Z)V", "mutedByteArray", "", "processor", "Lio/github/thibaultbee/streampack/internal/sources/AudioSource$EffectProcessor;", "audioRecordErrorToString", "", "audioRecordError", "", "configure", "", "config", "Lio/github/thibaultbee/streampack/data/AudioConfig;", "getFrame", "Lio/github/thibaultbee/streampack/internal/data/Frame;", "buffer", "Ljava/nio/ByteBuffer;", "getTimestamp", "", "isRunning", "release", "startStream", "stopStream", "Companion", "EffectProcessor", "core_release"})
public final class AudioSource
implements IAudioSource {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private AudioRecord audioRecord;
    @Nullable
    private EffectProcessor processor;
    @Nullable
    private byte[] mutedByteArray;
    private boolean isMuted;
    @NotNull
    private static final String TAG = "AudioSource";
    @NotNull
    private static final MediaFormat format;

    @Override
    public boolean isMuted() {
        return this.isMuted;
    }

    @Override
    public void setMuted(boolean bl) {
        this.isMuted = bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    public void configure(@NotNull AudioConfig config) {
        void it;
        AudioRecord audioRecord;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        int bufferSize = AudioRecord.getMinBufferSize((int)config.getSampleRate(), (int)config.getChannelConfig(), (int)config.getByteFormat());
        if (bufferSize <= 0) {
            throw new IllegalArgumentException(this.audioRecordErrorToString(bufferSize));
        }
        this.mutedByteArray = new byte[bufferSize];
        AudioRecord audioRecord2 = audioRecord = new AudioRecord(0, config.getSampleRate(), config.getChannelConfig(), config.getByteFormat(), bufferSize);
        AudioSource audioSource = this;
        boolean bl = false;
        this.processor = new EffectProcessor(config.getEnableEchoCanceler(), config.getEnableNoiseSuppressor(), it.getAudioSessionId());
        audioSource.audioRecord = audioRecord;
        AudioRecord audioRecord3 = this.audioRecord;
        if (!(audioRecord3 != null ? audioRecord3.getState() == 1 : false)) {
            throw new IllegalArgumentException("Failed to initialized AudioRecord");
        }
    }

    @Override
    public void startStream() {
        Unit unit;
        AudioRecord audioRecord = this.audioRecord;
        if (audioRecord != null) {
            AudioRecord it = audioRecord;
            boolean bl = false;
            it.startRecording();
            if (!this.isRunning()) {
                throw new IllegalStateException("AudioSource: failed to start recording");
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new IllegalStateException("AudioSource: run: : No audioRecorder");
        }
    }

    private final boolean isRunning() {
        AudioRecord audioRecord = this.audioRecord;
        return audioRecord != null ? audioRecord.getRecordingState() == 3 : false;
    }

    @Override
    public void stopStream() {
        block1: {
            if (!this.isRunning()) {
                ILogger.DefaultImpls.d$default(Logger.INSTANCE, TAG, "Not running", null, 4, null);
                return;
            }
            AudioRecord audioRecord = this.audioRecord;
            if (audioRecord == null) break block1;
            audioRecord.stop();
        }
    }

    @Override
    public void release() {
        this.mutedByteArray = null;
        AudioRecord audioRecord = this.audioRecord;
        if (audioRecord != null) {
            audioRecord.release();
        }
        this.audioRecord = null;
        EffectProcessor effectProcessor = this.processor;
        if (effectProcessor != null) {
            effectProcessor.release();
        }
        this.processor = null;
    }

    private final long getTimestamp(AudioRecord audioRecord) {
        AudioTimestamp timestampOut = new AudioTimestamp();
        long timestamp = -1L;
        if (Build.VERSION.SDK_INT >= 24 && audioRecord.getTimestamp(timestampOut, 0) == 0) {
            timestamp = timestampOut.nanoTime / (long)1000;
        }
        if (timestamp < 0L) {
            timestamp = TimeUtils.INSTANCE.currentTime();
        }
        return timestamp;
    }

    @Override
    @NotNull
    public Frame getFrame(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        AudioRecord audioRecord = this.audioRecord;
        if (audioRecord != null) {
            AudioRecord it = audioRecord;
            boolean bl = false;
            int length = it.read(buffer, buffer.remaining());
            if (length >= 0) {
                Frame frame;
                if (this.isMuted()) {
                    byte[] byArray = this.mutedByteArray;
                    if (!(byArray != null ? length == byArray.length : false)) {
                        this.mutedByteArray = new byte[length];
                    }
                    Intrinsics.checkNotNull((Object)this.mutedByteArray);
                    buffer.put(this.mutedByteArray, 0, length);
                    buffer.clear();
                    frame = new Frame(buffer, this.getTimestamp(it), null, false, format, 12, null);
                } else {
                    frame = new Frame(buffer, this.getTimestamp(it), null, false, format, 12, null);
                }
                return frame;
            }
            throw new IllegalArgumentException(this.audioRecordErrorToString(length));
        }
        throw new IllegalStateException("AudioSource: getFrame: No audioRecorder");
    }

    private final String audioRecordErrorToString(int audioRecordError) {
        String string2;
        switch (audioRecordError) {
            case -3: {
                string2 = "AudioRecord returns an invalid operation error";
                break;
            }
            case -2: {
                string2 = "AudioRecord returns a bad value error";
                break;
            }
            case -6: {
                string2 = "AudioRecord returns a dead object error";
                break;
            }
            default: {
                string2 = "Unknown audio record error: " + audioRecordError;
            }
        }
        return string2;
    }

    static {
        MediaFormat mediaFormat;
        Companion = new Companion(null);
        MediaFormat $this$format_u24lambda_u243 = mediaFormat = new MediaFormat();
        boolean bl = false;
        $this$format_u24lambda_u243.setString("mime", "audio/raw");
        format = mediaFormat;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/github/thibaultbee/streampack/internal/sources/AudioSource$Companion;", "", "()V", "TAG", "", "format", "Landroid/media/MediaFormat;", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\f\u001a\u00020\rR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/github/thibaultbee/streampack/internal/sources/AudioSource$EffectProcessor;", "", "enableAcousticEchoCanceler", "", "enableNoiseSuppressor", "audioSessionId", "", "(ZZI)V", "acousticEchoCanceler", "Landroid/media/audiofx/AcousticEchoCanceler;", "noiseSuppressor", "Landroid/media/audiofx/NoiseSuppressor;", "release", "", "Companion", "core_release"})
    private static final class EffectProcessor {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final AcousticEchoCanceler acousticEchoCanceler;
        @Nullable
        private final NoiseSuppressor noiseSuppressor;

        public EffectProcessor(boolean enableAcousticEchoCanceler, boolean enableNoiseSuppressor, int audioSessionId) {
            this.acousticEchoCanceler = enableAcousticEchoCanceler ? EffectProcessor.Companion.initAcousticEchoCanceler(audioSessionId) : null;
            this.noiseSuppressor = enableNoiseSuppressor ? EffectProcessor.Companion.initNoiseSuppressor(audioSessionId) : null;
        }

        public final void release() {
            block1: {
                AcousticEchoCanceler acousticEchoCanceler = this.acousticEchoCanceler;
                if (acousticEchoCanceler != null) {
                    acousticEchoCanceler.release();
                }
                NoiseSuppressor noiseSuppressor = this.noiseSuppressor;
                if (noiseSuppressor == null) break block1;
                noiseSuppressor.release();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\t"}, d2={"Lio/github/thibaultbee/streampack/internal/sources/AudioSource$EffectProcessor$Companion;", "", "()V", "initAcousticEchoCanceler", "Landroid/media/audiofx/AcousticEchoCanceler;", "audioSessionId", "", "initNoiseSuppressor", "Landroid/media/audiofx/NoiseSuppressor;", "core_release"})
        public static final class Companion {
            private Companion() {
            }

            private final NoiseSuppressor initNoiseSuppressor(int audioSessionId) {
                NoiseSuppressor noiseSuppressor;
                if (!NoiseSuppressor.isAvailable()) {
                    ILogger.DefaultImpls.w$default(Logger.INSTANCE, AudioSource.TAG, "Noise suppressor is not available", null, 4, null);
                    return null;
                }
                try {
                    noiseSuppressor = NoiseSuppressor.create((int)audioSessionId);
                }
                catch (Exception e) {
                    Logger.INSTANCE.e(AudioSource.TAG, "Failed to create noise suppressor", e);
                    return null;
                }
                NoiseSuppressor noiseSuppressor2 = noiseSuppressor;
                if (noiseSuppressor2 == null) {
                    ILogger.DefaultImpls.w$default(Logger.INSTANCE, AudioSource.TAG, "Failed to create noise suppressor", null, 4, null);
                    return null;
                }
                int result = noiseSuppressor2.setEnabled(true);
                if (result != 0) {
                    noiseSuppressor2.release();
                    ILogger.DefaultImpls.w$default(Logger.INSTANCE, AudioSource.TAG, "Failed to enable noise suppressor", null, 4, null);
                    return null;
                }
                return noiseSuppressor2;
            }

            private final AcousticEchoCanceler initAcousticEchoCanceler(int audioSessionId) {
                AcousticEchoCanceler acousticEchoCanceler;
                if (!AcousticEchoCanceler.isAvailable()) {
                    ILogger.DefaultImpls.w$default(Logger.INSTANCE, AudioSource.TAG, "Acoustic echo canceler is not available", null, 4, null);
                    return null;
                }
                try {
                    acousticEchoCanceler = AcousticEchoCanceler.create((int)audioSessionId);
                }
                catch (Exception e) {
                    Logger.INSTANCE.e(AudioSource.TAG, "Failed to create acoustic echo canceler", e);
                    return null;
                }
                AcousticEchoCanceler acousticEchoCanceler2 = acousticEchoCanceler;
                if (acousticEchoCanceler2 == null) {
                    ILogger.DefaultImpls.w$default(Logger.INSTANCE, AudioSource.TAG, "Failed to create acoustic echo canceler", null, 4, null);
                    return null;
                }
                int result = acousticEchoCanceler2.setEnabled(true);
                if (result != 0) {
                    acousticEchoCanceler2.release();
                    ILogger.DefaultImpls.w$default(Logger.INSTANCE, AudioSource.TAG, "Failed to enable acoustic echo canceler", null, 4, null);
                    return null;
                }
                return acousticEchoCanceler2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

