/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.sources.camera;

import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.params.SessionConfiguration;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import io.github.thibaultbee.streampack.internal.sources.camera.ICameraThreadManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0017J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b2\u0006\u0010\r\u001a\u00020\u0015H\u0017J&\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000b2\u0006\u0010\r\u001a\u00020\u0015H\u0017J \u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u001eH\u0017J\b\u0010\u001f\u001a\u00020\u0010H\u0016J \u0010 \u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010!\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/github/thibaultbee/streampack/internal/sources/camera/CameraExecutorManager;", "Lio/github/thibaultbee/streampack/internal/sources/camera/ICameraThreadManager;", "()V", "cameraExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "captureBurstRequests", "", "captureSession", "Landroid/hardware/camera2/CameraCaptureSession;", "captureRequests", "", "Landroid/hardware/camera2/CaptureRequest;", "callback", "Landroid/hardware/camera2/CameraCaptureSession$CaptureCallback;", "createCaptureSession", "", "camera", "Landroid/hardware/camera2/CameraDevice;", "targets", "Landroid/view/Surface;", "Landroid/hardware/camera2/CameraCaptureSession$StateCallback;", "createCaptureSessionByOutputConfiguration", "outputConfigurations", "Landroid/hardware/camera2/params/OutputConfiguration;", "openCamera", "manager", "Landroid/hardware/camera2/CameraManager;", "cameraId", "", "Landroid/hardware/camera2/CameraDevice$StateCallback;", "release", "setRepeatingSingleRequest", "captureRequest", "core_release"})
@SourceDebugExtension(value={"SMAP\nCameraExecutorManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraExecutorManager.kt\nio/github/thibaultbee/streampack/internal/sources/camera/CameraExecutorManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1549#2:94\n1620#2,3:95\n*S KotlinDebug\n*F\n+ 1 CameraExecutorManager.kt\nio/github/thibaultbee/streampack/internal/sources/camera/CameraExecutorManager\n*L\n53#1:94\n53#1:95,3\n*E\n"})
public final class CameraExecutorManager
implements ICameraThreadManager {
    private final ExecutorService cameraExecutor = Executors.newSingleThreadExecutor();

    @Override
    @RequiresApi(value=28)
    @RequiresPermission(value="android.permission.CAMERA")
    public void openCamera(@NotNull CameraManager manager, @NotNull String cameraId2, @NotNull CameraDevice.StateCallback callback) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        manager.openCamera(cameraId2, (Executor)this.cameraExecutor, callback);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresApi(value=28)
    public void createCaptureSession(@NotNull CameraDevice camera, @NotNull List<? extends Surface> targets, @NotNull CameraCaptureSession.StateCallback callback) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Iterable $this$map$iv = targets;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Surface surface = (Surface)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new OutputConfiguration((Surface)it));
        }
        List outputConfigurations = (List)destination$iv$iv;
        this.createCaptureSessionByOutputConfiguration(camera, outputConfigurations, callback);
    }

    @Override
    @RequiresApi(value=28)
    public void createCaptureSessionByOutputConfiguration(@NotNull CameraDevice camera, @NotNull List<OutputConfiguration> outputConfigurations, @NotNull CameraCaptureSession.StateCallback callback) {
        SessionConfiguration sessionConfiguration;
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Intrinsics.checkNotNullParameter(outputConfigurations, (String)"outputConfigurations");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        SessionConfiguration sessionConfig = sessionConfiguration = new SessionConfiguration(0, outputConfigurations, (Executor)this.cameraExecutor, callback);
        boolean bl = false;
        camera.createCaptureSession(sessionConfig);
    }

    @Override
    @RequiresApi(value=28)
    public int setRepeatingSingleRequest(@NotNull CameraCaptureSession captureSession, @NotNull CaptureRequest captureRequest, @NotNull CameraCaptureSession.CaptureCallback callback) {
        Intrinsics.checkNotNullParameter((Object)captureSession, (String)"captureSession");
        Intrinsics.checkNotNullParameter((Object)captureRequest, (String)"captureRequest");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return captureSession.setSingleRepeatingRequest(captureRequest, (Executor)this.cameraExecutor, callback);
    }

    @Override
    @RequiresApi(value=28)
    public int captureBurstRequests(@NotNull CameraCaptureSession captureSession, @NotNull List<CaptureRequest> captureRequests, @NotNull CameraCaptureSession.CaptureCallback callback) {
        Intrinsics.checkNotNullParameter((Object)captureSession, (String)"captureSession");
        Intrinsics.checkNotNullParameter(captureRequests, (String)"captureRequests");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return captureSession.captureBurstRequests(captureRequests, (Executor)this.cameraExecutor, callback);
    }

    @Override
    public void release() {
    }
}

