/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.sources.screen;

import android.content.Context;
import android.content.Intent;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Size;
import android.view.Surface;
import androidx.activity.result.ActivityResult;
import io.github.thibaultbee.streampack.data.VideoConfig;
import io.github.thibaultbee.streampack.error.StreamPackError;
import io.github.thibaultbee.streampack.internal.data.Frame;
import io.github.thibaultbee.streampack.internal.orientation.AbstractSourceOrientationProvider;
import io.github.thibaultbee.streampack.internal.sources.IVideoSource;
import io.github.thibaultbee.streampack.internal.sources.screen.ScreenSource;
import io.github.thibaultbee.streampack.internal.utils.extensions.ContextExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.extensions.SizeExtensionsKt;
import io.github.thibaultbee.streampack.listeners.OnErrorListener;
import io.github.thibaultbee.streampack.logger.ILogger;
import io.github.thibaultbee.streampack.logger.Logger;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0002\u001b2\u0018\u0000 B2\u00020\u0001:\u0002BCB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020.H\u0016J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0016J\b\u0010?\u001a\u000209H\u0016J\b\u0010@\u001a\u000209H\u0016J\b\u0010A\u001a\u000209H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020*X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00103R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lio/github/thibaultbee/streampack/internal/sources/screen/ScreenSource;", "Lio/github/thibaultbee/streampack/internal/sources/IVideoSource;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "activityResult", "Landroidx/activity/result/ActivityResult;", "getActivityResult", "()Landroidx/activity/result/ActivityResult;", "setActivityResult", "(Landroidx/activity/result/ActivityResult;)V", "encoderSurface", "Landroid/view/Surface;", "getEncoderSurface", "()Landroid/view/Surface;", "setEncoderSurface", "(Landroid/view/Surface;)V", "hasFrames", "", "getHasFrames", "()Z", "hasSurface", "getHasSurface", "isExplicitelyStopped", "mediaProjection", "Landroid/media/projection/MediaProjection;", "mediaProjectionCallback", "io/github/thibaultbee/streampack/internal/sources/screen/ScreenSource$mediaProjectionCallback$1", "Lio/github/thibaultbee/streampack/internal/sources/screen/ScreenSource$mediaProjectionCallback$1;", "mediaProjectionManager", "Landroid/media/projection/MediaProjectionManager;", "onErrorListener", "Lio/github/thibaultbee/streampack/listeners/OnErrorListener;", "getOnErrorListener", "()Lio/github/thibaultbee/streampack/listeners/OnErrorListener;", "setOnErrorListener", "(Lio/github/thibaultbee/streampack/listeners/OnErrorListener;)V", "orientationProvider", "Lio/github/thibaultbee/streampack/internal/sources/screen/ScreenSource$ScreenSourceOrientationProvider;", "getOrientationProvider", "()Lio/github/thibaultbee/streampack/internal/sources/screen/ScreenSource$ScreenSourceOrientationProvider;", "timestampOffset", "", "getTimestampOffset", "()J", "videoConfig", "Lio/github/thibaultbee/streampack/data/VideoConfig;", "virtualDisplay", "Landroid/hardware/display/VirtualDisplay;", "virtualDisplayCallback", "io/github/thibaultbee/streampack/internal/sources/screen/ScreenSource$virtualDisplayCallback$1", "Lio/github/thibaultbee/streampack/internal/sources/screen/ScreenSource$virtualDisplayCallback$1;", "virtualDisplayHandler", "Landroid/os/Handler;", "virtualDisplayThread", "Landroid/os/HandlerThread;", "configure", "", "config", "getFrame", "Lio/github/thibaultbee/streampack/internal/data/Frame;", "buffer", "Ljava/nio/ByteBuffer;", "release", "startStream", "stopStream", "Companion", "ScreenSourceOrientationProvider", "core_release"})
@SourceDebugExtension(value={"SMAP\nScreenSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenSource.kt\nio/github/thibaultbee/streampack/internal/sources/screen/ScreenSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1#2:162\n*E\n"})
public final class ScreenSource
implements IVideoSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Surface encoderSurface;
    private final long timestampOffset;
    private final boolean hasSurface;
    private final boolean hasFrames;
    @NotNull
    private final ScreenSourceOrientationProvider orientationProvider;
    @Nullable
    private MediaProjection mediaProjection;
    @Nullable
    private ActivityResult activityResult;
    @Nullable
    private OnErrorListener onErrorListener;
    private boolean isExplicitelyStopped;
    @NotNull
    private final MediaProjectionManager mediaProjectionManager;
    @Nullable
    private VirtualDisplay virtualDisplay;
    @Nullable
    private VideoConfig videoConfig;
    @NotNull
    private final HandlerThread virtualDisplayThread;
    @NotNull
    private final Handler virtualDisplayHandler;
    @NotNull
    private final virtualDisplayCallback.1 virtualDisplayCallback;
    @NotNull
    private final mediaProjectionCallback.1 mediaProjectionCallback;
    @NotNull
    private static final String TAG = "ScreenSource";
    @NotNull
    private static final String VIRTUAL_DISPLAY_NAME = "StreamPackScreenSource";

    /*
     * WARNING - void declaration
     */
    public ScreenSource(@NotNull Context context) {
        void $this$virtualDisplayThread_u24lambda_u240;
        HandlerThread handlerThread;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.hasSurface = true;
        this.orientationProvider = new ScreenSourceOrientationProvider(context);
        Object object = context.getSystemService("media_projection");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.media.projection.MediaProjectionManager");
        this.mediaProjectionManager = (MediaProjectionManager)object;
        HandlerThread handlerThread2 = handlerThread = new HandlerThread("VirtualDisplayThread");
        ScreenSource screenSource = this;
        boolean bl = false;
        $this$virtualDisplayThread_u24lambda_u240.start();
        screenSource.virtualDisplayThread = handlerThread;
        this.virtualDisplayHandler = new Handler(this.virtualDisplayThread.getLooper());
        this.virtualDisplayCallback = new VirtualDisplay.Callback(this){
            final /* synthetic */ ScreenSource this$0;
            {
                this.this$0 = $receiver;
            }

            public void onPaused() {
                super.onPaused();
                ILogger.DefaultImpls.i$default(Logger.INSTANCE, "ScreenSource", "onPaused", null, 4, null);
            }

            public void onStopped() {
                block1: {
                    super.onStopped();
                    ILogger.DefaultImpls.i$default(Logger.INSTANCE, "ScreenSource", "onStopped", null, 4, null);
                    if (ScreenSource.access$isExplicitelyStopped$p(this.this$0)) break block1;
                    OnErrorListener onErrorListener = this.this$0.getOnErrorListener();
                    if (onErrorListener != null) {
                        onErrorListener.onError(new StreamPackError("Screen source virtual display has been stopped"));
                    }
                }
            }
        };
        this.mediaProjectionCallback = new MediaProjection.Callback(this){
            final /* synthetic */ ScreenSource this$0;
            {
                this.this$0 = $receiver;
            }

            public void onStop() {
                block1: {
                    super.onStop();
                    ILogger.DefaultImpls.i$default(Logger.INSTANCE, "ScreenSource", "onStop", null, 4, null);
                    if (ScreenSource.access$isExplicitelyStopped$p(this.this$0)) break block1;
                    OnErrorListener onErrorListener = this.this$0.getOnErrorListener();
                    if (onErrorListener != null) {
                        onErrorListener.onError(new StreamPackError("Screen source media projection has been stopped"));
                    }
                }
            }
        };
    }

    @Override
    @Nullable
    public Surface getEncoderSurface() {
        return this.encoderSurface;
    }

    @Override
    public void setEncoderSurface(@Nullable Surface surface) {
        this.encoderSurface = surface;
    }

    @Override
    public long getTimestampOffset() {
        return this.timestampOffset;
    }

    @Override
    public boolean getHasSurface() {
        return this.hasSurface;
    }

    @Override
    public boolean getHasFrames() {
        return this.hasFrames;
    }

    @Override
    @NotNull
    public ScreenSourceOrientationProvider getOrientationProvider() {
        return this.orientationProvider;
    }

    @Override
    @NotNull
    public Frame getFrame(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        throw new UnsupportedOperationException("Screen source expects to run in Surface mode");
    }

    @Nullable
    public final ActivityResult getActivityResult() {
        return this.activityResult;
    }

    public final void setActivityResult(@Nullable ActivityResult activityResult) {
        this.activityResult = activityResult;
    }

    @Nullable
    public final OnErrorListener getOnErrorListener() {
        return this.onErrorListener;
    }

    public final void setOnErrorListener(@Nullable OnErrorListener onErrorListener) {
        this.onErrorListener = onErrorListener;
    }

    @Override
    public void configure(@NotNull VideoConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.videoConfig = config;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void startStream() {
        void $this$startStream_u24lambda_u243;
        MediaProjection mediaProjection;
        if (!(this.videoConfig != null)) {
            boolean $i$a$-require-ScreenSource$startStream$32 = false;
            String $i$a$-require-ScreenSource$startStream$32 = "Video has not been configured!";
            throw new IllegalArgumentException($i$a$-require-ScreenSource$startStream$32.toString());
        }
        if (!(this.activityResult != null)) {
            boolean $i$a$-require-ScreenSource$startStream$42 = false;
            String $i$a$-require-ScreenSource$startStream$42 = "Activity result must be set!";
            throw new IllegalArgumentException($i$a$-require-ScreenSource$startStream$42.toString());
        }
        ActivityResult activityResult = this.activityResult;
        Intrinsics.checkNotNull((Object)activityResult);
        int resultCode = activityResult.getResultCode();
        ActivityResult activityResult2 = this.activityResult;
        Intrinsics.checkNotNull((Object)activityResult2);
        Intent intent = activityResult2.getData();
        Intrinsics.checkNotNull((Object)intent);
        Intent resultData = intent;
        this.isExplicitelyStopped = false;
        ScreenSourceOrientationProvider screenSourceOrientationProvider = this.getOrientationProvider();
        VideoConfig videoConfig = this.videoConfig;
        Intrinsics.checkNotNull((Object)videoConfig);
        Size orientedSize = screenSourceOrientationProvider.getOrientedSize(videoConfig.getResolution());
        MediaProjection mediaProjection2 = mediaProjection = this.mediaProjectionManager.getMediaProjection(resultCode, resultData);
        ScreenSource screenSource = this;
        boolean bl = false;
        $this$startStream_u24lambda_u243.registerCallback((MediaProjection.Callback)this.mediaProjectionCallback, this.virtualDisplayHandler);
        this.virtualDisplay = $this$startStream_u24lambda_u243.createVirtualDisplay(VIRTUAL_DISPLAY_NAME, orientedSize.getWidth(), orientedSize.getHeight(), 320, 16, this.getEncoderSurface(), (VirtualDisplay.Callback)this.virtualDisplayCallback, this.virtualDisplayHandler);
        screenSource.mediaProjection = mediaProjection;
    }

    @Override
    public void stopStream() {
        this.isExplicitelyStopped = true;
        VirtualDisplay virtualDisplay = this.virtualDisplay;
        if (virtualDisplay != null) {
            virtualDisplay.release();
        }
        this.virtualDisplay = null;
        MediaProjection mediaProjection = this.mediaProjection;
        if (mediaProjection != null) {
            mediaProjection.stop();
        }
        this.mediaProjection = null;
    }

    @Override
    public void release() {
        this.virtualDisplayThread.quitSafely();
        try {
            this.virtualDisplayThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static final /* synthetic */ boolean access$isExplicitelyStopped$p(ScreenSource $this) {
        return $this.isExplicitelyStopped;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/github/thibaultbee/streampack/internal/sources/screen/ScreenSource$Companion;", "", "()V", "TAG", "", "VIRTUAL_DISPLAY_NAME", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lio/github/thibaultbee/streampack/internal/sources/screen/ScreenSource$ScreenSourceOrientationProvider;", "Lio/github/thibaultbee/streampack/internal/orientation/AbstractSourceOrientationProvider;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "orientation", "", "getOrientation", "()I", "getOrientedSize", "Landroid/util/Size;", "size", "core_release"})
    public static final class ScreenSourceOrientationProvider
    extends AbstractSourceOrientationProvider {
        @NotNull
        private final Context context;
        private final int orientation;

        public ScreenSourceOrientationProvider(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
        }

        @Override
        public int getOrientation() {
            return this.orientation;
        }

        @Override
        @NotNull
        public Size getOrientedSize(@NotNull Size size2) {
            Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
            return ContextExtensionsKt.isDevicePortrait(this.context) ? SizeExtensionsKt.getPortraitize(size2) : SizeExtensionsKt.getLandscapize(size2);
        }
    }
}

