/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils.av.audio.aac;

import io.github.thibaultbee.streampack.data.AudioConfig;
import io.github.thibaultbee.streampack.internal.utils.av.audio.aac.ADTS;
import io.github.thibaultbee.streampack.internal.utils.av.buffer.ByteBufferWriter;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/ADTSFrameWriter;", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/ByteBufferWriter;", "frameBuffer", "Ljava/nio/ByteBuffer;", "adts", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/ADTS;", "(Ljava/nio/ByteBuffer;Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/ADTS;)V", "size", "", "getSize", "()I", "write", "", "output", "Companion", "core_release"})
public final class ADTSFrameWriter
extends ByteBufferWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBuffer frameBuffer;
    @NotNull
    private final ADTS adts;
    private final int size;

    public ADTSFrameWriter(@NotNull ByteBuffer frameBuffer, @NotNull ADTS adts) {
        Intrinsics.checkNotNullParameter((Object)frameBuffer, (String)"frameBuffer");
        Intrinsics.checkNotNullParameter((Object)adts, (String)"adts");
        this.frameBuffer = frameBuffer;
        this.adts = adts;
        this.size = this.frameBuffer.remaining() + this.adts.getSize();
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void write(@NotNull ByteBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.adts.write(output);
        output.put(this.frameBuffer);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/ADTSFrameWriter$Companion;", "", "()V", "fromAudioConfig", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/ADTSFrameWriter;", "frameBuffer", "Ljava/nio/ByteBuffer;", "audioConfig", "Lio/github/thibaultbee/streampack/data/AudioConfig;", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ADTSFrameWriter fromAudioConfig(@NotNull ByteBuffer frameBuffer, @NotNull AudioConfig audioConfig) {
            Intrinsics.checkNotNullParameter((Object)frameBuffer, (String)"frameBuffer");
            Intrinsics.checkNotNullParameter((Object)audioConfig, (String)"audioConfig");
            return new ADTSFrameWriter(frameBuffer, ADTS.Companion.fromAudioConfig(audioConfig, frameBuffer.remaining()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

