/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils.av.buffer;

import io.github.thibaultbee.streampack.internal.utils.extensions.BitOperationExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u000bJ\u0006\u0010\u0013\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bJ\u0006\u0010\u0017\u001a\u00020\u000bJ\u0006\u0010\u0018\u001a\u00020\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/buffer/ByteBufferBitReader;", "", "buffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "getBuffer", "()Ljava/nio/ByteBuffer;", "setBuffer", "currentByte", "", "nBit", "", "nextByte", "advance", "", "get", "moreRBSPData", "", "read1Bit", "readBoolean", "readNBit", "", "n", "readSE", "readUE", "core_release"})
@SourceDebugExtension(value={"SMAP\nByteBufferReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteBufferReader.kt\nio/github/thibaultbee/streampack/internal/utils/av/buffer/ByteBufferBitReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class ByteBufferBitReader {
    @NotNull
    private ByteBuffer buffer;
    private int nBit;
    private byte currentByte;
    private byte nextByte;

    public ByteBufferBitReader(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        this.currentByte = this.get();
        this.nextByte = this.get();
    }

    @NotNull
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    public final void setBuffer(@NotNull ByteBuffer byteBuffer) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"<set-?>");
        this.buffer = byteBuffer;
    }

    public final byte get() {
        return this.buffer.get();
    }

    public final int read1Bit() {
        if (this.nBit == 8) {
            this.advance();
        }
        int res = BitOperationExtensionsKt.shr(this.currentByte, 7 - this.nBit) & 1;
        int n = this.nBit;
        this.nBit = n + 1;
        return res;
    }

    private final void advance() {
        this.currentByte = this.nextByte;
        this.nextByte = this.get();
        this.nBit = 0;
    }

    public final int readUE() {
        int cnt = 0;
        while (this.read1Bit() == 0) {
            ++cnt;
        }
        int res = 0;
        if (cnt > 0) {
            res = (int)((long)((1 << cnt) - 1) + this.readNBit(cnt));
        }
        return res;
    }

    public final long readNBit(int n) {
        if (!(n <= 64)) {
            boolean bl = false;
            String string2 = "Can not readByte more then 64 bit";
            throw new IllegalArgumentException(string2.toString());
        }
        long value = 0L;
        for (int i = 0; i < n; ++i) {
            value <<= 1;
            value |= (long)this.read1Bit();
        }
        return value;
    }

    public final boolean readBoolean() {
        return this.read1Bit() != 0;
    }

    public final int readSE() {
        int value = this.readUE();
        int sign = ((value & 1) << 1) - 1;
        value = ((value >> 1) + (value & 1)) * sign;
        return value;
    }

    public final boolean moreRBSPData() {
        int tail;
        int mask;
        if (this.nBit == 8) {
            this.advance();
        }
        boolean hasTail = (this.currentByte & (mask = ((tail = 1 << 8 - this.nBit - 1) << 1) - 1)) == tail;
        return !hasTail;
    }
}

