/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PointF;
import android.graphics.Rect;
import android.hardware.camera2.CameraCharacteristics;
import android.util.AttributeSet;
import android.util.Size;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.camera.viewfinder.CameraViewfinder;
import androidx.camera.viewfinder.CameraViewfinderExt;
import androidx.camera.viewfinder.surface.ViewfinderSurfaceRequest;
import androidx.camera.viewfinder.surface.ViewfinderSurfaceRequestUtil;
import androidx.core.app.ActivityCompat;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.ViewTreeLifecycleOwner;
import io.github.thibaultbee.streampack.R;
import io.github.thibaultbee.streampack.logger.ILogger;
import io.github.thibaultbee.streampack.logger.Logger;
import io.github.thibaultbee.streampack.streamers.interfaces.ICameraStreamer;
import io.github.thibaultbee.streampack.utils.CameraSettings;
import io.github.thibaultbee.streampack.utils.ContextExtensionsForCameraKt;
import io.github.thibaultbee.streampack.utils.OrientationUtils;
import io.github.thibaultbee.streampack.utils.Zoom;
import io.github.thibaultbee.streampack.views.CameraSizesKt;
import io.github.thibaultbee.streampack.views.PreviewView;
import io.github.thibaultbee.streampack.views.ViewExtensionsKt;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 Q2\u00020\u0001:\u0005QRSTUB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u00107\u001a\u0002062\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J\b\u0010<\u001a\u00020=H\u0014J(\u0010>\u001a\u00020=2\u0006\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u00072\u0006\u0010A\u001a\u00020\u00072\u0006\u0010B\u001a\u00020\u0007H\u0014J\u0010\u0010C\u001a\u00020\f2\u0006\u0010D\u001a\u000204H\u0016J\b\u0010E\u001a\u00020\fH\u0016J\u0016\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u000206H\u0082@\u00a2\u0006\u0002\u0010IJ\u0006\u0010J\u001a\u00020=J \u0010K\u001a\u00020=2\u0006\u0010.\u001a\u00020-2\u0006\u00108\u001a\u0002092\u0006\u0010L\u001a\u00020\fH\u0002J&\u0010M\u001a\u00020=2\u0006\u0010.\u001a\u00020-2\u0006\u0010:\u001a\u00020;2\u0006\u00108\u001a\u000209H\u0082@\u00a2\u0006\u0002\u0010NJ\u0006\u0010O\u001a\u00020=J\b\u0010P\u001a\u00020=H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020!8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R$\u0010(\u001a\u00020'2\u0006\u0010 \u001a\u00020'8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R(\u0010.\u001a\u0004\u0018\u00010-2\b\u0010 \u001a\u0004\u0018\u00010-@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0010\u00103\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00105\u001a\u0004\u0018\u000106X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lio/github/thibaultbee/streampack/views/PreviewView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "cameraViewFinder", "Landroidx/camera/viewfinder/CameraViewfinder;", "enableTapToFocus", "", "getEnableTapToFocus", "()Z", "setEnableTapToFocus", "(Z)V", "enableZoomOnPinch", "getEnableZoomOnPinch", "setEnableZoomOnPinch", "lifecycleScope", "Lkotlinx/coroutines/CoroutineScope;", "getLifecycleScope", "()Lkotlinx/coroutines/CoroutineScope;", "listener", "Lio/github/thibaultbee/streampack/views/PreviewView$Listener;", "getListener", "()Lio/github/thibaultbee/streampack/views/PreviewView$Listener;", "setListener", "(Lio/github/thibaultbee/streampack/views/PreviewView$Listener;)V", "pinchGesture", "Landroid/view/ScaleGestureDetector;", "value", "Lio/github/thibaultbee/streampack/views/PreviewView$Position;", "position", "getPosition", "()Lio/github/thibaultbee/streampack/views/PreviewView$Position;", "setPosition", "(Lio/github/thibaultbee/streampack/views/PreviewView$Position;)V", "Lio/github/thibaultbee/streampack/views/PreviewView$ScaleMode;", "scaleMode", "getScaleMode", "()Lio/github/thibaultbee/streampack/views/PreviewView$ScaleMode;", "setScaleMode", "(Lio/github/thibaultbee/streampack/views/PreviewView$ScaleMode;)V", "Lio/github/thibaultbee/streampack/streamers/interfaces/ICameraStreamer;", "streamer", "getStreamer", "()Lio/github/thibaultbee/streampack/streamers/interfaces/ICameraStreamer;", "setStreamer", "(Lio/github/thibaultbee/streampack/streamers/interfaces/ICameraStreamer;)V", "touchUpEvent", "Landroid/view/MotionEvent;", "viewFinderSurfaceRequest", "Landroidx/camera/viewfinder/surface/ViewfinderSurfaceRequest;", "createRequest", "targetViewSize", "Landroid/util/Size;", "camera", "", "onDetachedFromWindow", "", "onSizeChanged", "w", "h", "oldw", "oldh", "onTouchEvent", "event", "performClick", "sendRequest", "Landroid/view/Surface;", "request", "(Landroidx/camera/viewfinder/surface/ViewfinderSurfaceRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startPreview", "startPreviewIfReady", "shouldFailSilently", "startPreviewInternal", "(Lio/github/thibaultbee/streampack/streamers/interfaces/ICameraStreamer;Ljava/lang/String;Landroid/util/Size;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stopPreview", "stopPreviewInternal", "Companion", "Listener", "PinchToZoomOnScaleGestureListener", "Position", "ScaleMode", "core_release"})
@SourceDebugExtension(value={"SMAP\nPreviewView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewView.kt\nio/github/thibaultbee/streampack/views/PreviewView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,498:1\n1#2:499\n*E\n"})
public final class PreviewView
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CameraViewfinder cameraViewFinder;
    @Nullable
    private ViewfinderSurfaceRequest viewFinderSurfaceRequest;
    private boolean enableZoomOnPinch;
    private boolean enableTapToFocus;
    @Nullable
    private ICameraStreamer streamer;
    @Nullable
    private Listener listener;
    @Nullable
    private MotionEvent touchUpEvent;
    @NotNull
    private final ScaleGestureDetector pinchGesture;
    @NotNull
    private static final String TAG = "PreviewView";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public PreviewView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyle);
        this.cameraViewFinder = new CameraViewfinder(context, attrs, defStyle);
        this.pinchGesture = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new PinchToZoomOnScaleGestureListener());
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.PreviewView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray a = typedArray;
        try {
            this.enableZoomOnPinch = a.getBoolean(R.styleable.PreviewView_enableZoomOnPinch, true);
            this.enableTapToFocus = a.getBoolean(R.styleable.PreviewView_enableTapToFocus, true);
            this.setScaleMode(ScaleMode.Companion.entryOf$core_release(a.getInt(R.styleable.PreviewView_scaleMode, ScaleMode.FILL.getValue())));
            this.setPosition(Position.Companion.entryOf$core_release(a.getInt(R.styleable.PreviewView_position, Position.CENTER.getValue())));
        }
        finally {
            a.recycle();
        }
        this.addView((View)this.cameraViewFinder, new ViewGroup.LayoutParams(-1, -1));
    }

    public /* synthetic */ PreviewView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final CoroutineScope getLifecycleScope() {
        LifecycleOwner lifecycleOwner = ViewTreeLifecycleOwner.get((View)((View)this));
        return (CoroutineScope)(lifecycleOwner != null ? LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)lifecycleOwner) : null);
    }

    public final boolean getEnableZoomOnPinch() {
        return this.enableZoomOnPinch;
    }

    public final void setEnableZoomOnPinch(boolean bl) {
        this.enableZoomOnPinch = bl;
    }

    public final boolean getEnableTapToFocus() {
        return this.enableTapToFocus;
    }

    public final void setEnableTapToFocus(boolean bl) {
        this.enableTapToFocus = bl;
    }

    @Nullable
    public final ICameraStreamer getStreamer() {
        return this.streamer;
    }

    public final void setStreamer(@Nullable ICameraStreamer value) {
        this.stopPreviewInternal();
        ICameraStreamer iCameraStreamer = value;
        if (iCameraStreamer != null) {
            ICameraStreamer it = iCameraStreamer;
            boolean bl = false;
            CoroutineScope coroutineScope = this.getLifecycleScope();
            if (coroutineScope != null) {
                BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, it, null){
                    int label;
                    final /* synthetic */ PreviewView this$0;
                    final /* synthetic */ ICameraStreamer $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = PreviewView.access$startPreviewInternal(this.this$0, this.$it, this.$it.getCamera(), ViewExtensionsKt.getSize((View)this.this$0), (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
        this.streamer = value;
    }

    @NotNull
    public final Position getPosition() {
        CameraViewfinder.ScaleType scaleType = this.cameraViewFinder.getScaleType();
        Intrinsics.checkNotNullExpressionValue((Object)scaleType, (String)"getScaleType(...)");
        return PreviewView.Companion.getPosition(scaleType);
    }

    public final void setPosition(@NotNull Position value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.cameraViewFinder.setScaleType(PreviewView.Companion.getScaleType(this.getScaleMode(), value));
    }

    @NotNull
    public final ScaleMode getScaleMode() {
        CameraViewfinder.ScaleType scaleType = this.cameraViewFinder.getScaleType();
        Intrinsics.checkNotNullExpressionValue((Object)scaleType, (String)"getScaleType(...)");
        return PreviewView.Companion.getScaleMode(scaleType);
    }

    public final void setScaleMode(@NotNull ScaleMode value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.cameraViewFinder.setScaleType(PreviewView.Companion.getScaleType(value, this.getPosition()));
    }

    @Nullable
    public final Listener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable Listener listener) {
        this.listener = listener;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        block1: {
            if (w == oldw && h == oldh) break block1;
            this.stopPreviewInternal();
            ICameraStreamer iCameraStreamer = this.streamer;
            if (iCameraStreamer != null) {
                ICameraStreamer it = iCameraStreamer;
                boolean bl = false;
                this.startPreviewIfReady(it, ViewExtensionsKt.getSize((View)this), true);
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopPreview();
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        boolean notALongPress;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.streamer == null) {
            return super.onTouchEvent(event);
        }
        if (this.enableZoomOnPinch) {
            this.pinchGesture.onTouchEvent(event);
        }
        boolean isSingleTouch = event.getPointerCount() == 1;
        boolean isUpEvent = event.getAction() == 1;
        boolean bl = notALongPress = event.getEventTime() - event.getDownTime() < (long)ViewConfiguration.getLongPressTimeout();
        if (isSingleTouch && isUpEvent && notALongPress) {
            this.touchUpEvent = event;
            this.performClick();
            return true;
        }
        return true;
    }

    public boolean performClick() {
        ICameraStreamer iCameraStreamer = this.streamer;
        if (iCameraStreamer != null) {
            ICameraStreamer it = iCameraStreamer;
            boolean bl = false;
            if (this.enableTapToFocus) {
                MotionEvent motionEvent = this.touchUpEvent;
                float x = motionEvent != null ? motionEvent.getX() : (float)this.getWidth() / 2.0f;
                MotionEvent motionEvent2 = this.touchUpEvent;
                float y = motionEvent2 != null ? motionEvent2.getY() : (float)this.getHeight() / 2.0f;
                try {
                    it.getSettings().getCamera().getFocusMetering().onTap(new PointF(x, y), new Rect((int)this.getX(), (int)this.getY(), this.getWidth(), this.getHeight()), OrientationUtils.INSTANCE.getSurfaceOrientationDegrees(this.getDisplay().getRotation()));
                }
                catch (Exception e) {
                    Logger.INSTANCE.e(TAG, "Failed to focus at " + x + ", " + y, e);
                }
            }
        }
        this.touchUpEvent = null;
        return super.performClick();
    }

    public final void stopPreview() {
        this.stopPreviewInternal();
    }

    private final void stopPreviewInternal() {
        ICameraStreamer iCameraStreamer = this.streamer;
        if (iCameraStreamer != null) {
            iCameraStreamer.stopPreview();
        }
        ViewfinderSurfaceRequest viewfinderSurfaceRequest = this.viewFinderSurfaceRequest;
        if (viewfinderSurfaceRequest != null) {
            viewfinderSurfaceRequest.markSurfaceSafeToRelease();
        }
        this.viewFinderSurfaceRequest = null;
    }

    public final void startPreview() {
        Unit unit;
        ICameraStreamer iCameraStreamer = this.streamer;
        if (iCameraStreamer != null) {
            ICameraStreamer it = iCameraStreamer;
            boolean bl = false;
            this.startPreviewIfReady(it, ViewExtensionsKt.getSize((View)this), false);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new UnsupportedOperationException("Streamer has not been set");
        }
    }

    private final void startPreviewIfReady(ICameraStreamer streamer2, Size targetViewSize, boolean shouldFailSilently) {
        try {
            if (ActivityCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.CAMERA") != 0) {
                throw new SecurityException("Camera permission is needed to run this application");
            }
            CoroutineScope coroutineScope = this.getLifecycleScope();
            if (coroutineScope == null || (coroutineScope = BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, streamer2, targetViewSize, null){
                int label;
                final /* synthetic */ PreviewView this$0;
                final /* synthetic */ ICameraStreamer $streamer;
                final /* synthetic */ Size $targetViewSize;
                {
                    this.this$0 = $receiver;
                    this.$streamer = $streamer;
                    this.$targetViewSize = $targetViewSize;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = PreviewView.access$startPreviewInternal(this.this$0, this.$streamer, this.$streamer.getCamera(), this.$targetViewSize, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null)) == null) {
                throw new IllegalStateException("LifecycleScope is not available");
            }
        }
        catch (Exception e) {
            if (shouldFailSilently) {
                Logger.INSTANCE.w(TAG, e.toString(), e);
            }
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object startPreviewInternal(ICameraStreamer var1_1, String var2_2, Size var3_3, Continuation<? super Unit> var4_4) {
        if (!(var4_4 instanceof startPreviewInternal.1)) ** GOTO lbl-1000
        var8_5 = var4_4;
        if ((var8_5.label & -2147483648) != 0) {
            var8_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ PreviewView this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PreviewView.access$startPreviewInternal(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                ILogger.DefaultImpls.d$default(Logger.INSTANCE, "PreviewView", "Target view size: " + targetViewSize, null, 4, null);
                ILogger.DefaultImpls.i$default(Logger.INSTANCE, "PreviewView", "Starting on camera: " + camera, null, 4, null);
                request = this.createRequest((Size)targetViewSize, camera);
                v0 = this.viewFinderSurfaceRequest;
                if (v0 != null) {
                    v0.markSurfaceSafeToRelease();
                }
                this.viewFinderSurfaceRequest = request;
                $continuation.L$0 = this;
                $continuation.L$1 = streamer;
                $continuation.L$2 = camera;
                $continuation.label = 1;
                v1 = this.sendRequest(request, (Continuation<? super Surface>)$continuation);
                ** if (v1 != var9_7) goto lbl28
lbl27:
                // 1 sources

                return var9_7;
lbl28:
                // 1 sources

                ** GOTO lbl37
            }
            case 1: {
                camera = (String)$continuation.L$2;
                streamer = (ICameraStreamer)$continuation.L$1;
                this = (PreviewView)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl37:
                    // 2 sources

                    surface = (Surface)v1;
                    if (ActivityCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.CAMERA") != 0) {
                        v2 = this.viewFinderSurfaceRequest;
                        if (v2 != null) {
                            v2.markSurfaceSafeToRelease();
                        }
                        this.viewFinderSurfaceRequest = null;
                        ILogger.DefaultImpls.e$default(Logger.INSTANCE, "PreviewView", "Camera permission is needed to run this application", null, 4, null);
                        v3 = this.listener;
                        if (v3 != null) {
                            v3.onPreviewFailed(new SecurityException("Camera permission is needed to run this application"));
                        }
                    } else if (surface.isValid()) {
                        streamer.startPreview(surface, camera);
                        v4 = this.listener;
                        if (v4 != null) {
                            v4.onPreviewStarted();
                        }
                    } else {
                        ILogger.DefaultImpls.w$default(Logger.INSTANCE, "PreviewView", "Invalid surface", null, 4, null);
                    }
                }
                catch (CancellationException surface) {
                    ILogger.DefaultImpls.w$default(Logger.INSTANCE, "PreviewView", "Preview request cancelled", null, 4, null);
                }
                catch (Throwable t) {
                    v5 = this.viewFinderSurfaceRequest;
                    if (v5 != null) {
                        v5.markSurfaceSafeToRelease();
                    }
                    this.viewFinderSurfaceRequest = null;
                    Logger.INSTANCE.w("PreviewView", "Failed to get a Surface: " + t, t);
                    v6 = this.listener;
                    if (v6 == null) ** GOTO lbl68
                    v6.onPreviewFailed(t);
                }
lbl68:
                // 6 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final ViewfinderSurfaceRequest createRequest(Size targetViewSize, String camera) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        Size previewSize = CameraSizesKt.getPreviewOutputSize(ContextExtensionsForCameraKt.getCameraCharacteristics(context, camera), targetViewSize, SurfaceHolder.class);
        ILogger.DefaultImpls.d$default(Logger.INSTANCE, TAG, "Selected preview size: " + previewSize, null, 4, null);
        ViewfinderSurfaceRequest.Builder builder = new ViewfinderSurfaceRequest.Builder(previewSize);
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        ViewfinderSurfaceRequestUtil.populateFromCharacteristics((ViewfinderSurfaceRequest.Builder)builder, (CameraCharacteristics)ContextExtensionsForCameraKt.getCameraCharacteristics(context2, camera));
        return builder.build();
    }

    private final Object sendRequest(ViewfinderSurfaceRequest request, Continuation<? super Surface> $completion) {
        return CameraViewfinderExt.INSTANCE.requestSurface(this.cameraViewFinder, request, $completion);
    }

    @JvmOverloads
    public PreviewView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public PreviewView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ Object access$startPreviewInternal(PreviewView $this, ICameraStreamer streamer2, String camera, Size targetViewSize, Continuation $completion) {
        return $this.startPreviewInternal(streamer2, camera, targetViewSize, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$sendRequest(PreviewView $this, ViewfinderSurfaceRequest request, Continuation $completion) {
        return $this.sendRequest(request, (Continuation<? super Surface>)$completion);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/github/thibaultbee/streampack/views/PreviewView$Companion;", "", "()V", "TAG", "", "getPosition", "Lio/github/thibaultbee/streampack/views/PreviewView$Position;", "scaleType", "Landroidx/camera/viewfinder/CameraViewfinder$ScaleType;", "getScaleMode", "Lio/github/thibaultbee/streampack/views/PreviewView$ScaleMode;", "getScaleType", "scaleMode", "position", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Position getPosition(CameraViewfinder.ScaleType scaleType) {
            Position position;
            switch (WhenMappings.$EnumSwitchMapping$0[scaleType.ordinal()]) {
                case 1: {
                    position = Position.START;
                    break;
                }
                case 2: {
                    position = Position.CENTER;
                    break;
                }
                case 3: {
                    position = Position.END;
                    break;
                }
                case 4: {
                    position = Position.START;
                    break;
                }
                case 5: {
                    position = Position.CENTER;
                    break;
                }
                case 6: {
                    position = Position.END;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return position;
        }

        private final ScaleMode getScaleMode(CameraViewfinder.ScaleType scaleType) {
            ScaleMode scaleMode;
            switch (WhenMappings.$EnumSwitchMapping$0[scaleType.ordinal()]) {
                case 1: {
                    scaleMode = ScaleMode.FILL;
                    break;
                }
                case 2: {
                    scaleMode = ScaleMode.FILL;
                    break;
                }
                case 3: {
                    scaleMode = ScaleMode.FILL;
                    break;
                }
                case 4: {
                    scaleMode = ScaleMode.FIT;
                    break;
                }
                case 5: {
                    scaleMode = ScaleMode.FIT;
                    break;
                }
                case 6: {
                    scaleMode = ScaleMode.FIT;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return scaleMode;
        }

        private final CameraViewfinder.ScaleType getScaleType(ScaleMode scaleMode, Position position) {
            switch (WhenMappings.$EnumSwitchMapping$2[position.ordinal()]) {
                case 1: {
                    CameraViewfinder.ScaleType scaleType;
                    switch (WhenMappings.$EnumSwitchMapping$1[scaleMode.ordinal()]) {
                        case 1: {
                            scaleType = CameraViewfinder.ScaleType.FILL_START;
                            break;
                        }
                        case 2: {
                            scaleType = CameraViewfinder.ScaleType.FIT_START;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    return scaleType;
                }
                case 2: {
                    CameraViewfinder.ScaleType scaleType;
                    switch (WhenMappings.$EnumSwitchMapping$1[scaleMode.ordinal()]) {
                        case 1: {
                            scaleType = CameraViewfinder.ScaleType.FILL_CENTER;
                            break;
                        }
                        case 2: {
                            scaleType = CameraViewfinder.ScaleType.FIT_CENTER;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    return scaleType;
                }
                case 3: {
                    CameraViewfinder.ScaleType scaleType;
                    switch (WhenMappings.$EnumSwitchMapping$1[scaleMode.ordinal()]) {
                        case 1: {
                            scaleType = CameraViewfinder.ScaleType.FILL_END;
                            break;
                        }
                        case 2: {
                            scaleType = CameraViewfinder.ScaleType.FIT_END;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    return scaleType;
                }
            }
            throw new NoWhenBranchMatchedException();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;
            public static final /* synthetic */ int[] $EnumSwitchMapping$2;

            static {
                int[] nArray = new int[CameraViewfinder.ScaleType.values().length];
                try {
                    nArray[CameraViewfinder.ScaleType.FILL_START.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CameraViewfinder.ScaleType.FILL_CENTER.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CameraViewfinder.ScaleType.FILL_END.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CameraViewfinder.ScaleType.FIT_START.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CameraViewfinder.ScaleType.FIT_CENTER.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CameraViewfinder.ScaleType.FIT_END.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[ScaleMode.values().length];
                try {
                    nArray[ScaleMode.FILL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ScaleMode.FIT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
                nArray = new int[Position.values().length];
                try {
                    nArray[Position.START.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Position.CENTER.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Position.END.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$2 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lio/github/thibaultbee/streampack/views/PreviewView$Listener;", "", "onPreviewFailed", "", "t", "", "onPreviewStarted", "onZoomRationOnPinchChanged", "zoomRatio", "", "core_release"})
    public static interface Listener {
        public void onPreviewStarted();

        public void onPreviewFailed(@NotNull Throwable var1);

        public void onZoomRationOnPinchChanged(float var1);

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void onPreviewStarted(@NotNull Listener $this) {
            }

            public static void onPreviewFailed(@NotNull Listener $this, @NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            }

            public static void onZoomRationOnPinchChanged(@NotNull Listener $this, float zoomRatio) {
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lio/github/thibaultbee/streampack/views/PreviewView$PinchToZoomOnScaleGestureListener;", "Landroid/view/ScaleGestureDetector$SimpleOnScaleGestureListener;", "(Lio/github/thibaultbee/streampack/views/PreviewView;)V", "onScale", "", "detector", "Landroid/view/ScaleGestureDetector;", "core_release"})
    private final class PinchToZoomOnScaleGestureListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        public boolean onScale(@NotNull ScaleGestureDetector detector) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
                Object object = PreviewView.this.getStreamer();
                if (object == null || (object = object.getSettings()) == null || (object = object.getCamera()) == null || (object = ((CameraSettings)object).getZoom()) == null) break block1;
                Object object2 = object;
                PreviewView previewView = PreviewView.this;
                Object it = object2;
                boolean bl = false;
                ((Zoom)it).onPinch(detector.getScaleFactor());
                Listener listener = previewView.getListener();
                if (listener != null) {
                    listener.onZoomRationOnPinchChanged(((Zoom)it).getZoomRatio());
                }
            }
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\nB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u000b"}, d2={"Lio/github/thibaultbee/streampack/views/PreviewView$Position;", "", "value", "", "(Ljava/lang/String;II)V", "getValue", "()I", "START", "CENTER", "END", "Companion", "core_release"})
    public static final class Position
    extends Enum<Position> {
        @NotNull
        public static final Companion Companion;
        private final int value;
        public static final /* enum */ Position START;
        public static final /* enum */ Position CENTER;
        public static final /* enum */ Position END;
        private static final /* synthetic */ Position[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Position(int value) {
            this.value = value;
        }

        public final int getValue() {
            return this.value;
        }

        public static Position[] values() {
            return (Position[])$VALUES.clone();
        }

        public static Position valueOf(String value) {
            return Enum.valueOf(Position.class, value);
        }

        @NotNull
        public static EnumEntries<Position> getEntries() {
            return $ENTRIES;
        }

        static {
            START = new Position(0);
            CENTER = new Position(1);
            END = new Position(2);
            $VALUES = positionArray = new Position[]{Position.START, Position.CENTER, Position.END};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lio/github/thibaultbee/streampack/views/PreviewView$Position$Companion;", "", "()V", "entryOf", "Lio/github/thibaultbee/streampack/views/PreviewView$Position;", "value", "", "entryOf$core_release", "core_release"})
        @SourceDebugExtension(value={"SMAP\nPreviewView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewView.kt\nio/github/thibaultbee/streampack/views/PreviewView$Position$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,498:1\n223#2,2:499\n*S KotlinDebug\n*F\n+ 1 PreviewView.kt\nio/github/thibaultbee/streampack/views/PreviewView$Position$Companion\n*L\n462#1:499,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Position entryOf$core_release(int value) {
                Object element$iv2;
                block1: {
                    Iterable $this$first$iv = (Iterable)Position.getEntries();
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        Position it = (Position)((Object)element$iv2);
                        boolean bl = false;
                        if (!(it.getValue() == value)) continue;
                        break block1;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                return (Position)((Object)element$iv2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\tB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\n"}, d2={"Lio/github/thibaultbee/streampack/views/PreviewView$ScaleMode;", "", "value", "", "(Ljava/lang/String;II)V", "getValue", "()I", "FILL", "FIT", "Companion", "core_release"})
    public static final class ScaleMode
    extends Enum<ScaleMode> {
        @NotNull
        public static final Companion Companion;
        private final int value;
        public static final /* enum */ ScaleMode FILL;
        public static final /* enum */ ScaleMode FIT;
        private static final /* synthetic */ ScaleMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ScaleMode(int value) {
            this.value = value;
        }

        public final int getValue() {
            return this.value;
        }

        public static ScaleMode[] values() {
            return (ScaleMode[])$VALUES.clone();
        }

        public static ScaleMode valueOf(String value) {
            return Enum.valueOf(ScaleMode.class, value);
        }

        @NotNull
        public static EnumEntries<ScaleMode> getEntries() {
            return $ENTRIES;
        }

        static {
            FILL = new ScaleMode(0);
            FIT = new ScaleMode(1);
            $VALUES = scaleModeArray = new ScaleMode[]{ScaleMode.FILL, ScaleMode.FIT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lio/github/thibaultbee/streampack/views/PreviewView$ScaleMode$Companion;", "", "()V", "entryOf", "Lio/github/thibaultbee/streampack/views/PreviewView$ScaleMode;", "value", "", "entryOf$core_release", "core_release"})
        @SourceDebugExtension(value={"SMAP\nPreviewView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewView.kt\nio/github/thibaultbee/streampack/views/PreviewView$ScaleMode$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,498:1\n223#2,2:499\n*S KotlinDebug\n*F\n+ 1 PreviewView.kt\nio/github/thibaultbee/streampack/views/PreviewView$ScaleMode$Companion\n*L\n493#1:499,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ScaleMode entryOf$core_release(int value) {
                Object element$iv2;
                block1: {
                    Iterable $this$first$iv = (Iterable)ScaleMode.getEntries();
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        ScaleMode it = (ScaleMode)((Object)element$iv2);
                        boolean bl = false;
                        if (!(it.getValue() == value)) continue;
                        break block1;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                return (ScaleMode)((Object)element$iv2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

