/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultmeyer.cuid;

import io.github.thibaultmeyer.cuid.exception.CUIDGenerationException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Objects;

public final class CUID
implements Serializable,
Comparable<CUID> {
    private static final long serialVersionUID = -2441709761088574861L;
    private static final int NUMBER_BASE = 36;
    private final String value;

    private CUID(String value) {
        this.value = value;
    }

    public static CUID randomCUID2() {
        return CUID.randomCUID2(24);
    }

    public static CUID randomCUID2(int length) {
        if (length <= 0) {
            throw new CUIDGenerationException("the length must be at least 1");
        }
        String time = Long.toString(System.currentTimeMillis(), 36);
        char firstLetter = CUIDv2.ALPHABET_ARRAY[CUID.safeAbs(Common.nextIntValue()) % CUIDv2.ALPHABET_ARRAY.length];
        String hash = CUIDv2.computeHash(time + CUIDv2.createEntropy(length) + CUIDv2.nextCounterValue() + Common.MACHINE_FINGERPRINT, length);
        return new CUID(firstLetter + hash.substring(1, length));
    }

    public static CUID randomCUID1() {
        String timestamp = Long.toString(System.currentTimeMillis(), 36);
        String counter = Common.padWithZero(Integer.toString(CUIDv1.nextCounterValue(), 36), 4);
        String random = CUIDv1.getRandomBlock() + CUIDv1.getRandomBlock();
        return new CUID("c" + timestamp + counter + Common.MACHINE_FINGERPRINT + random);
    }

    public static CUID fromString(String cuidAsString) {
        if (CUID.isValid(cuidAsString)) {
            return new CUID(cuidAsString);
        }
        throw new IllegalArgumentException("CUID string is invalid: '" + cuidAsString + "'");
    }

    public static boolean isValid(String cuidAsString) {
        return cuidAsString != null && (cuidAsString.length() == 25 && cuidAsString.startsWith("c") || !cuidAsString.isEmpty()) && cuidAsString.chars().filter(c -> !(c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122)).count() == 0L;
    }

    private static int safeAbs(int i) {
        return i == Integer.MIN_VALUE ? 0 : Math.abs(i);
    }

    @Override
    public int compareTo(CUID cuid) {
        if (cuid == null) {
            return -1;
        }
        return this.value.compareTo(cuid.value);
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CUID cuid = (CUID)o;
        return Objects.equals(this.value, cuid.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    private static final class CUIDv2 {
        private static final char[] ALPHABET_ARRAY = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        private static final int[] PRIME_NUMBER_ARRAY = new int[]{109717, 109721, 109741, 109751, 109789, 109793, 109807, 109819, 109829, 109831};
        private static final int LENGTH_STANDARD = 24;
        private static int counter = Integer.MAX_VALUE;

        private CUIDv2() {
        }

        private static synchronized int nextCounterValue() {
            counter = counter < Integer.MAX_VALUE ? counter : CUID.safeAbs(Common.nextIntValue());
            return counter++;
        }

        private static String createEntropy(int length) {
            StringBuilder stringBuilder = new StringBuilder(length);
            while (stringBuilder.length() < length) {
                int primeNumber = PRIME_NUMBER_ARRAY[CUID.safeAbs(Common.nextIntValue()) % PRIME_NUMBER_ARRAY.length];
                stringBuilder.append(Integer.toString(primeNumber * Common.nextIntValue(), 36));
            }
            return stringBuilder.toString();
        }

        private static String computeHash(String content, int saltLength) {
            String salt = CUIDv2.createEntropy(saltLength);
            try {
                return new BigInteger(MessageDigest.getInstance("SHA3-256").digest((content + salt).getBytes(StandardCharsets.UTF_8))).toString(36);
            }
            catch (NoSuchAlgorithmException exception) {
                throw new CUIDGenerationException(exception);
            }
        }
    }

    private static final class Common {
        private static final int RANDOM_BUFFER_SIZE = 4096;
        private static final byte[] RANDOM_BUFFER = new byte[4096];
        private static final SecureRandom NUMBER_GENERATOR = new SecureRandom();
        private static final String MACHINE_FINGERPRINT = Common.getMachineFingerprint();
        private static int randomBufferIndex = 4096;

        private Common() {
        }

        private static synchronized int nextIntValue() {
            if (randomBufferIndex == 4096) {
                NUMBER_GENERATOR.nextBytes(RANDOM_BUFFER);
                randomBufferIndex = 0;
            }
            return RANDOM_BUFFER[randomBufferIndex++] << 24 | (RANDOM_BUFFER[randomBufferIndex++] & 0xFF) << 16 | (RANDOM_BUFFER[randomBufferIndex++] & 0xFF) << 8 | RANDOM_BUFFER[randomBufferIndex++] & 0xFF;
        }

        private static String padWithZero(String str, int size) {
            String paddedString = "000000000" + str;
            return paddedString.substring(paddedString.length() - size);
        }

        private static String getMachineFingerprint() {
            String machineName = ManagementFactory.getRuntimeMXBean().getName();
            String[] machineNameTokenArray = machineName.split("@");
            String pid = machineNameTokenArray[0];
            String hostname = machineNameTokenArray[1];
            int acc = hostname.length() + 36;
            for (int i = 0; i < hostname.length(); ++i) {
                acc += hostname.charAt(i);
            }
            String idBlock = Common.padWithZero(pid, 2);
            String nameBlock = Common.padWithZero(Integer.toString(acc), 2);
            return idBlock + nameBlock;
        }
    }

    private static final class CUIDv1 {
        private static final int BLOCK_SIZE = 4;
        private static final int LENGTH_STANDARD = 25;
        private static final String START_CHARACTER = "c";
        private static final int DISCRETE_VALUE = (int)Math.pow(36.0, 4.0);
        private static int counter = 0;

        private CUIDv1() {
        }

        private static synchronized int nextCounterValue() {
            counter = counter < DISCRETE_VALUE ? counter : 0;
            return counter++;
        }

        private static String getRandomBlock() {
            return Common.padWithZero(Integer.toString(Common.nextIntValue() * DISCRETE_VALUE, 36), 4);
        }
    }
}

