/*
 * Decompiled with CFR 0.152.
 */
package io.github.thoroldvix.api;

public class TranscriptRetrievalException
extends Exception {
    private static final String ERROR_MESSAGE = "Could not retrieve transcript for the video: %s.\nReason: %s";
    private static final String YOUTUBE_WATCH_URL = "https://www.youtube.com/watch?v=";

    public TranscriptRetrievalException(String videoId, String message, Throwable cause) {
        super(TranscriptRetrievalException.buildErrorMessage(videoId, message), cause);
    }

    public TranscriptRetrievalException(String videoId, String message) {
        super(TranscriptRetrievalException.buildErrorMessage(videoId, message));
    }

    private static String buildErrorMessage(String videoId, String message) {
        String videoUrl = YOUTUBE_WATCH_URL + videoId;
        return String.format(ERROR_MESSAGE, videoUrl, message);
    }
}

