/*
 * Decompiled with CFR 0.152.
 */
package io.github.thoroldvix.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import io.github.thoroldvix.api.TranscriptContent;
import io.github.thoroldvix.api.TranscriptRetrievalException;
import io.github.thoroldvix.internal.DefaultTranscriptContent;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;

final class TranscriptContentXML {
    private final XmlMapper xmlMapper = new XmlMapper();
    private final String xml;
    private final String videoId;

    TranscriptContentXML(String xml, String videoId) {
        this.xml = xml;
        this.videoId = videoId;
    }

    TranscriptContent transcriptContent() throws TranscriptRetrievalException {
        List<DefaultTranscriptContent.Fragment> fragments = this.parseFragments();
        List<DefaultTranscriptContent.Fragment> content = TranscriptContentXML.formatFragments(fragments);
        return new DefaultTranscriptContent(content);
    }

    private static List<DefaultTranscriptContent.Fragment> formatFragments(List<DefaultTranscriptContent.Fragment> fragments) {
        return fragments.stream().filter(TranscriptContentXML::isValidTranscriptFragment).map(TranscriptContentXML::removeHtmlTags).map(TranscriptContentXML::unescapeXmlTags).collect(Collectors.toList());
    }

    private List<DefaultTranscriptContent.Fragment> parseFragments() throws TranscriptRetrievalException {
        try {
            return (List)this.xmlMapper.readValue(this.xml, (TypeReference)new TypeReference<List<DefaultTranscriptContent.Fragment>>(){});
        }
        catch (JsonProcessingException e) {
            throw new TranscriptRetrievalException(this.videoId, "Failed to parse transcript content XML.", e);
        }
    }

    private static DefaultTranscriptContent.Fragment unescapeXmlTags(DefaultTranscriptContent.Fragment fragment) {
        String formattedValue = StringEscapeUtils.unescapeXml((String)fragment.getText());
        return new DefaultTranscriptContent.Fragment(formattedValue, fragment.getStart(), fragment.getDur());
    }

    private static DefaultTranscriptContent.Fragment removeHtmlTags(DefaultTranscriptContent.Fragment fragment) {
        Pattern pattern = Pattern.compile("<[^>]*>", 2);
        String text = pattern.matcher(fragment.getText()).replaceAll("");
        return new DefaultTranscriptContent.Fragment(text, fragment.getStart(), fragment.getDur());
    }

    private static boolean isValidTranscriptFragment(DefaultTranscriptContent.Fragment fragment) {
        return fragment.getText() != null && !fragment.getText().isBlank();
    }
}

