/*
 * Decompiled with CFR 0.152.
 */
package io.github.thoroldvix.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.thoroldvix.api.PlaylistsTranscriptApi;
import io.github.thoroldvix.api.TranscriptList;
import io.github.thoroldvix.api.TranscriptRetrievalException;
import io.github.thoroldvix.api.YoutubeClient;
import io.github.thoroldvix.api.YoutubeTranscriptApi;
import io.github.thoroldvix.api.YtApiV3Endpoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

class DefaultPlaylistsTranscriptApi
implements PlaylistsTranscriptApi {
    private final YoutubeClient client;
    private final YoutubeTranscriptApi youtubeTranscriptApi;
    private final ObjectMapper objectMapper;

    DefaultPlaylistsTranscriptApi(YoutubeClient client, YoutubeTranscriptApi youtubeTranscriptApi) {
        this.client = client;
        this.objectMapper = new ObjectMapper();
        this.youtubeTranscriptApi = youtubeTranscriptApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<String, TranscriptList> listTranscriptsForPlaylist(String playlistId, String apiKey, String cookiesPath, boolean continueOnError) throws TranscriptRetrievalException {
        HashMap<String, TranscriptList> transcriptLists = new HashMap<String, TranscriptList>();
        List<String> videoIds = this.getVideoIds(playlistId, apiKey);
        ExecutorService executor = Executors.newCachedThreadPool();
        ArrayList<Future<TranscriptList>> futures = new ArrayList<Future<TranscriptList>>();
        for (String string : videoIds) {
            futures.add(executor.submit(() -> {
                try {
                    return this.getTranscriptList(string, cookiesPath);
                }
                catch (TranscriptRetrievalException e) {
                    if (!continueOnError) {
                        throw e;
                    }
                    return null;
                }
            }));
        }
        try {
            for (Future future : futures) {
                try {
                    TranscriptList transcriptList = (TranscriptList)future.get();
                    if (transcriptList == null) continue;
                    transcriptLists.put(transcriptList.getVideoId(), transcriptList);
                }
                catch (ExecutionException e) {
                    if (continueOnError) continue;
                    executor.shutdownNow();
                    throw new TranscriptRetrievalException("Failed to retrieve transcripts for playlist: " + playlistId, e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    executor.shutdownNow();
                    throw new TranscriptRetrievalException("Failed to retrieve transcripts for playlist: " + playlistId, e);
                    return transcriptLists;
                }
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    private TranscriptList getTranscriptList(String videoId, String cookiesPath) throws TranscriptRetrievalException {
        if (cookiesPath != null) {
            return this.youtubeTranscriptApi.listTranscriptsWithCookies(videoId, cookiesPath);
        }
        return this.youtubeTranscriptApi.listTranscripts(videoId);
    }

    @Override
    public Map<String, TranscriptList> listTranscriptsForPlaylist(String playlistId, String apiKey, boolean continueOnError) throws TranscriptRetrievalException {
        return this.listTranscriptsForPlaylist(playlistId, apiKey, null, continueOnError);
    }

    @Override
    public Map<String, TranscriptList> listTranscriptsForChannel(String channelName, String apiKey, String cookiesPath, boolean continueOnError) throws TranscriptRetrievalException {
        String channelId = this.getChannelId(channelName, apiKey);
        String channelPlaylistId = this.getChannelPlaylistId(channelId, apiKey);
        return this.listTranscriptsForPlaylist(channelPlaylistId, apiKey, cookiesPath, continueOnError);
    }

    @Override
    public Map<String, TranscriptList> listTranscriptsForChannel(String channelName, String apiKey, boolean continueOnError) throws TranscriptRetrievalException {
        return this.listTranscriptsForChannel(channelName, apiKey, null, continueOnError);
    }

    private String getChannelPlaylistId(String channelId, String apiKey) throws TranscriptRetrievalException {
        Map<String, String> params = this.createParams("key", apiKey, "part", "contentDetails", "id", channelId);
        String channelJson = this.client.get(YtApiV3Endpoint.CHANNELS, params);
        JsonNode jsonNode = this.parseJson(channelJson, "Could not parse channel JSON for the channel with id: " + channelId);
        JsonNode channel = jsonNode.get("items").get(0);
        return channel.get("contentDetails").get("relatedPlaylists").get("uploads").asText();
    }

    private String getChannelId(String channelName, String apiKey) throws TranscriptRetrievalException {
        Map<String, String> params = this.createParams("key", apiKey, "q", channelName, "part", "snippet", "type", "channel");
        String searchJson = this.client.get(YtApiV3Endpoint.SEARCH, params);
        JsonNode jsonNode = this.parseJson(searchJson, "Could not parse search JSON for the channel: " + channelName);
        for (JsonNode item : jsonNode.get("items")) {
            JsonNode snippet = item.get("snippet");
            if (!snippet.get("title").asText().equals(channelName)) continue;
            return snippet.get("channelId").asText();
        }
        throw new TranscriptRetrievalException("Could not find channel with the name: " + channelName);
    }

    private List<String> getVideoIds(String playlistId, String apiKey) throws TranscriptRetrievalException {
        Map<String, String> params = this.createParams("key", apiKey, "playlistId", playlistId, "part", "snippet", "maxResults", "50");
        ArrayList<String> videoIds = new ArrayList<String>();
        while (true) {
            String playlistJson = this.client.get(YtApiV3Endpoint.PLAYLIST_ITEMS, params);
            JsonNode jsonNode = this.parseJson(playlistJson, "Could not parse playlist JSON for the playlist: " + playlistId);
            this.extractVideoId(jsonNode, videoIds);
            JsonNode nextPageToken = jsonNode.get("nextPageToken");
            if (nextPageToken == null) break;
            params.put("pageToken", nextPageToken.asText());
        }
        return videoIds;
    }

    private void extractVideoId(JsonNode jsonNode, List<String> videoIds) {
        jsonNode.get("items").forEach(item -> {
            String videoId = item.get("snippet").get("resourceId").get("videoId").asText();
            videoIds.add(videoId);
        });
    }

    private Map<String, String> createParams(String ... params) {
        HashMap<String, String> map = new HashMap<String, String>(params.length / 2);
        for (int i = 0; i < params.length; i += 2) {
            map.put(params[i], params[i + 1]);
        }
        return map;
    }

    private JsonNode parseJson(String json, String errorMessage) throws TranscriptRetrievalException {
        try {
            return this.objectMapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            throw new TranscriptRetrievalException(errorMessage, e);
        }
    }
}

