/*
 * Decompiled with CFR 0.152.
 */
package io.github.thoroldvix.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.github.thoroldvix.api.TranscriptContent;
import io.github.thoroldvix.api.TranscriptFormatter;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class TranscriptFormatters {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private TranscriptFormatters() {
    }

    public static TranscriptFormatter jsonFormatter() {
        return transcriptContent -> TranscriptFormatters.formatAsJSON(transcriptContent, OBJECT_MAPPER.writer());
    }

    public static TranscriptFormatter prettyJsonFormatter() {
        return transcriptContent -> TranscriptFormatters.formatAsJSON(transcriptContent, OBJECT_MAPPER.writerWithDefaultPrettyPrinter());
    }

    private static String formatAsJSON(TranscriptContent transcriptContent, ObjectWriter objectWriter) {
        try {
            return objectWriter.writeValueAsString((Object)transcriptContent);
        }
        catch (JsonProcessingException e) {
            return "{}";
        }
    }

    public static TranscriptFormatter textFormatter() {
        return transcriptContent -> transcriptContent.getContent().stream().map(TranscriptContent.Fragment::getText).collect(Collectors.joining("\n"));
    }

    public static TranscriptFormatter webVTTFormatter() {
        return transcriptContent -> "WEBVTT\n\n" + TranscriptFormatters.formatAsSubtitles(transcriptContent, fragment -> String.format("%s%n%s", TranscriptFormatters.fragmentToTimeStamp(fragment), fragment.getText()));
    }

    private static String formatAsSubtitles(TranscriptContent transcriptContent, Function<TranscriptContent.Fragment, String> formatter) {
        return transcriptContent.getContent().stream().map(formatter).collect(Collectors.joining("\n\n"));
    }

    private static String fragmentToTimeStamp(TranscriptContent.Fragment fragment) {
        return String.format("%s --> %s", TranscriptFormatters.secondsToTimeStamp(fragment.getStart()), TranscriptFormatters.secondsToTimeStamp(fragment.getStart() + fragment.getDur()));
    }

    private static String secondsToTimeStamp(double seconds) {
        int hour = (int)(seconds / 3600.0);
        int minute = (int)(seconds % 3600.0 / 60.0);
        int second = (int)(seconds % 60.0);
        int millisecond = (int)(seconds % 1.0 * 1000.0);
        return String.format("%02d:%02d:%02d.%03d", hour, minute, second, millisecond);
    }

    public static TranscriptFormatter srtFormatter() {
        return transcriptContent -> {
            AtomicInteger i = new AtomicInteger(1);
            return TranscriptFormatters.formatAsSubtitles(transcriptContent, fragment -> String.format("%d%n%s%n%s", i.getAndIncrement(), TranscriptFormatters.fragmentToTimeStamp(fragment), fragment.getText()));
        };
    }
}

