/*
 * Decompiled with CFR 0.152.
 */
package io.github.thoroldvix.api;

public class TranscriptRequest {
    private final String apiKey;
    private final String cookiesPath;
    private final boolean stopOnError;

    public TranscriptRequest(String apiKey, String cookiesPath, boolean stopOnError) {
        if (apiKey == null || apiKey.isBlank()) {
            throw new IllegalArgumentException("API key cannot be null or blank");
        }
        this.apiKey = apiKey;
        this.cookiesPath = cookiesPath;
        this.stopOnError = stopOnError;
    }

    public TranscriptRequest(String apiKey, String cookiesPath) {
        this(apiKey, cookiesPath, true);
    }

    public TranscriptRequest(String apiKey) {
        this(apiKey, null, true);
    }

    public TranscriptRequest(String apiKey, boolean stopOnError) {
        this(apiKey, null, stopOnError);
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getCookiesPath() {
        return this.cookiesPath;
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }
}

