/*
 * Decompiled with CFR 0.152.
 */
package io.github.thoroldvix.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import io.github.thoroldvix.api.TranscriptContent;
import io.github.thoroldvix.api.TranscriptRetrievalException;
import io.github.thoroldvix.internal.DefaultTranscriptContent;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;

final class TranscriptContentExtractor {
    private final String videoId;
    private static final XmlMapper XML_MAPPER = new XmlMapper();

    TranscriptContentExtractor(String videoId) {
        this.videoId = videoId;
    }

    private static List<DefaultTranscriptContent.Fragment> formatFragments(List<DefaultTranscriptContent.Fragment> fragments) {
        return fragments.stream().filter(TranscriptContentExtractor::isValidTranscriptFragment).map(TranscriptContentExtractor::removeHtmlTags).map(TranscriptContentExtractor::unescapeXmlTags).collect(Collectors.toList());
    }

    TranscriptContent extract(String xml) throws TranscriptRetrievalException {
        List<DefaultTranscriptContent.Fragment> fragments = this.parseFragments(xml);
        List<DefaultTranscriptContent.Fragment> content = TranscriptContentExtractor.formatFragments(fragments);
        return new DefaultTranscriptContent(content);
    }

    private static DefaultTranscriptContent.Fragment unescapeXmlTags(DefaultTranscriptContent.Fragment fragment) {
        String formattedValue = StringEscapeUtils.unescapeXml((String)fragment.getText());
        return new DefaultTranscriptContent.Fragment(formattedValue, fragment.getStart(), fragment.getDur());
    }

    private static DefaultTranscriptContent.Fragment removeHtmlTags(DefaultTranscriptContent.Fragment fragment) {
        Pattern pattern = Pattern.compile("<[^>]*>", 2);
        String text = pattern.matcher(fragment.getText()).replaceAll("");
        return new DefaultTranscriptContent.Fragment(text, fragment.getStart(), fragment.getDur());
    }

    private static boolean isValidTranscriptFragment(DefaultTranscriptContent.Fragment fragment) {
        return fragment.getText() != null && !fragment.getText().isBlank();
    }

    private List<DefaultTranscriptContent.Fragment> parseFragments(String xml) throws TranscriptRetrievalException {
        try {
            return (List)XML_MAPPER.readValue(xml, (TypeReference)new TypeReference<List<DefaultTranscriptContent.Fragment>>(){});
        }
        catch (JsonProcessingException e) {
            throw new TranscriptRetrievalException(this.videoId, "Failed to parse transcript content XML.", e);
        }
    }
}

