/*
 * Decompiled with CFR 0.152.
 */
package io.github.thoroldvix.internal;

import io.github.thoroldvix.api.Transcript;
import io.github.thoroldvix.api.TranscriptList;
import io.github.thoroldvix.api.TranscriptRetrievalException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;

final class DefaultTranscriptList
implements TranscriptList {
    private final String videoId;
    private final Map<String, Transcript> manualTranscripts;
    private final Map<String, Transcript> generatedTranscripts;
    private final Map<String, String> translationLanguages;

    DefaultTranscriptList(String videoId, Map<String, Transcript> manualTranscripts, Map<String, Transcript> generatedTranscripts, Map<String, String> translationLanguages) {
        this.videoId = videoId;
        this.manualTranscripts = manualTranscripts;
        this.generatedTranscripts = generatedTranscripts;
        this.translationLanguages = translationLanguages;
    }

    private static String[] getDefault(String[] languageCodes) {
        String[] stringArray;
        if (languageCodes.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "en";
        } else {
            stringArray = languageCodes;
        }
        return stringArray;
    }

    private static void validateLanguageCodes(String ... languageCodes) {
        for (String languageCode : languageCodes) {
            if (languageCode == null) {
                throw new IllegalArgumentException("Language codes cannot be null");
            }
            if (!languageCode.isBlank()) continue;
            throw new IllegalArgumentException("Language codes cannot be blank");
        }
    }

    @Override
    public Transcript findTranscript(String ... languageCodes) throws TranscriptRetrievalException {
        try {
            return this.findManualTranscript(languageCodes);
        }
        catch (TranscriptRetrievalException e) {
            return this.findGeneratedTranscript(languageCodes);
        }
    }

    @Override
    public Transcript findManualTranscript(String ... languageCodes) throws TranscriptRetrievalException {
        return this.findTranscript(this.manualTranscripts, DefaultTranscriptList.getDefault(languageCodes));
    }

    private Transcript findTranscript(Map<String, Transcript> transcripts, String ... languageCodes) throws TranscriptRetrievalException {
        DefaultTranscriptList.validateLanguageCodes(languageCodes);
        for (String languageCode : languageCodes) {
            if (!transcripts.containsKey(languageCode)) continue;
            return transcripts.get(languageCode);
        }
        throw new TranscriptRetrievalException(this.videoId, String.format("No transcripts were found for any of the requested language codes: %s. %s.", Arrays.toString(languageCodes), this));
    }

    @Override
    public Transcript findGeneratedTranscript(String ... languageCodes) throws TranscriptRetrievalException {
        return this.findTranscript(this.generatedTranscripts, DefaultTranscriptList.getDefault(languageCodes));
    }

    @Override
    public String getVideoId() {
        return this.videoId;
    }

    @Override
    public Iterator<Transcript> iterator() {
        return new Iterator<Transcript>(){
            private final Iterator<Transcript> manualIterator;
            private final Iterator<Transcript> generatedIterator;
            {
                this.manualIterator = DefaultTranscriptList.this.manualTranscripts.values().iterator();
                this.generatedIterator = DefaultTranscriptList.this.generatedTranscripts.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.manualIterator.hasNext() || this.generatedIterator.hasNext();
            }

            @Override
            public Transcript next() {
                if (this.manualIterator.hasNext()) {
                    return this.manualIterator.next();
                }
                return this.generatedIterator.next();
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTranscriptList that = (DefaultTranscriptList)o;
        return Objects.equals(this.videoId, that.videoId) && Objects.equals(this.manualTranscripts, that.manualTranscripts) && Objects.equals(this.generatedTranscripts, that.generatedTranscripts);
    }

    public int hashCode() {
        return Objects.hash(this.videoId, this.manualTranscripts, this.generatedTranscripts);
    }

    public String toString() {
        String template = "For video with ID (%s) transcripts are available in the following languages:\nManually created: %s\nAutomatically generated: %s\nAvailable translation languages: %s";
        return String.format(template, this.videoId, new TreeSet<String>(this.manualTranscripts.keySet()), new TreeSet<String>(this.generatedTranscripts.keySet()), new TreeSet<String>(this.translationLanguages.keySet()));
    }
}

