/*
 * Decompiled with CFR 0.152.
 */
package io.github.thoroldvix.api;

import io.github.thoroldvix.api.TranscriptRetrievalException;
import io.github.thoroldvix.api.YoutubeClient;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;

final class DefaultYoutubeClient
implements YoutubeClient {
    private final HttpClient httpClient;
    private static final String DEFAULT_ERROR_MESSAGE = "Request to YouTube failed.";

    DefaultYoutubeClient() {
        this.httpClient = HttpClient.newHttpClient();
    }

    DefaultYoutubeClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public String get(String url, Map<String, String> headers) throws TranscriptRetrievalException {
        String[] headersArray = this.createHeaders(headers);
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(url));
        if (headersArray.length > 0) {
            requestBuilder.headers(headersArray);
        }
        return this.send(requestBuilder.build());
    }

    private String send(HttpRequest request) throws TranscriptRetrievalException {
        HttpResponse<String> response;
        try {
            response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException e) {
            throw new TranscriptRetrievalException(DEFAULT_ERROR_MESSAGE, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TranscriptRetrievalException(DEFAULT_ERROR_MESSAGE, e);
        }
        if (response.statusCode() != 200) {
            throw new TranscriptRetrievalException("Request to YouTube failed. Status code: " + response.statusCode());
        }
        return response.body();
    }

    @Override
    public String post(String url, String json) throws TranscriptRetrievalException {
        HttpRequest request = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(json)).uri(URI.create(url)).build();
        return this.send(request);
    }

    private String[] createHeaders(Map<String, String> headers) {
        String[] headersArray = new String[headers.size() * 2];
        int i = 0;
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            headersArray[i++] = entry.getKey();
            headersArray[i++] = entry.getValue();
        }
        return headersArray;
    }
}

