/*
 * Decompiled with CFR 0.152.
 */
package io.github.thoroldvix.api;

import io.github.thoroldvix.api.TranscriptContent;
import io.github.thoroldvix.api.TranscriptContentExtractor;
import io.github.thoroldvix.api.TranscriptRetrievalException;
import io.github.thoroldvix.api.YoutubeApi;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class Transcript {
    private final YoutubeApi youtubeApi;
    private final String videoId;
    private final String apiUrl;
    private final String language;
    private final String languageCode;
    private final boolean isGenerated;
    private final Map<String, String> translationLanguages;
    private final boolean isTranslatable;

    Transcript(YoutubeApi youtubeApi, String videoId, String apiUrl, String language, String languageCode, boolean isGenerated, Map<String, String> translationLanguages) {
        this.youtubeApi = youtubeApi;
        this.videoId = videoId;
        this.apiUrl = apiUrl;
        this.language = language;
        this.languageCode = languageCode;
        this.isGenerated = isGenerated;
        this.translationLanguages = translationLanguages;
        this.isTranslatable = !translationLanguages.isEmpty();
    }

    public TranscriptContent fetch() throws TranscriptRetrievalException {
        String transcriptXml = this.youtubeApi.fetchTranscriptContentXml(this.videoId, this.apiUrl);
        return TranscriptContentExtractor.extract(this.videoId, transcriptXml);
    }

    public Transcript translate(String languageCode) throws TranscriptRetrievalException {
        this.checkIfPossibleToTranslate(languageCode);
        return new Transcript(this.youtubeApi, this.videoId, this.createTranslationApiUrl(languageCode), this.translationLanguages.get(languageCode), languageCode, this.isGenerated, this.translationLanguages);
    }

    private void checkIfPossibleToTranslate(String languageCode) throws TranscriptRetrievalException {
        if (!this.isTranslatable) {
            throw new TranscriptRetrievalException(this.videoId, "This transcript is not translatable");
        }
        if (!this.translationLanguages.containsKey(languageCode)) {
            throw new TranscriptRetrievalException(this.videoId, String.format("Translation language '%s' is not available", languageCode));
        }
    }

    private String createTranslationApiUrl(String languageCode) {
        return String.format("%s&tlang=%s", this.apiUrl, languageCode);
    }

    public String getVideoId() {
        return this.videoId;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public boolean isGenerated() {
        return this.isGenerated;
    }

    public Set<String> getTranslationLanguages() {
        return Collections.unmodifiableSet(this.translationLanguages.keySet());
    }

    public boolean isTranslatable() {
        return this.isTranslatable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transcript that = (Transcript)o;
        return this.isGenerated == that.isGenerated && this.isTranslatable == that.isTranslatable && Objects.equals(this.youtubeApi, that.youtubeApi) && Objects.equals(this.videoId, that.videoId) && Objects.equals(this.apiUrl, that.apiUrl) && Objects.equals(this.language, that.language) && Objects.equals(this.languageCode, that.languageCode) && Objects.equals(this.translationLanguages, that.translationLanguages);
    }

    public int hashCode() {
        return Objects.hash(this.youtubeApi, this.videoId, this.apiUrl, this.language, this.languageCode, this.isGenerated, this.translationLanguages, this.isTranslatable);
    }

    public String toString() {
        String template = "Transcript for video with id: %s.\nLanguage: %s\nLanguage code: %s\nAPI URL for retrieving content: %s\nAvailable translation languages: %s";
        return String.format(template, this.videoId, this.language, this.languageCode, this.apiUrl, new TreeSet<String>(this.translationLanguages.keySet()));
    }
}

