/*
 * Decompiled with CFR 0.152.
 */
package io.github.thoroldvix.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TranscriptContent {
    private final List<Fragment> content;

    public TranscriptContent(List<Fragment> content) {
        this.content = content;
    }

    public List<Fragment> getContent() {
        return Collections.unmodifiableList(this.content);
    }

    static TranscriptContent empty() {
        return new TranscriptContent(Collections.emptyList());
    }

    boolean isEmpty() {
        return this.content.isEmpty();
    }

    public int hashCode() {
        return Objects.hashCode(this.content);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TranscriptContent that = (TranscriptContent)o;
        return Objects.equals(this.content, that.content);
    }

    public String toString() {
        return "content=[" + this.content.stream().map(Object::toString).collect(Collectors.joining(", ")) + "]";
    }

    @JacksonXmlRootElement(localName="transcript")
    public static class Fragment {
        @JacksonXmlText
        @JsonProperty(value="text")
        private String text;
        @JacksonXmlProperty(isAttribute=true)
        @JsonProperty(value="start")
        private double start;
        @JacksonXmlProperty(isAttribute=true)
        @JsonProperty(value="dur")
        private double dur;

        public Fragment(String text, double start, double dur) {
            this.text = text;
            this.start = start;
            this.dur = dur;
        }

        Fragment() {
        }

        public String getText() {
            return this.text;
        }

        public double getStart() {
            return this.start;
        }

        public double getDur() {
            return this.dur;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Fragment fragment = (Fragment)o;
            return Double.compare(this.start, fragment.start) == 0 && Double.compare(this.dur, fragment.dur) == 0 && Objects.equals(this.text, fragment.text);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.start, this.dur);
        }

        public String toString() {
            return "{text='" + this.text + "', start=" + this.start + ", dur=" + this.dur + "}";
        }
    }
}

