/*
 * Decompiled with CFR 0.152.
 */
package io.github.thoroldvix.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import io.github.thoroldvix.api.TranscriptContent;
import io.github.thoroldvix.api.TranscriptRetrievalException;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;

final class TranscriptContentExtractor {
    private static final XmlMapper XML_MAPPER = new XmlMapper();

    private TranscriptContentExtractor() {
    }

    private static List<TranscriptContent.Fragment> formatFragments(List<TranscriptContent.Fragment> fragments) {
        return fragments.stream().map(TranscriptContentExtractor::removeHtmlTags).map(TranscriptContentExtractor::unescapeXmlTags).collect(Collectors.toList());
    }

    static TranscriptContent extract(String videoId, String xml) throws TranscriptRetrievalException {
        List<TranscriptContent.Fragment> fragments = TranscriptContentExtractor.parseFragments(videoId, xml).stream().filter(TranscriptContentExtractor::isValidTranscriptFragment).collect(Collectors.toList());
        List<TranscriptContent.Fragment> content = TranscriptContentExtractor.formatFragments(fragments);
        return new TranscriptContent(content);
    }

    private static TranscriptContent.Fragment unescapeXmlTags(TranscriptContent.Fragment fragment) {
        String formattedValue = StringEscapeUtils.unescapeXml((String)fragment.getText());
        return new TranscriptContent.Fragment(formattedValue, fragment.getStart(), fragment.getDur());
    }

    private static TranscriptContent.Fragment removeHtmlTags(TranscriptContent.Fragment fragment) {
        Pattern pattern = Pattern.compile("<[^>]*>", 2);
        String text = pattern.matcher(fragment.getText()).replaceAll("");
        return new TranscriptContent.Fragment(text, fragment.getStart(), fragment.getDur());
    }

    private static boolean isValidTranscriptFragment(TranscriptContent.Fragment fragment) {
        String text = fragment.getText();
        return text != null && !text.isBlank();
    }

    private static List<TranscriptContent.Fragment> parseFragments(String videoId, String xml) throws TranscriptRetrievalException {
        try {
            return (List)XML_MAPPER.readValue(xml, (TypeReference)new TypeReference<List<TranscriptContent.Fragment>>(){});
        }
        catch (JsonProcessingException e) {
            throw new TranscriptRetrievalException(videoId, "Failed to parse transcript content XML.", e);
        }
    }
}

