/*
 * Decompiled with CFR 0.152.
 */
package io.github.thoroldvix.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.thoroldvix.api.BulkTranscriptRequest;
import io.github.thoroldvix.api.TranscriptContent;
import io.github.thoroldvix.api.TranscriptList;
import io.github.thoroldvix.api.TranscriptListExtractor;
import io.github.thoroldvix.api.TranscriptRetrievalException;
import io.github.thoroldvix.api.YoutubeApi;
import io.github.thoroldvix.api.YoutubeClient;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

public class YoutubeTranscriptApi {
    private final YoutubeApi youtubeApi;
    private final TranscriptListExtractor transcriptListExtractor;
    private final ExecutorService executorService;

    YoutubeTranscriptApi(YoutubeClient client) {
        ObjectMapper objectMapper = new ObjectMapper();
        this.executorService = Executors.newFixedThreadPool(10);
        this.youtubeApi = new YoutubeApi(client, objectMapper);
        this.transcriptListExtractor = new TranscriptListExtractor(this.youtubeApi, objectMapper);
    }

    public TranscriptContent getTranscript(String videoId, String ... languageCodes) throws TranscriptRetrievalException {
        return this.listTranscripts(videoId).findTranscript(languageCodes).fetch();
    }

    public TranscriptList listTranscripts(String videoId) throws TranscriptRetrievalException {
        if (!videoId.matches("[a-zA-Z0-9_-]{11}")) {
            throw new IllegalArgumentException("Invalid video ID: " + videoId);
        }
        String innertubeData = this.youtubeApi.fetchInnertubeData(videoId);
        return this.transcriptListExtractor.extract(videoId, innertubeData);
    }

    public Map<String, TranscriptList> listTranscriptsForPlaylist(String playlistId, BulkTranscriptRequest request) throws TranscriptRetrievalException {
        ConcurrentHashMap<String, TranscriptList> transcriptLists = new ConcurrentHashMap<String, TranscriptList>();
        List<String> videoIds = this.youtubeApi.fetchVideoIdsForPlaylist(playlistId, request.getApiKey());
        List<CompletableFuture<Void>> futures = videoIds.stream().map(videoId -> CompletableFuture.supplyAsync(() -> this.transcriptListSupplier(request, (String)videoId), this.executorService).thenAccept(transcriptList -> {
            if (!transcriptList.isEmpty()) {
                transcriptLists.put(transcriptList.getVideoId(), (TranscriptList)transcriptList);
            }
        })).collect(Collectors.toList());
        YoutubeTranscriptApi.joinFutures(futures, playlistId);
        return transcriptLists;
    }

    private TranscriptList transcriptListSupplier(BulkTranscriptRequest request, String videoId) {
        try {
            return this.listTranscripts(videoId);
        }
        catch (Exception e) {
            if (request.isStopOnError()) {
                throw new CompletionException(e);
            }
            return TranscriptList.empty();
        }
    }

    private static void joinFutures(List<CompletableFuture<Void>> futures, String playlistId) throws TranscriptRetrievalException {
        try {
            CompletableFuture<Void> allOf = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            allOf.join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof TranscriptRetrievalException) {
                throw (TranscriptRetrievalException)e.getCause();
            }
            throw new TranscriptRetrievalException("Failed to retrieve transcripts for playlist: " + playlistId, e);
        }
    }

    public Map<String, TranscriptContent> getTranscriptsForPlaylist(String playlistId, BulkTranscriptRequest request, String ... languageCodes) throws TranscriptRetrievalException {
        Map<String, TranscriptList> transcriptLists = this.listTranscriptsForPlaylist(playlistId, request);
        ConcurrentHashMap<String, TranscriptContent> transcripts = new ConcurrentHashMap<String, TranscriptContent>();
        List<CompletableFuture<Void>> futures = transcriptLists.values().stream().map(transcriptList -> CompletableFuture.supplyAsync(() -> YoutubeTranscriptApi.transcriptContentSupplier(request, languageCodes, transcriptList), this.executorService).thenAccept(transcriptContent -> {
            if (!transcriptContent.isEmpty()) {
                transcripts.put(transcriptList.getVideoId(), (TranscriptContent)transcriptContent);
            }
        })).collect(Collectors.toList());
        YoutubeTranscriptApi.joinFutures(futures, playlistId);
        return transcripts;
    }

    private static TranscriptContent transcriptContentSupplier(BulkTranscriptRequest request, String[] languageCodes, TranscriptList transcriptList) {
        try {
            return transcriptList.findTranscript(languageCodes).fetch();
        }
        catch (Exception e) {
            if (request.isStopOnError()) {
                throw new CompletionException(e);
            }
            return TranscriptContent.empty();
        }
    }

    public Map<String, TranscriptList> listTranscriptsForChannel(String channelName, BulkTranscriptRequest request) throws TranscriptRetrievalException {
        String channelPlaylistId = this.youtubeApi.fetchChannelPlaylistId(channelName, request.getApiKey());
        return this.listTranscriptsForPlaylist(channelPlaylistId, request);
    }

    public Map<String, TranscriptContent> getTranscriptsForChannel(String channelName, BulkTranscriptRequest request, String ... languageCodes) throws TranscriptRetrievalException {
        String channelPlaylistId = this.youtubeApi.fetchChannelPlaylistId(channelName, request.getApiKey());
        return this.getTranscriptsForPlaylist(channelPlaylistId, request, languageCodes);
    }
}

