/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.extensions.profiler.test;

import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.log.api.ConsoleLoggerDecorator;
import org.apache.maven.plugins.surefire.report.ReportTestCase;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;
import org.apache.maven.plugins.surefire.report.SurefireReportParser;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class LifecycleEventSpy
extends AbstractEventSpy {
    private static final String VERSION = "0.1.2";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private boolean enabled = true;
    private String surefireReportsDirectory = "surefire-reports";
    private String failsafeReportsDirectory = "failsafe-reports";
    private int maxSurefireResults = 0;
    private int maxFailsafeResults = 0;
    private int maxSlowestSurefireResults = Integer.MAX_VALUE;
    private int maxSlowestFailsafeResults = Integer.MAX_VALUE;
    private int maxFailures = 0;
    public static final Comparator<ReportTestSuite> ELAPSED_TIME_LARGEST_FIRST = Comparator.comparing(ReportTestSuite::getTimeElapsed).reversed();

    public LifecycleEventSpy() {
        this.logger.debug("LifeCycleProfiler ctor called.");
    }

    public void init(EventSpy.Context context) throws Exception {
        this.enabled = Boolean.parseBoolean(this.getProperty(context, "test-profiler.enabled", "true"));
        if (!this.enabled) {
            return;
        }
        this.logger.info("Maven Test Profiler 0.1.2 started.");
        this.surefireReportsDirectory = this.getProperty(context, "test-profiler.surefireReportsDirectory", "surefire-reports");
        this.failsafeReportsDirectory = this.getProperty(context, "test-profiler.failsafeReportsDirectory", "failsafe-reports");
        this.maxSurefireResults = this.getIntProperty(context, "test-profiler.maxSurefireResults", 0);
        this.maxFailsafeResults = this.getIntProperty(context, "test-profiler.maxFailsafeResults", 0);
        this.maxSlowestSurefireResults = this.getIntProperty(context, "test-profiler.maxSlowestSurefireResults", Integer.MAX_VALUE);
        this.maxSlowestFailsafeResults = this.getIntProperty(context, "test-profiler.maxSlowestFailsafeResults", Integer.MAX_VALUE);
        this.maxFailures = this.getIntProperty(context, "test-profiler.maxFailuries", 0);
    }

    private int getIntProperty(EventSpy.Context context, String key, int defaultValue) {
        return Integer.parseInt(this.getProperty(context, key, defaultValue + ""));
    }

    private String getProperty(EventSpy.Context context, String key, String defaultValue) {
        Map systemProperties = (Map)context.getData().get("systemProperties");
        String value = System.getProperty(key, defaultValue);
        if (systemProperties != null) {
            return systemProperties.getOrDefault(key, value);
        }
        return value;
    }

    public void onEvent(Object event) throws Exception {
        if (!this.enabled) {
            return;
        }
        try {
            if (event instanceof MavenExecutionResult) {
                this.executionResultEventHandler((MavenExecutionResult)event);
            }
        }
        catch (Exception e) {
            this.logger.warn("Cannot profile test results", (Throwable)e);
        }
    }

    public void close() {
        this.logger.debug("Profiler: done.");
    }

    private List<ReportTestSuite> getAllTestReports(File reportDirectory) throws MavenReportException {
        List<File> reportsDirectories = Collections.singletonList(reportDirectory);
        ConsoleLoggerDecorator consoleLogger = new ConsoleLoggerDecorator((Object)this.logger);
        SurefireReportParser report = new SurefireReportParser(reportsDirectories, Locale.ENGLISH, (ConsoleLogger)consoleLogger);
        return report.parseXMLReportFiles();
    }

    private void executionResultEventHandler(MavenExecutionResult event) throws MavenReportException {
        ArrayList<ReportTestSuite> surefireTestsResults = new ArrayList<ReportTestSuite>();
        ArrayList<ReportTestSuite> failsafeTestsResults = new ArrayList<ReportTestSuite>();
        for (MavenProject project : event.getTopologicallySortedProjects()) {
            this.collectTestsResults(surefireTestsResults, project, this.surefireReportsDirectory);
            this.collectTestsResults(failsafeTestsResults, project, this.failsafeReportsDirectory);
        }
        this.printTestSummary(surefireTestsResults, "SUREFIRE TEST SUMMARY", this.maxSurefireResults, this.maxSlowestSurefireResults);
        this.printTestSummary(failsafeTestsResults, "FAILSAFE TEST SUMMARY", this.maxFailsafeResults, this.maxSlowestFailsafeResults);
    }

    private void collectTestsResults(List<ReportTestSuite> testsResults, MavenProject project, String dir) throws MavenReportException {
        File reportDirectory = new File(project.getBuild().getDirectory(), dir);
        if (!reportDirectory.exists()) {
            return;
        }
        testsResults.addAll(this.getAllTestReports(reportDirectory));
    }

    private void printTestSummary(List<ReportTestSuite> testsResults, String label, int max, int maxSlowest) {
        if (testsResults.isEmpty()) {
            return;
        }
        this.logger.info("");
        this.logger.info("");
        this.logger.info(label);
        this.printResult(testsResults, max);
        this.printSummary(testsResults);
        this.sortLongestTestTimeFirst(testsResults);
        if (maxSlowest > 0) {
            this.logger.info("------------------------------------------------------------------------");
            this.logger.info("SLOWEST {}", (Object)label);
            this.printResult(testsResults, maxSlowest);
        }
        if (this.maxFailures > 0) {
            this.showTestFailures(testsResults);
        }
        this.logger.info("------------------------------------------------------------------------");
    }

    private void showTestFailures(List<ReportTestSuite> testsResults) {
        ArrayList testCases = new ArrayList();
        for (ReportTestSuite reportTestSuite : testsResults) {
            if (testCases.size() >= this.maxFailures) break;
            testCases.addAll(reportTestSuite.getTestCases());
        }
        for (ReportTestCase reportTestCase : testCases) {
            if (!reportTestCase.hasFailure()) continue;
            String message = reportTestCase.getFailureMessage();
            String type = reportTestCase.getFailureType();
            this.logger.warn("Failed Test case: {}({})", (Object)reportTestCase.getName(), (Object)reportTestCase.getFullClassName());
            this.logger.warn("       {} {}", (Object)message, (Object)type);
        }
    }

    private void sortLongestTestTimeFirst(List<ReportTestSuite> unitTestsResults) {
        Collections.sort(unitTestsResults, ELAPSED_TIME_LARGEST_FIRST);
    }

    private void printSummary(List<ReportTestSuite> unitTestsResults) {
        float averageTimePerTest;
        List reportsDirectories = Collections.emptyList();
        SurefireReportParser report = new SurefireReportParser(reportsDirectories, Locale.ENGLISH, (ConsoleLogger)new ConsoleLoggerDecorator((Object)this.logger));
        Map summary = report.getSummary(unitTestsResults);
        this.logger.info("--------- -------- ------ ------- ----------");
        String totalTests = (String)summary.get("totalTests");
        String totalErrors = (String)summary.get("totalErrors");
        String totalSkipped = (String)summary.get("totalSkipped");
        String totalFailures = (String)summary.get("totalFailures");
        String totalElapsedTime = (String)summary.get("totalElapsedTime");
        float totalElapsedTimeNumber = this.parseNumber(report, totalElapsedTime);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%9s", totalTests));
        sb.append(" ");
        sb.append(String.format("%8s", totalFailures));
        sb.append(" ");
        sb.append(String.format("%6s", totalErrors));
        sb.append(" ");
        sb.append(String.format("%7s", totalSkipped));
        sb.append(" ");
        sb.append(String.format("%10.3f", Float.valueOf(totalElapsedTimeNumber)));
        this.logger.info("{}", (Object)sb);
        this.logger.info("========= ======== ====== ======= ==========");
        this.logger.info("");
        this.logger.info("Rate: {} %", summary.get("totalPercentage"));
        float totalTestsNumber = Float.parseFloat(totalTests);
        float f = averageTimePerTest = totalTestsNumber == 0.0f ? 0.0f : totalElapsedTimeNumber / totalTestsNumber;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Average Time per Test: {}", (Object)String.format("%6.6f", Float.valueOf(averageTimePerTest)));
        }
    }

    private float parseNumber(SurefireReportParser report, String totalElapsedTime) {
        try {
            return report.getNumberFormat().parse(totalElapsedTime).floatValue();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse totalElapsedTime: " + totalElapsedTime, e);
        }
    }

    private void printResult(List<ReportTestSuite> unitTestsResults, int limit) {
        this.logger.info("Tests run Failures Errors Skipped Elapsed    ClassName");
        this.logger.info("                                  Time (sec)");
        int count = 0;
        for (ReportTestSuite testSuite : unitTestsResults) {
            if (++count >= limit) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%9d", testSuite.getNumberOfTests()));
            sb.append(" ");
            sb.append(String.format("%8d", testSuite.getNumberOfFailures()));
            sb.append(" ");
            sb.append(String.format("%6d", testSuite.getNumberOfErrors()));
            sb.append(" ");
            sb.append(String.format("%7d", testSuite.getNumberOfSkipped()));
            sb.append(" ");
            sb.append(String.format("%10.3f", Float.valueOf(testSuite.getTimeElapsed())));
            sb.append(" ");
            sb.append(testSuite.getFullClassName());
            this.logger.info("{}", (Object)sb);
        }
    }

    static class Defaults {
        static final boolean ENABLED = true;
        static final String SUREFIRE_REPORTS_DIRECTORY = "surefire-reports";
        static final String FAILSAFE_REPORTS_DIRECTORY = "failsafe-reports";
        static final int MAX_SUREFIRE_RESULTS = 0;
        static final int FAILSAFE_RESULTS = 0;
        static final int MAX_SLOWEST_SUREFIRE_RESULTS = Integer.MAX_VALUE;
        static final int MAX_SLOWEST_FAILSAFE_RESULTS = Integer.MAX_VALUE;
        static final int MAX_FAILURES = 0;

        private Defaults() {
            throw new AssertionError();
        }
    }
}

