/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console;

import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.app.VelocityEngine;
import org.springframework.context.ApplicationContext;

public abstract class BaseAction {
    @Resource
    protected VelocityEngine ve;
    @Resource
    protected ApplicationContext applicationContext;
    public static final String PREVIEW_KEY = "p";

    protected Throwable buildRootException(Throwable throwable) {
        if (throwable.getCause() == null) {
            return throwable;
        }
        return this.buildRootException(throwable.getCause());
    }

    protected String decode(String value) {
        if (value == null) {
            return value;
        }
        try {
            value = URLDecoder.decode(value, "utf-8");
            value = URLDecoder.decode(value, "utf-8");
            return value;
        }
        catch (Exception ex) {
            return value;
        }
    }

    protected String decodeContent(String content) {
        if (content == null) {
            return null;
        }
        try {
            content = URLDecoder.decode(content, "utf-8");
            return content;
        }
        catch (Exception ex) {
            return content;
        }
    }

    protected Map<String, Object> buildParameters(HttpServletRequest req) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Enumeration enumeration = req.getParameterNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (obj == null) continue;
            String name = obj.toString();
            String value = req.getParameter(name);
            if (name == null || value == null || name.startsWith("_")) continue;
            parameters.put(name, this.decode(value));
        }
        return parameters;
    }

    protected String buildDownloadFileName(String reportFileName, String fileName, String extName) {
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            if (!((String)(fileName = this.decode((String)fileName))).toLowerCase().endsWith(extName)) {
                fileName = (String)fileName + extName;
            }
            return fileName;
        }
        int pos = reportFileName.indexOf(":");
        if (pos > 0) {
            reportFileName = reportFileName.substring(pos + 1, reportFileName.length());
        }
        if ((pos = reportFileName.toLowerCase().indexOf(".ureport.xml")) > 0) {
            reportFileName = reportFileName.substring(0, pos);
        }
        return "ureport-" + reportFileName + extName;
    }
}

