/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.designer;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.console.BaseAction;
import com.bstek.ureport.console.designer.DataResult;
import com.bstek.ureport.console.exception.ReportDesignException;
import com.bstek.ureport.definition.dataset.Field;
import com.bstek.ureport.definition.datasource.BuildinDatasource;
import com.bstek.ureport.definition.datasource.DataType;
import com.bstek.ureport.expression.ExpressionUtils;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.utils.ProcedureUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Resource;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ureport/datasource"})
public class DatasourceAction
extends BaseAction {
    @Resource
    ApplicationContext applicationContext;

    @RequestMapping(value={"loadBuildinDatasources"})
    public List<String> loadBuildinDatasources() {
        ArrayList<String> datasources = new ArrayList<String>();
        Collection values = this.applicationContext.getBeansOfType(BuildinDatasource.class).values();
        for (BuildinDatasource datasource : values) {
            datasources.add(datasource.name());
        }
        return datasources;
    }

    @RequestMapping(value={"loadMethods"})
    public List<String> loadMethods(String beanId) {
        Object obj = this.applicationContext.getBean(beanId);
        Class<?> clazz = obj.getClass();
        Method[] methods = clazz.getMethods();
        ArrayList<String> result = new ArrayList<String>();
        for (Method method : methods) {
            Class<?>[] types = method.getParameterTypes();
            if (types.length != 3) continue;
            Class<?> typeClass1 = types[0];
            Class<?> typeClass2 = types[1];
            Class<?> typeClass3 = types[2];
            if (!String.class.isAssignableFrom(typeClass1) || !String.class.isAssignableFrom(typeClass2) || !Map.class.isAssignableFrom(typeClass3)) continue;
            result.add(method.getName());
        }
        return result;
    }

    @RequestMapping(value={"loadMethodsAndClazz"})
    public List<Map<String, String>> loadMethodsAndClazz(String beanId) {
        Object obj = this.applicationContext.getBean(beanId);
        Class<?> clazz = obj.getClass();
        Method[] methods = clazz.getMethods();
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (Method method : methods) {
            Class<?>[] types = method.getParameterTypes();
            if (types.length != 3) continue;
            Class<?> typeClass1 = types[0];
            Class<?> typeClass2 = types[1];
            Class<?> typeClass3 = types[2];
            if (!String.class.isAssignableFrom(typeClass1) || !String.class.isAssignableFrom(typeClass2) || !Map.class.isAssignableFrom(typeClass3)) continue;
            Type genericReturnType = method.getGenericReturnType();
            String typeName = genericReturnType.getTypeName();
            typeName = typeName.replace("java.util.List<", "").replace(">", "");
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("method", method.getName());
            item.put("clazz", typeName);
            result.add(item);
        }
        return result;
    }

    @RequestMapping(value={"buildClass"})
    public List<Field> buildClass(String clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            Class<?> targetClass = Class.forName(clazz);
            for (PropertyDescriptor pd : propertyDescriptors = PropertyUtils.getPropertyDescriptors(targetClass)) {
                String name = pd.getName();
                if ("class".equals(name)) continue;
                result.add(new Field(name));
            }
            result.sort((o1, o2) -> {
                String n1 = o1.getName();
                String n2 = o2.getName();
                if (n1.length() == n2.length()) {
                    return n1.compareTo(n2);
                }
                return n1.length() - n2.length();
            });
            return result;
        }
        catch (Exception ex) {
            throw new ReportDesignException(ex);
        }
    }

    @RequestMapping(value={"buildDatabaseTables"})
    public List<Map<String, String>> buildDatabaseTables(String type, String username, String password, String driver, String url, String name) throws ServletException {
        ArrayList<Map<String, String>> arrayList;
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = this.buildConnection(type, username, password, driver, url, name);
            DatabaseMetaData metaData = conn.getMetaData();
            url = metaData.getURL();
            String schema = null;
            if (url.toLowerCase().contains("oracle")) {
                schema = metaData.getUserName();
            }
            ArrayList<Map<String, String>> tables = new ArrayList<Map<String, String>>();
            rs = metaData.getTables(null, schema, "%", new String[]{"TABLE", "VIEW"});
            while (rs.next()) {
                HashMap<String, String> table = new HashMap<String, String>();
                table.put("name", rs.getString("TABLE_NAME"));
                table.put("type", rs.getString("TABLE_TYPE"));
                tables.add(table);
            }
            arrayList = tables;
        }
        catch (Exception ex) {
            try {
                throw new ServletException((Throwable)ex);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeConnection(conn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet((ResultSet)rs);
        JdbcUtils.closeConnection((Connection)conn);
        return arrayList;
    }

    @RequestMapping(value={"buildFields"})
    public List<Field> buildFields(String sql, String parameters, String type, String username, String password, String driver, String url, String name) {
        ArrayList<Field> arrayList;
        Connection conn = null;
        final ArrayList<Field> fields = new ArrayList<Field>();
        try {
            conn = this.buildConnection(type, username, password, driver, url, name);
            Map<String, Object> map = this.buildParameters(parameters);
            sql = this.parseSql(sql, map);
            if (ProcedureUtils.isProcedure((String)sql)) {
                List fieldsList = ProcedureUtils.procedureColumnsQuery((String)sql, map, (Connection)conn);
                fields.addAll(fieldsList);
            } else {
                SingleConnectionDataSource dataSource = new SingleConnectionDataSource(conn, false);
                NamedParameterJdbcTemplate jdbc = new NamedParameterJdbcTemplate((DataSource)dataSource);
                PreparedStatementCreator statementCreator = this.getPreparedStatementCreator(sql, (SqlParameterSource)new MapSqlParameterSource(map));
                jdbc.getJdbcOperations().execute(statementCreator, (PreparedStatementCallback)new PreparedStatementCallback<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                        ResultSet rs = null;
                        try {
                            rs = ps.executeQuery();
                            ResultSetMetaData metadata = rs.getMetaData();
                            int columnCount = metadata.getColumnCount();
                            for (int i = 0; i < columnCount; ++i) {
                                String columnName = metadata.getColumnLabel(i + 1);
                                fields.add(new Field(columnName));
                            }
                            Object var5_6 = null;
                            return var5_6;
                        }
                        finally {
                            JdbcUtils.closeResultSet((ResultSet)rs);
                        }
                    }
                });
            }
            arrayList = fields;
        }
        catch (Exception ex) {
            try {
                throw new ReportDesignException(ex);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeConnection(conn);
                throw throwable;
            }
        }
        JdbcUtils.closeConnection((Connection)conn);
        return arrayList;
    }

    protected PreparedStatementCreator getPreparedStatementCreator(String sql, SqlParameterSource paramSource) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement((String)sql);
        String sqlToUse = NamedParameterUtils.substituteNamedParameters((ParsedSql)parsedSql, (SqlParameterSource)paramSource);
        Object[] params = NamedParameterUtils.buildValueArray((ParsedSql)parsedSql, (SqlParameterSource)paramSource, null);
        List declaredParameters = NamedParameterUtils.buildSqlParameterList((ParsedSql)parsedSql, (SqlParameterSource)paramSource);
        PreparedStatementCreatorFactory pscf = new PreparedStatementCreatorFactory(sqlToUse, declaredParameters);
        return pscf.newPreparedStatementCreator(params);
    }

    @RequestMapping(value={"previewData"})
    public DataResult previewData(String sql, String parameters, HttpServletRequest req, String type, String username, String password, String driver, String url, String name) throws ServletException, IOException {
        String oldSql = req.getParameter("sql");
        System.out.println(oldSql);
        String newSql = this.decode(sql);
        Map<String, Object> map = this.buildParameters(parameters);
        sql = this.parseSql(sql, map);
        Connection conn = null;
        try {
            int size;
            conn = this.buildConnection(type, username, password, driver, url, name);
            List list = null;
            if (ProcedureUtils.isProcedure((String)sql)) {
                list = ProcedureUtils.procedureQuery((String)sql, map, (Connection)conn);
            } else {
                SingleConnectionDataSource dataSource = new SingleConnectionDataSource(conn, false);
                NamedParameterJdbcTemplate jdbc = new NamedParameterJdbcTemplate((DataSource)dataSource);
                list = jdbc.queryForList(sql, map);
            }
            int currentTotal = size = list.size();
            if (currentTotal > 500) {
                currentTotal = 500;
            }
            ArrayList<Map<String, Object>> ls = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < currentTotal; ++i) {
                ls.add((Map)list.get(i));
            }
            DataResult result = new DataResult();
            ArrayList<String> fields = new ArrayList<String>();
            if (size > 0) {
                Map item = (Map)list.get(0);
                for (String f : item.keySet()) {
                    fields.add(f);
                }
            }
            result.setFields(fields);
            result.setCurrentTotal(currentTotal);
            result.setData(ls);
            result.setTotal(size);
            DataResult dataResult = result;
            return dataResult;
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String parseSql(String sql, Map<String, Object> parameters) {
        sql = sql.trim();
        Context context = new Context(this.applicationContext, parameters);
        if (sql.startsWith("${") && sql.endsWith("}")) {
            sql = sql.substring(2, sql.length() - 1);
            Expression expr = ExpressionUtils.parseExpression((String)sql);
            sql = this.executeSqlExpr(expr, context);
            return sql;
        }
        String sqlForUse = sql;
        Pattern pattern = Pattern.compile("\\$\\{.*?\\}");
        Matcher matcher = pattern.matcher(sqlForUse);
        while (matcher.find()) {
            String substr = matcher.group();
            String sqlExpr = substr.substring(2, substr.length() - 1);
            Expression expr = ExpressionUtils.parseExpression((String)sqlExpr);
            String result = this.executeSqlExpr(expr, context);
            sqlForUse = sqlForUse.replace(substr, result);
        }
        Utils.logToConsole((String)("DESIGN SQL:" + sqlForUse));
        return sqlForUse;
    }

    private String executeSqlExpr(Expression sqlExpr, Context context) {
        ObjectExpressionData data;
        Object obj;
        String sqlForUse = null;
        ExpressionData exprData = sqlExpr.execute(null, null, context);
        if (exprData instanceof ObjectExpressionData && (obj = (data = (ObjectExpressionData)exprData).getData()) != null) {
            String s = obj.toString();
            sqlForUse = s = s.replaceAll("\\\\", "");
        }
        return sqlForUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"testConnection"})
    public Map<String, Object> testConnection(String username, String password, String driver, String url) throws ServletException, IOException {
        Connection conn = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Class.forName(driver);
            conn = DriverManager.getConnection(url, username, password);
            map.put("result", true);
        }
        catch (Exception ex) {
            map.put("error", ex.toString());
            map.put("result", false);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return map;
    }

    private Map<String, Object> buildParameters(String parameters) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)parameters)) {
            return map;
        }
        ObjectMapper mapper = new ObjectMapper();
        List list = (List)mapper.readValue(parameters, ArrayList.class);
        for (Map param : list) {
            String name = param.get("name").toString();
            DataType type = DataType.valueOf((String)param.get("type").toString());
            String defaultValue = (String)param.get("defaultValue");
            if (defaultValue == null || defaultValue.equals("")) {
                switch (type) {
                    case Boolean: {
                        map.put(name, false);
                    }
                    case Date: {
                        map.put(name, new Date());
                    }
                    case Float: {
                        map.put(name, new Float(0.0f));
                    }
                    case Integer: {
                        map.put(name, 0);
                    }
                    case String: {
                        if (defaultValue != null && defaultValue.equals("")) {
                            map.put(name, "");
                            break;
                        }
                        map.put(name, "null");
                        break;
                    }
                    case List: {
                        map.put(name, new ArrayList());
                    }
                }
                continue;
            }
            map.put(name, type.parse((Object)defaultValue));
        }
        return map;
    }

    private Connection buildConnection(String type, String username, String password, String driver, String url, String name) throws Exception {
        if (type.equals("jdbc")) {
            Class.forName(driver);
            Connection conn = DriverManager.getConnection(url, username, password);
            return conn;
        }
        Connection conn = Utils.getBuildinConnection((String)name);
        if (conn == null) {
            throw new ReportDesignException("Buildin datasource [" + name + "] not exist.");
        }
        return conn;
    }
}

