/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.designer;

import com.bstek.ureport.cache.CacheUtils;
import com.bstek.ureport.console.BaseAction;
import com.bstek.ureport.console.cache.TempObjectCache;
import com.bstek.ureport.console.designer.ReportDefinitionWrapper;
import com.bstek.ureport.console.designer.ReportUtils;
import com.bstek.ureport.console.exception.ReportDesignException;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.dsl.ReportParserLexer;
import com.bstek.ureport.dsl.ReportParserParser;
import com.bstek.ureport.export.ReportRender;
import com.bstek.ureport.expression.ErrorInfo;
import com.bstek.ureport.expression.ScriptErrorListener;
import com.bstek.ureport.parser.ReportParser;
import com.bstek.ureport.provider.report.ReportProvider;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ureport/designer"})
public class DesignerAction
extends BaseAction {
    @Resource
    private ReportRender reportRender;
    @Resource
    private ReportParser reportParser;
    private List<ReportProvider> reportProviders = new ArrayList<ReportProvider>();

    @GetMapping
    public void index(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        VelocityContext context = new VelocityContext();
        context.put("contextPath", (Object)req.getContextPath());
        resp.setContentType("text/html");
        resp.setCharacterEncoding("utf-8");
        Template template = this.ve.getTemplate("ureport-html/designer.html", "utf-8");
        PrintWriter writer = resp.getWriter();
        template.merge((Context)context, (Writer)writer);
        writer.close();
    }

    @RequestMapping(value={"scriptValidation"})
    public List<ErrorInfo> scriptValidation(String content) {
        ANTLRInputStream antlrInputStream = new ANTLRInputStream(content);
        ReportParserLexer lexer = new ReportParserLexer((CharStream)antlrInputStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        ReportParserParser parser = new ReportParserParser((TokenStream)tokenStream);
        ScriptErrorListener errorListener = new ScriptErrorListener();
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        parser.expression();
        List infos = errorListener.getInfos();
        return infos;
    }

    @RequestMapping(value={"conditionScriptValidation"})
    public List<ErrorInfo> conditionScriptValidation(String content) {
        ANTLRInputStream antlrInputStream = new ANTLRInputStream(content);
        ReportParserLexer lexer = new ReportParserLexer((CharStream)antlrInputStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        ReportParserParser parser = new ReportParserParser((TokenStream)tokenStream);
        ScriptErrorListener errorListener = new ScriptErrorListener();
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        parser.expr();
        List infos = errorListener.getInfos();
        return infos;
    }

    @RequestMapping(value={"parseDatasetName"})
    public Map<String, String> parseDatasetName(String expr) {
        ANTLRInputStream antlrInputStream = new ANTLRInputStream(expr);
        ReportParserLexer lexer = new ReportParserLexer((CharStream)antlrInputStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        ReportParserParser parser = new ReportParserParser((TokenStream)tokenStream);
        parser.removeErrorListeners();
        ReportParserParser.DatasetContext ctx = parser.dataset();
        String datasetName = ctx.Identifier().getText();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("datasetName", datasetName);
        return result;
    }

    @RequestMapping(value={"savePreviewData"})
    public void savePreviewData(String content) {
        content = this.decodeContent(content);
        ReportDefinition reportDef = this.reportParser.parse(content, "p");
        this.reportRender.rebuildReportDefinition(reportDef);
        TempObjectCache.putObject("p", reportDef);
        System.out.println("\u7f13\u5b58");
    }

    @RequestMapping(value={"loadReport"})
    public ReportDefinitionWrapper loadReport(String file) {
        ReportDefinition reportDef;
        if (file == null) {
            throw new ReportDesignException("Report file can not be null.");
        }
        Object obj = TempObjectCache.getObject(file = ReportUtils.decodeFileName(file));
        if (obj != null && obj instanceof ReportDefinition) {
            reportDef = (ReportDefinition)obj;
            TempObjectCache.removeObject(file);
        } else {
            reportDef = this.reportRender.parseReport(file);
        }
        return new ReportDefinitionWrapper(reportDef);
    }

    @RequestMapping(value={"deleteReportFile"})
    public void deleteReportFile(String file) {
        if (file == null) {
            throw new ReportDesignException("Report file can not be null.");
        }
        ReportProvider targetReportProvider = null;
        for (ReportProvider provider : this.reportProviders) {
            if (!file.startsWith(provider.getPrefix())) continue;
            targetReportProvider = provider;
            break;
        }
        if (targetReportProvider == null) {
            throw new ReportDesignException("File [" + file + "] not found available report provider.");
        }
        targetReportProvider.deleteReport(file);
    }

    @RequestMapping(value={"saveReportFile"})
    public void saveReportFile(@RequestParam String file, @RequestParam String content) {
        content = this.decodeContent(content);
        file = this.decode(file);
        ReportProvider targetReportProvider = null;
        for (ReportProvider provider : this.reportProviders) {
            if (!file.startsWith(provider.getPrefix())) continue;
            targetReportProvider = provider;
            break;
        }
        if (targetReportProvider == null) {
            throw new ReportDesignException("File [" + file + "] not found available report provider.");
        }
        targetReportProvider.saveReport(file, content);
        ReportDefinition reportDef = this.reportParser.parse(content, file);
        this.reportRender.rebuildReportDefinition(reportDef);
        CacheUtils.cacheReportDefinition((String)file, (ReportDefinition)reportDef);
    }

    @RequestMapping(value={"loadReportProviders"})
    public List<ReportProvider> loadReportProviders() {
        return this.reportProviders;
    }

    @PostConstruct
    public void init() {
        Collection providers = this.applicationContext.getBeansOfType(ReportProvider.class).values();
        for (ReportProvider provider : providers) {
            if (provider.disabled() || provider.getName() == null) continue;
            this.reportProviders.add(provider);
        }
    }
}

