/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.excel;

import com.bstek.ureport.build.ReportBuilder;
import com.bstek.ureport.console.BaseAction;
import com.bstek.ureport.console.cache.TempObjectCache;
import com.bstek.ureport.console.exception.ReportDesignException;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.exception.ReportException;
import com.bstek.ureport.export.ExportConfigure;
import com.bstek.ureport.export.ExportConfigureImpl;
import com.bstek.ureport.export.ExportManager;
import com.bstek.ureport.export.excel.high.ExcelProducer;
import com.bstek.ureport.model.Report;
import jakarta.annotation.Resource;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ureport/excel"})
public class ExportExcelAction
extends BaseAction {
    @Resource
    private ReportBuilder reportBuilder;
    @Resource
    private ExportManager exportManager;
    private ExcelProducer excelProducer = new ExcelProducer();

    @RequestMapping
    public void index(@RequestParam(value="_u") String file, @RequestParam(name="_n", required=false) String fileName, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.buildExcel(file, fileName, req, resp, false, false);
    }

    @RequestMapping(value={"paging"})
    public void paging(@RequestParam(value="_u") String file, @RequestParam(name="_n", required=false) String fileName, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.buildExcel(file, fileName, req, resp, true, false);
    }

    @RequestMapping(value={"sheet"})
    public void sheet(@RequestParam(value="_u") String file, @RequestParam(name="_n", required=false) String fileName, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.buildExcel(file, fileName, req, resp, false, true);
    }

    public void buildExcel(String file, String fileName, HttpServletRequest req, HttpServletResponse resp, boolean withPage, boolean withSheet) throws IOException {
        if (StringUtils.isBlank((String)(file = this.decode(file)))) {
            throw new ReportComputeException("Report file can not be null.");
        }
        ServletOutputStream outputStream = resp.getOutputStream();
        try {
            fileName = this.buildDownloadFileName(file, fileName, ".xlsx");
            resp.setContentType("application/octet-stream;charset=ISO8859-1");
            fileName = new String(fileName.getBytes("UTF-8"), "ISO8859-1");
            resp.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
            Map<String, Object> parameters = this.buildParameters(req);
            if (file.equals("p")) {
                ReportDefinition reportDefinition = (ReportDefinition)TempObjectCache.getObject("p");
                if (reportDefinition == null) {
                    throw new ReportDesignException("Report data has expired,can not do export excel.");
                }
                Report report = this.reportBuilder.buildReport(reportDefinition, parameters);
                if (withPage) {
                    this.excelProducer.produceWithPaging(report, (OutputStream)outputStream);
                } else if (withSheet) {
                    this.excelProducer.produceWithSheet(report, (OutputStream)outputStream);
                } else {
                    this.excelProducer.produce(report, (OutputStream)outputStream);
                }
            } else {
                ExportConfigureImpl configure = new ExportConfigureImpl(file, parameters, (OutputStream)outputStream);
                if (withPage) {
                    this.exportManager.exportExcelWithPaging((ExportConfigure)configure);
                } else if (withSheet) {
                    this.exportManager.exportExcelWithPagingSheet((ExportConfigure)configure);
                } else {
                    this.exportManager.exportExcel((ExportConfigure)configure);
                }
            }
        }
        catch (Exception ex) {
            throw new ReportException(ex);
        }
        finally {
            outputStream.flush();
            outputStream.close();
        }
    }
}

