/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.importexcel;

import com.bstek.ureport.console.importexcel.Span;
import com.bstek.ureport.definition.Alignment;
import com.bstek.ureport.definition.Border;
import com.bstek.ureport.definition.CellDefinition;
import com.bstek.ureport.definition.CellStyle;
import com.bstek.ureport.definition.ColumnDefinition;
import com.bstek.ureport.definition.Orientation;
import com.bstek.ureport.definition.PagingMode;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.definition.PaperSize;
import com.bstek.ureport.definition.PaperType;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.definition.RowDefinition;
import com.bstek.ureport.definition.value.ExpressionValue;
import com.bstek.ureport.definition.value.SimpleValue;
import com.bstek.ureport.definition.value.Value;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Component;

@Component
public class ExcelParser {
    public List<ReportDefinition> parseAll(InputStream inputStream) throws Exception {
        XSSFWorkbook book = new XSSFWorkbook(inputStream);
        ArrayList<ReportDefinition> list = new ArrayList<ReportDefinition>();
        for (int i = 0; i < book.getNumberOfSheets(); ++i) {
            XSSFSheet sheet = book.getSheetAt(i);
            ReportDefinition reportDefinition = this.parseSheet(sheet);
            list.add(reportDefinition);
        }
        book.close();
        inputStream.close();
        return list;
    }

    public ReportDefinition parse(InputStream inputStream) throws Exception {
        XSSFWorkbook book = new XSSFWorkbook(inputStream);
        XSSFSheet sheet = book.getSheetAt(0);
        ReportDefinition reportDefinition = this.parseSheet(sheet);
        book.close();
        inputStream.close();
        return reportDefinition;
    }

    private ReportDefinition parseSheet(XSSFSheet sheet) {
        int i;
        ReportDefinition report = new ReportDefinition();
        ArrayList<RowDefinition> rowDefs = new ArrayList<RowDefinition>();
        report.setRows(rowDefs);
        ArrayList<ColumnDefinition> columnDefs = new ArrayList<ColumnDefinition>();
        report.setColumns(columnDefs);
        ArrayList<CellDefinition> cellDefs = new ArrayList<CellDefinition>();
        report.setCells(cellDefs);
        report.setReportFullName(sheet.getSheetName());
        int firstRow = 0;
        int rowCount = sheet.getPhysicalNumberOfRows();
        int maxColumnCount = this.buildMaxColumn(sheet);
        for (i = firstRow; i < rowCount; ++i) {
            RowDefinition rowDef;
            XSSFRow row = sheet.getRow(i);
            if (row == null) {
                rowDef = new RowDefinition();
                rowDef.setHeight(20);
                rowDef.setRowNumber(i + 1);
                rowDefs.add(rowDef);
                this.addBlankCells(cellDefs, i + 1, maxColumnCount);
                continue;
            }
            rowDef = new RowDefinition();
            int height = row.getHeight() / 20;
            rowDef.setHeight(height);
            rowDef.setRowNumber(i + 1);
            rowDefs.add(rowDef);
            for (int j = 0; j < maxColumnCount; ++j) {
                boolean isMergeRegion = this.isMergedRegion(sheet, i, j);
                if (isMergeRegion) continue;
                XSSFCell cell = row.getCell(j);
                if (cell == null) {
                    CellDefinition cellDef = new CellDefinition();
                    cellDef.setValue((Value)new SimpleValue(""));
                    cellDef.setRowNumber(i + 1);
                    cellDef.setColumnNumber(j + 1);
                    cellDef.setLeftParentCellName("root");
                    cellDef.setTopParentCellName("root");
                    cellDefs.add(cellDef);
                    continue;
                }
                Span span = this.getSpan(sheet, i, j);
                Object value = null;
                CellType cellType = cell.getCellType();
                String formula = null;
                switch (cellType) {
                    case STRING: {
                        value = cell.getStringCellValue();
                        if (!ExcelParser.isFormal((String)value)) break;
                        formula = ((String)value).substring(1);
                        break;
                    }
                    case BOOLEAN: {
                        value = cell.getBooleanCellValue();
                        break;
                    }
                    case NUMERIC: {
                        value = cell.getNumericCellValue();
                        break;
                    }
                    case FORMULA: {
                        formula = cell.getCellFormula();
                        break;
                    }
                    default: {
                        value = "";
                    }
                }
                CellDefinition cellDef = new CellDefinition();
                if (formula != null) {
                    ExpressionValue expressionValue = new ExpressionValue(formula);
                    cellDef.setValue((Value)expressionValue);
                } else {
                    SimpleValue simpleValue = new SimpleValue(value != null ? value.toString() : "");
                    cellDef.setValue((Value)simpleValue);
                }
                cellDef.setLeftParentCellName("root");
                cellDef.setTopParentCellName("root");
                cellDef.setRowNumber(i + 1);
                cellDef.setColumnNumber(j + 1);
                cellDef.setRowSpan(span.getRowSpan());
                cellDef.setColSpan(span.getColSpan());
                cellDef.setCellStyle(this.buildCellStyle(cell, sheet.getWorkbook()));
                cellDef.setName(ExcelParser.convertToExcelCoordinate(i, j));
                cellDefs.add(cellDef);
            }
        }
        for (i = 0; i < maxColumnCount; ++i) {
            ColumnDefinition col = new ColumnDefinition();
            int width = sheet.getColumnWidth(i);
            col.setWidth(width / 37);
            col.setColumnNumber(i + 1);
            columnDefs.add(col);
        }
        Paper paper = new Paper();
        paper.setPaperType(PaperType.A4);
        paper.setOrientation(Orientation.portrait);
        paper.setPagingMode(PagingMode.fitpage);
        PaperSize pageSize = PaperType.A4.getPaperSize();
        paper.setWidth(pageSize.getWidth());
        paper.setHeight(paper.getHeight());
        report.setPaper(paper);
        return report;
    }

    private CellStyle buildCellStyle(XSSFCell cell, XSSFWorkbook book) {
        Border border;
        XSSFColor bgcolor;
        XSSFColor color;
        CellStyle style = new CellStyle();
        XSSFCellStyle cellStyle = cell.getCellStyle();
        HorizontalAlignment align = cellStyle.getAlignment();
        if (align.equals((Object)HorizontalAlignment.CENTER)) {
            style.setAlign(Alignment.center);
        } else if (align.equals((Object)HorizontalAlignment.RIGHT)) {
            style.setAlign(Alignment.right);
        } else {
            style.setAlign(Alignment.left);
        }
        VerticalAlignment valign = cellStyle.getVerticalAlignment();
        if (valign.equals((Object)VerticalAlignment.BOTTOM)) {
            style.setValign(Alignment.bottom);
        } else if (valign.equals((Object)VerticalAlignment.TOP)) {
            style.setValign(Alignment.top);
        } else if (valign.equals((Object)VerticalAlignment.CENTER)) {
            style.setValign(Alignment.middle);
        } else {
            style.setValign(Alignment.middle);
        }
        XSSFFont font = cellStyle.getFont();
        if (font.getBold()) {
            style.setBold(Boolean.valueOf(true));
        }
        if (font.getItalic()) {
            style.setItalic(Boolean.valueOf(true));
        }
        if (font.getUnderline() != 0) {
            style.setUnderline(Boolean.valueOf(true));
        }
        if ((color = font.getXSSFColor()) != null) {
            String rgb = color.getARGBHex();
            style.setForecolor(this.hex2Rgb(rgb));
        } else {
            style.setForecolor("0,0,0");
        }
        FillPatternType pattern = cellStyle.getFillPattern();
        if (pattern != null && pattern.equals((Object)FillPatternType.SOLID_FOREGROUND) && (bgcolor = cellStyle.getFillForegroundColorColor()) != null) {
            String hex = bgcolor.getARGBHex();
            style.setBgcolor(this.hex2Rgb(hex));
        }
        int fontSize = font.getFontHeight() / 20;
        style.setFontSize(fontSize);
        BorderStyle borderStyle = cellStyle.getBorderLeft();
        if (!borderStyle.equals((Object)BorderStyle.NONE)) {
            border = new Border();
            border.setColor("0,0,0");
            border.setStyle(com.bstek.ureport.definition.BorderStyle.solid);
            border.setWidth(1);
            style.setLeftBorder(border);
        }
        if (!(borderStyle = cellStyle.getBorderRight()).equals((Object)BorderStyle.NONE)) {
            border = new Border();
            border.setColor("0,0,0");
            border.setStyle(com.bstek.ureport.definition.BorderStyle.solid);
            border.setWidth(1);
            style.setRightBorder(border);
        }
        if (!(borderStyle = cellStyle.getBorderTop()).equals((Object)BorderStyle.NONE)) {
            border = new Border();
            border.setColor("0,0,0");
            border.setStyle(com.bstek.ureport.definition.BorderStyle.solid);
            border.setWidth(1);
            style.setTopBorder(border);
        }
        if (!(borderStyle = cellStyle.getBorderBottom()).equals((Object)BorderStyle.NONE)) {
            border = new Border();
            border.setColor("0,0,0");
            border.setStyle(com.bstek.ureport.definition.BorderStyle.solid);
            border.setWidth(1);
            style.setBottomBorder(border);
        }
        return style;
    }

    private String hex2Rgb(String colorStr) {
        return Integer.valueOf(colorStr.substring(2, 4), 16) + "," + Integer.valueOf(colorStr.substring(4, 6), 16) + "," + Integer.valueOf(colorStr.substring(6, 8), 16);
    }

    private Span getSpan(XSSFSheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            int colSpan;
            CellRangeAddress range = sheet.getMergedRegion(i);
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            if (row != firstRow || column != firstColumn) continue;
            int lastRow = range.getLastRow();
            int rowSpan = lastRow - firstRow;
            if (rowSpan > 0) {
                ++rowSpan;
            }
            if ((colSpan = lastColumn - firstColumn) > 0) {
                ++colSpan;
            }
            return new Span(rowSpan, colSpan);
        }
        return new Span(0, 0);
    }

    private boolean isMergedRegion(XSSFSheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            int lastRow = range.getLastRow();
            if (row <= firstRow || row >= lastRow || column <= firstColumn || column >= lastColumn) continue;
            return true;
        }
        return false;
    }

    private int buildMaxColumn(XSSFSheet sheet) {
        int rowCount = sheet.getPhysicalNumberOfRows();
        int maxColumnCount = 0;
        for (int i = 0; i < rowCount; ++i) {
            int columnCount;
            XSSFRow row = sheet.getRow(i);
            if (row == null || (columnCount = row.getPhysicalNumberOfCells()) <= maxColumnCount) continue;
            maxColumnCount = columnCount;
        }
        return maxColumnCount;
    }

    protected void addBlankCells(List<CellDefinition> cellDefs, int rowNumber, int totalColumn) {
        for (int i = 0; i < totalColumn; ++i) {
            CellDefinition cellDef = new CellDefinition();
            cellDef.setValue((Value)new SimpleValue(""));
            cellDef.setRowNumber(rowNumber);
            cellDef.setColumnNumber(i + 1);
            cellDefs.add(cellDef);
        }
    }

    public static String convertToExcelCoordinate(int row, int column) {
        StringBuilder sb = new StringBuilder();
        while (column >= 0) {
            sb.insert(0, (char)(65 + column % 26));
            column = column / 26 - 1;
        }
        sb.append(row + 1);
        return sb.toString();
    }

    public static void main(String[] args) {
        String v = "=C6+C7-C1*C2/C5+4";
        System.out.println(ExcelParser.isFormal(v));
    }

    private static boolean isFormal(String v) {
        String[] split;
        if (v == null || v.isEmpty()) {
            return false;
        }
        if (!v.startsWith("=")) {
            return false;
        }
        v = v.substring(1);
        System.out.println(v);
        for (String s : split = v.split("\\+|-|\\*|/")) {
            s = s.trim();
            boolean ok = ExcelParser.isExcelCoordsOrNumber(s);
            System.out.println(s + "\uff1a" + ok);
            if (ok) continue;
            return false;
        }
        return true;
    }

    private static boolean isExcelCoordsOrNumber(String v) {
        String pattern = "^[A-Z]{0,2}\\d+$";
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(v);
        return matcher.matches();
    }
}

