/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.importexcel;

import com.bstek.ureport.console.BaseAction;
import com.bstek.ureport.console.cache.TempObjectCache;
import com.bstek.ureport.console.importexcel.ExcelParser;
import com.bstek.ureport.definition.ReportDefinition;
import jakarta.annotation.Resource;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"ureport/import"})
public class ImportExcelAction
extends BaseAction {
    @Resource
    ExcelParser excelParser;

    @RequestMapping(produces={"application/json; charset=UTF-8"})
    public Map<String, Object> execute(@RequestParam(name="_excel_file") MultipartFile file) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!file.getOriginalFilename().endsWith(".xlsx")) {
            result.put("result", false);
            result.put("errorInfo", "\u53ea\u652f\u6301.xlsx");
            return result;
        }
        InputStream inputStream = file.getInputStream();
        ReportDefinition report = this.excelParser.parse(inputStream);
        inputStream.close();
        if (report == null) {
            result.put("result", false);
            result.put("errorInfo", "\u89e3\u6790\u9519\u8bef");
        } else {
            result.put("result", true);
            TempObjectCache.putObject("classpath:template/template.ureport.xml", report);
        }
        return result;
    }
}

