/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.pdf;

import com.bstek.ureport.build.ReportBuilder;
import com.bstek.ureport.console.BaseAction;
import com.bstek.ureport.console.cache.TempObjectCache;
import com.bstek.ureport.console.exception.ReportDesignException;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.exception.ReportException;
import com.bstek.ureport.export.ExportConfigure;
import com.bstek.ureport.export.ExportConfigureImpl;
import com.bstek.ureport.export.ExportManager;
import com.bstek.ureport.export.ReportRender;
import com.bstek.ureport.export.pdf.PdfProducer;
import com.bstek.ureport.model.Report;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Resource;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ureport/pdf"})
public class ExportPdfAction
extends BaseAction {
    @Resource
    private ReportBuilder reportBuilder;
    @Resource
    private ExportManager exportManager;
    @Resource
    private ReportRender reportRender;
    private PdfProducer pdfProducer = new PdfProducer();

    @RequestMapping
    public void execute(@RequestParam(value="_u") String file, @RequestParam(name="_n", required=false) String fileName, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.buildPdf(file, fileName, req, resp, false);
    }

    @RequestMapping(value={"show"})
    public void show(@RequestParam(value="_u") String file, @RequestParam(name="_n", required=false) String fileName, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.buildPdf(file, fileName, req, resp, true);
    }

    public void buildPdf(String file, String fileName, HttpServletRequest req, HttpServletResponse resp, boolean forPrint) throws IOException {
        if (StringUtils.isBlank((String)(file = this.decode(file)))) {
            throw new ReportComputeException("Report file can not be null.");
        }
        OutputStream outputStream = null;
        try {
            fileName = this.buildDownloadFileName(file, fileName, ".pdf");
            fileName = new String(fileName.getBytes("UTF-8"), "ISO8859-1");
            if (forPrint) {
                resp.setContentType("application/pdf");
                resp.setHeader("Content-Disposition", "inline;filename=\"" + fileName + "\"");
            } else {
                resp.setContentType("application/octet-stream;charset=ISO8859-1");
                resp.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
            }
            outputStream = resp.getOutputStream();
            Map<String, Object> parameters = this.buildParameters(req);
            if (file.equals("p")) {
                ReportDefinition reportDefinition = (ReportDefinition)TempObjectCache.getObject("p");
                if (reportDefinition == null) {
                    throw new ReportDesignException("Report data has expired,can not do export pdf.");
                }
                Report report = this.reportBuilder.buildReport(reportDefinition, parameters);
                this.pdfProducer.produce(report, outputStream);
            } else {
                ExportConfigureImpl configure = new ExportConfigureImpl(file, parameters, outputStream);
                this.exportManager.exportPdf((ExportConfigure)configure);
            }
        }
        catch (Exception ex) {
            throw new ReportException(ex);
        }
        finally {
            outputStream.flush();
            outputStream.close();
        }
    }

    @RequestMapping(value={"newPaging"})
    public void newPaging(@RequestParam(value="_u") String file, @RequestParam(value="_paper") String paper, HttpServletRequest req) throws IOException {
        if (StringUtils.isBlank((String)file)) {
            throw new ReportComputeException("Report file can not be null.");
        }
        Report report = null;
        Map<String, Object> parameters = this.buildParameters(req);
        if (file.equals("p")) {
            reportDefinition = (ReportDefinition)TempObjectCache.getObject("p");
            if (reportDefinition == null) {
                throw new ReportDesignException("Report data has expired,can not do export pdf.");
            }
            report = this.reportBuilder.buildReport(reportDefinition, parameters);
        } else {
            reportDefinition = this.reportRender.getReportDefinition(file);
            report = this.reportRender.render(reportDefinition, parameters);
        }
        ObjectMapper mapper = new ObjectMapper();
        Paper newPaper = (Paper)mapper.readValue(paper, Paper.class);
        report.rePaging(newPaper);
    }
}

