/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.word;

import com.bstek.ureport.build.ReportBuilder;
import com.bstek.ureport.console.BaseAction;
import com.bstek.ureport.console.cache.TempObjectCache;
import com.bstek.ureport.console.exception.ReportDesignException;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.exception.ReportException;
import com.bstek.ureport.export.ExportConfigure;
import com.bstek.ureport.export.ExportConfigureImpl;
import com.bstek.ureport.export.ExportManager;
import com.bstek.ureport.export.word.high.WordProducer;
import com.bstek.ureport.model.Report;
import jakarta.annotation.Resource;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ureport/word"})
public class ExportWordAction
extends BaseAction {
    @Resource
    private ReportBuilder reportBuilder;
    @Resource
    private ExportManager exportManager;
    private WordProducer wordProducer = new WordProducer();

    @RequestMapping
    public void execute(@RequestParam(name="_u", required=false) String file, @RequestParam(name="_n", required=false) String fileName, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.buildWord(file, fileName, req, resp);
    }

    public void buildWord(String file, String fileName, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (StringUtils.isBlank((String)(file = this.decode(file)))) {
            throw new ReportComputeException("Report file can not be null.");
        }
        ServletOutputStream outputStream = resp.getOutputStream();
        try {
            fileName = this.buildDownloadFileName(file, fileName, ".docx");
            fileName = new String(fileName.getBytes(StandardCharsets.UTF_8), "ISO8859-1");
            resp.setContentType("application/octet-stream;charset=ISO8859-1");
            resp.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
            Map<String, Object> parameters = this.buildParameters(req);
            if (file.equals("p")) {
                ReportDefinition reportDefinition = (ReportDefinition)TempObjectCache.getObject("p");
                if (reportDefinition == null) {
                    throw new ReportDesignException("Report data has expired,can not do export word.");
                }
                Report report = this.reportBuilder.buildReport(reportDefinition, parameters);
                this.wordProducer.produce(report, (OutputStream)outputStream);
            } else {
                ExportConfigureImpl configure = new ExportConfigureImpl(file, parameters, (OutputStream)outputStream);
                this.exportManager.exportWord((ExportConfigure)configure);
            }
        }
        catch (Exception ex) {
            throw new ReportException(ex);
        }
        finally {
            outputStream.flush();
            outputStream.close();
        }
    }
}

