/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pinyin4j;

import net.sourceforge.pinyin4j.ChineseToPinyinResource;
import net.sourceforge.pinyin4j.GwoyeuRomatzyhTranslator;
import net.sourceforge.pinyin4j.PinyinFormatter;
import net.sourceforge.pinyin4j.PinyinRomanizationTranslator;
import net.sourceforge.pinyin4j.PinyinRomanizationType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import net.sourceforge.pinyin4j.multipinyin.Trie;

public class PinyinHelper {
    private static final String[] ARR_EMPTY = new String[0];
    private static final String EMPTY = "";

    public static String[] toHanyuPinyinStringArray(char ch) {
        return PinyinHelper.getUnformattedHanyuPinyinStringArray(ch);
    }

    public static String[] toHanyuPinyinStringArray(char ch, HanyuPinyinOutputFormat outputFormat) throws BadHanyuPinyinOutputFormatCombination {
        return PinyinHelper.getFormattedHanyuPinyinStringArray(ch, outputFormat);
    }

    private static String[] getFormattedHanyuPinyinStringArray(char ch, HanyuPinyinOutputFormat outputFormat) throws BadHanyuPinyinOutputFormatCombination {
        String[] pinyinStrArray = PinyinHelper.getUnformattedHanyuPinyinStringArray(ch);
        if (null != pinyinStrArray) {
            for (int i = 0; i < pinyinStrArray.length; ++i) {
                pinyinStrArray[i] = PinyinFormatter.formatHanyuPinyin(pinyinStrArray[i], outputFormat);
            }
            return pinyinStrArray;
        }
        return ARR_EMPTY;
    }

    private static String[] getUnformattedHanyuPinyinStringArray(char ch) {
        return ChineseToPinyinResource.getInstance().getHanyuPinyinStringArray(ch);
    }

    public static String[] toTongyongPinyinStringArray(char ch) {
        return PinyinHelper.convertToTargetPinyinStringArray(ch, PinyinRomanizationType.TONGYONG_PINYIN);
    }

    public static String[] toWadeGilesPinyinStringArray(char ch) {
        return PinyinHelper.convertToTargetPinyinStringArray(ch, PinyinRomanizationType.WADEGILES_PINYIN);
    }

    public static String[] toMPS2PinyinStringArray(char ch) {
        return PinyinHelper.convertToTargetPinyinStringArray(ch, PinyinRomanizationType.MPS2_PINYIN);
    }

    public static String[] toYalePinyinStringArray(char ch) {
        return PinyinHelper.convertToTargetPinyinStringArray(ch, PinyinRomanizationType.YALE_PINYIN);
    }

    private static String[] convertToTargetPinyinStringArray(char ch, PinyinRomanizationType targetPinyinSystem) {
        String[] hanyuPinyinStringArray = PinyinHelper.getUnformattedHanyuPinyinStringArray(ch);
        if (null != hanyuPinyinStringArray) {
            String[] targetPinyinStringArray = new String[hanyuPinyinStringArray.length];
            for (int i = 0; i < hanyuPinyinStringArray.length; ++i) {
                targetPinyinStringArray[i] = PinyinRomanizationTranslator.convertRomanizationSystem(hanyuPinyinStringArray[i], PinyinRomanizationType.HANYU_PINYIN, targetPinyinSystem);
            }
            return targetPinyinStringArray;
        }
        return ARR_EMPTY;
    }

    public static String[] toGwoyeuRomatzyhStringArray(char ch) {
        return PinyinHelper.convertToGwoyeuRomatzyhStringArray(ch);
    }

    private static String[] convertToGwoyeuRomatzyhStringArray(char ch) {
        String[] hanyuPinyinStringArray = PinyinHelper.getUnformattedHanyuPinyinStringArray(ch);
        if (null != hanyuPinyinStringArray) {
            String[] targetPinyinStringArray = new String[hanyuPinyinStringArray.length];
            for (int i = 0; i < hanyuPinyinStringArray.length; ++i) {
                targetPinyinStringArray[i] = GwoyeuRomatzyhTranslator.convertHanyuPinyinToGwoyeuRomatzyh(hanyuPinyinStringArray[i]);
            }
            return targetPinyinStringArray;
        }
        return ARR_EMPTY;
    }

    public static String toHanYuPinyinString(String str, HanyuPinyinOutputFormat outputFormat, String separate, boolean retain, boolean retainSeparator) throws BadHanyuPinyinOutputFormatCombination {
        ChineseToPinyinResource resource = ChineseToPinyinResource.getInstance();
        StringBuilder resultPinyinStrBuf = new StringBuilder();
        char[] chars = str.toCharArray();
        boolean lastHasResult = false;
        for (int i = 0; i < chars.length; ++i) {
            String result = null;
            char ch = chars[i];
            Trie currentTrie = resource.getUnicodeToHanyuPinyinTable();
            int success = i;
            int current = i;
            do {
                String hexStr;
                if ((currentTrie = currentTrie.get(hexStr = Integer.toHexString(ch).toUpperCase())) != null) {
                    if (currentTrie.getPinyin() != null) {
                        result = currentTrie.getPinyin();
                        success = current;
                    }
                    currentTrie = currentTrie.getNextTire();
                    ++current;
                }
                if (current >= chars.length) break;
                ch = chars[current];
            } while (currentTrie != null);
            if (result == null) {
                if (retain) {
                    resultPinyinStrBuf.append(chars[i]);
                }
                if (i > 0 && !retainSeparator && lastHasResult) {
                    resultPinyinStrBuf.delete(resultPinyinStrBuf.length() - 1 - separate.length(), resultPinyinStrBuf.length() - 1);
                }
            } else {
                String[] pinyinStrArray;
                if (i > 0 && retainSeparator && !lastHasResult && current < chars.length) {
                    resultPinyinStrBuf.append(separate);
                }
                if ((pinyinStrArray = resource.parsePinyinString(result)) != null) {
                    for (int j = 0; j < pinyinStrArray.length; ++j) {
                        resultPinyinStrBuf.append(PinyinFormatter.formatHanyuPinyin(pinyinStrArray[j], outputFormat));
                        if (current < chars.length || j < pinyinStrArray.length - 1 && i != success) {
                            resultPinyinStrBuf.append(separate);
                        }
                        if (i == success) break;
                    }
                }
            }
            i = success;
            lastHasResult = result != null;
        }
        return resultPinyinStrBuf.toString();
    }

    public static String toHanYuPinyinString(String str, HanyuPinyinOutputFormat outputFormat, String separate, boolean retain) throws BadHanyuPinyinOutputFormatCombination {
        return PinyinHelper.toHanYuPinyinString(str, outputFormat, separate, retain, false);
    }

    public static String toHanYuPinyinString(String str, HanyuPinyinOutputFormat outputFormat) throws BadHanyuPinyinOutputFormatCombination {
        return PinyinHelper.toHanYuPinyinString(str, outputFormat, EMPTY, true, false);
    }

    public static String toHanYuPinyinString(String str) throws BadHanyuPinyinOutputFormatCombination {
        return PinyinHelper.toHanYuPinyinString(str, new HanyuPinyinOutputFormat(), EMPTY, true, false);
    }

    private PinyinHelper() {
    }
}

