/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm;

import io.github.toolfactory.jvm.Info;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeSet;

public class ObjectProvider {
    private final String classSuffix;
    private static final String CLASS_NAME = ObjectProvider.class.getName();
    final Integer[] registeredVersions;

    public ObjectProvider(String classSuffix, int ... versions) {
        this.classSuffix = classSuffix;
        int jVMVersion = Info.getInstance().getVersion();
        TreeSet<Integer> registeredVersions = new TreeSet<Integer>();
        for (int i = 0; i < versions.length; ++i) {
            if (jVMVersion < versions[i]) continue;
            registeredVersions.add(versions[i]);
        }
        this.registeredVersions = registeredVersions.descendingSet().toArray(new Integer[registeredVersions.size()]);
    }

    public <T> T getOrBuildObject(Class<? super T> clazz, Map<Object, Object> context) {
        String className = clazz.getName();
        LinkedHashSet<String> searchedClasses = new LinkedHashSet<String>();
        Object object = ObjectProvider.getObject(clazz, context);
        context.put(CLASS_NAME, this);
        Integer[] integerArray = this.registeredVersions;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int version = integerArray[i];
            String clsName = className + "$" + this.classSuffix + version;
            try {
                Class<?> effectiveClass = null;
                try {
                    effectiveClass = Class.forName(clsName);
                }
                catch (ClassNotFoundException exc) {
                    searchedClasses.add(clsName);
                    clsName = className + this.classSuffix + version;
                    effectiveClass = Class.forName(clsName);
                }
                object = effectiveClass.getDeclaredConstructor(Map.class).newInstance(context);
                context.put(className, object);
                return object;
            }
            catch (ClassNotFoundException exc) {
                searchedClasses.add(clsName);
                continue;
            }
            catch (Throwable exc) {
                throw new BuildingException("Unable to build the related object of " + clazz.getName(), exc);
            }
        }
        Class<T> superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            try {
                return this.getOrBuildObject(superClass, context);
            }
            catch (BuildingException exc) {
                throw new BuildingException("Unable to build the related object of " + clazz.getName() + ": " + String.join((CharSequence)", ", searchedClasses) + " have been searched without success", exc);
            }
        }
        throw new BuildingException("Unable to build the related object of " + clazz.getName() + ": " + String.join((CharSequence)", ", searchedClasses) + " have been searched without success");
    }

    public static <F> F getObject(Class<? super F> clazz, Map<Object, Object> context) {
        Object objectFound = context.get(clazz.getName());
        if (objectFound != null) {
            return (F)objectFound;
        }
        for (Object object : context.values()) {
            if (!clazz.isAssignableFrom(object.getClass())) continue;
            return (F)object;
        }
        return null;
    }

    public static ObjectProvider get(Map<Object, Object> context) {
        return (ObjectProvider)context.get(CLASS_NAME);
    }

    public static class BuildingException
    extends RuntimeException {
        public BuildingException(String message, Throwable cause) {
            super(message, cause);
        }

        public BuildingException(String message) {
            super(message);
        }
    }
}

