/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.catalog.GetDeclaredFieldsMethodHandleSupplier;
import io.github.toolfactory.jvm.function.catalog.ThrowExceptionFunction;
import io.github.toolfactory.jvm.function.template.BiFunction;
import io.github.toolfactory.jvm.util.ObjectProvider;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.Map;

public abstract class GetDeclaredFieldFunction
implements BiFunction<Class<?>, String, Field> {

    public static class ForJava7
    extends GetDeclaredFieldFunction {
        MethodHandle getDeclaredFields;
        ThrowExceptionFunction throwExceptionFunction;

        public ForJava7(Map<Object, Object> context) {
            ObjectProvider functionProvider = ObjectProvider.get(context);
            this.getDeclaredFields = functionProvider.getOrBuildObject(GetDeclaredFieldsMethodHandleSupplier.class, context).get();
            this.throwExceptionFunction = functionProvider.getOrBuildObject(ThrowExceptionFunction.class, context);
        }

        @Override
        public Field apply(Class<?> cls, String name) {
            try {
                for (Field field : this.getDeclaredFields.invoke(cls, false)) {
                    if (!field.getName().equals(name)) continue;
                    return field;
                }
            }
            catch (Throwable exc) {
                return (Field)this.throwExceptionFunction.apply(exc, new Object[0]);
            }
            return null;
        }
    }
}

