/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.util;

import io.github.toolfactory.jvm.Driver;
import io.github.toolfactory.jvm.function.template.Function;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;

public class Reflection {
    private Driver driver;

    private Reflection(Driver driver) {
        this.driver = driver;
    }

    public Driver getDriver() {
        return this.driver;
    }

    public Collection<Method> getDeclaredMethods(Class<?> cls) {
        LinkedHashSet<Method> declaredMembers = new LinkedHashSet<Method>();
        for (Method method : this.driver.getDeclaredMethods(cls)) {
            declaredMembers.add(method);
        }
        return declaredMembers;
    }

    public Collection<Method> getAllMethods(Class<?> cls) {
        return this.getAll(cls, new Function<Class<?>, Method[]>(){

            @Override
            public Method[] apply(Class<?> input) {
                return Reflection.this.driver.getDeclaredMethods(input);
            }
        }, new HashSet(), new LinkedHashSet());
    }

    public <T> T getFieldValue(Object target, Field field) {
        return this.driver.getFieldValue(target, field);
    }

    public void setFieldValue(Object target, Field field, Object value) {
        this.driver.setFieldValue(target, field, value);
    }

    public Field getDeclaredField(Class<?> cls, String name) {
        for (Field member : this.driver.getDeclaredFields(cls)) {
            if (!member.getName().equals(name)) continue;
            return member;
        }
        return null;
    }

    public Collection<Field> getDeclaredFields(Class<?> cls) {
        LinkedHashSet<Field> declaredMembers = new LinkedHashSet<Field>();
        for (Field member : this.driver.getDeclaredFields(cls)) {
            declaredMembers.add(member);
        }
        return declaredMembers;
    }

    public Collection<Field> getAllFields(Class<?> cls) {
        return this.getAll(cls, new Function<Class<?>, Field[]>(){

            @Override
            public Field[] apply(Class<?> input) {
                return Reflection.this.driver.getDeclaredFields(input);
            }
        }, new HashSet(), new LinkedHashSet());
    }

    public Collection<Constructor<?>> getDeclaredConstructors(Class<?> cls) {
        LinkedHashSet declaredMembers = new LinkedHashSet();
        for (Constructor<?> member : this.driver.getDeclaredConstructors(cls)) {
            declaredMembers.add(member);
        }
        return declaredMembers;
    }

    public Collection<Constructor<?>> getAllConstructors(Class<?> cls) {
        return this.getAll(cls, new Function<Class<?>, Constructor<?>[]>(){

            @Override
            public Constructor<?>[] apply(Class<?> input) {
                return Reflection.this.driver.getDeclaredConstructors(input);
            }
        }, new HashSet(), new LinkedHashSet());
    }

    private <M extends Member> Collection<M> getAll(Class<?> cls, Function<Class<?>, M[]> memberSupplier, Collection<Class<?>> visitedInterfaces, Collection<M> collection) {
        for (Member member : (Member[])memberSupplier.apply(cls)) {
            collection.add(member);
        }
        for (Class<?> interf : cls.getInterfaces()) {
            if (!visitedInterfaces.add(interf)) continue;
            this.getAll(interf, memberSupplier, visitedInterfaces, collection);
        }
        Class<?> superClass = cls.getSuperclass();
        return superClass != null ? this.getAll(superClass, memberSupplier, visitedInterfaces, collection) : collection;
    }

    public static class Factory {
        public static Reflection getNew() {
            return Factory.getNewWith(Driver.Factory.getNew());
        }

        public static Reflection getNewWith(Driver driver) {
            return new Reflection(driver);
        }

        public static Reflection getNewWithDefaultDriver() {
            return Factory.getNewWith(Driver.Factory.getNewDefault());
        }

        public static Reflection getNewWithHybridDriver() {
            return Factory.getNewWith(Driver.Factory.getNewHybrid());
        }

        public static Reflection getNewWithNativeDriver() {
            return Factory.getNewWith(Driver.Factory.getNewNative());
        }
    }
}

