/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.catalog.GetDeclaredFieldFunction;
import io.github.toolfactory.jvm.function.catalog.ThrowExceptionFunction;
import io.github.toolfactory.jvm.function.catalog.UnsafeSupplier;
import io.github.toolfactory.jvm.function.template.Function;
import io.github.toolfactory.jvm.util.CleanableSupplier;
import io.github.toolfactory.jvm.util.ObjectProvider;
import io.github.toolfactory.narcissus.Narcissus;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import sun.misc.Unsafe;

public interface GetLoadedClassesRetrieverFunction
extends Function<ClassLoader, CleanableSupplier<Collection<Class<?>>>> {

    public static interface Native
    extends GetLoadedClassesRetrieverFunction {

        public static class ForJava7
        implements Native {
            protected Field classesField;

            public ForJava7(Map<Object, Object> context) {
                ObjectProvider functionProvider = ObjectProvider.get(context);
                GetDeclaredFieldFunction getDeclaredFieldFunction = functionProvider.getOrBuildObject(GetDeclaredFieldFunction.class, context);
                this.classesField = (Field)getDeclaredFieldFunction.apply(ClassLoader.class, "classes");
            }

            @Override
            public CleanableSupplier<Collection<Class<?>>> apply(final ClassLoader classLoader) {
                if (classLoader == null) {
                    throw new NullPointerException("Input classLoader parameter can't be null");
                }
                return new CleanableSupplier<Collection<Class<?>>>(){
                    Collection<Class<?>> classes;

                    @Override
                    public Collection<Class<?>> get() {
                        if (this.classes != null) {
                            return this.classes;
                        }
                        this.classes = (Collection)Narcissus.getField((Object)classLoader, (Field)ForJava7.this.classesField);
                        return this.classes;
                    }

                    @Override
                    public void clear() {
                        this.get();
                        if (this.classes != null) {
                            this.classes.clear();
                        }
                    }
                };
            }

            public static class ForSemeru
            extends io.github.toolfactory.jvm.function.catalog.GetLoadedClassesRetrieverFunction$ForJava7$ForSemeru {
                public ForSemeru(Map<Object, Object> context) {
                    super(context);
                }

                @Override
                protected Function<ClassLoader, Hashtable<String, Object>> buildClassNameBasedLockSupplierSupplier(final Map<Object, Object> context) {
                    return new Function<ClassLoader, Hashtable<String, Object>>(){
                        protected ThrowExceptionFunction throwExceptionFunction;
                        {
                            this.throwExceptionFunction = ObjectProvider.get(context).getOrBuildObject(ThrowExceptionFunction.class, context);
                        }

                        @Override
                        public Hashtable<String, Object> apply(ClassLoader classLoader) {
                            try {
                                return (Hashtable)Narcissus.getField((Object)classLoader, (Field)ForSemeru.this.classNameBasedLockField);
                            }
                            catch (Throwable exc) {
                                return (Hashtable)this.throwExceptionFunction.apply(exc, new Object[0]);
                            }
                        }
                    };
                }
            }
        }
    }

    public static class ForJava7
    implements GetLoadedClassesRetrieverFunction {
        protected Unsafe unsafe;
        protected Long loadedClassesVectorMemoryOffset;

        public ForJava7(Map<Object, Object> context) {
            ObjectProvider functionProvider = ObjectProvider.get(context);
            this.unsafe = (Unsafe)functionProvider.getOrBuildObject(UnsafeSupplier.class, context).get();
            GetDeclaredFieldFunction getDeclaredFieldFunction = functionProvider.getOrBuildObject(GetDeclaredFieldFunction.class, context);
            this.loadedClassesVectorMemoryOffset = this.unsafe.objectFieldOffset((Field)getDeclaredFieldFunction.apply(ClassLoader.class, "classes"));
        }

        @Override
        public CleanableSupplier<Collection<Class<?>>> apply(final ClassLoader classLoader) {
            if (classLoader == null) {
                throw new NullPointerException("Input classLoader parameter can't be null");
            }
            return new CleanableSupplier<Collection<Class<?>>>(){
                Collection<Class<?>> classes;

                @Override
                public Collection<Class<?>> get() {
                    if (this.classes != null) {
                        return this.classes;
                    }
                    this.classes = (Collection)ForJava7.this.unsafe.getObject(classLoader, ForJava7.this.loadedClassesVectorMemoryOffset);
                    return this.classes;
                }

                @Override
                public void clear() {
                    this.get();
                    if (this.classes != null) {
                        this.classes.clear();
                    }
                }
            };
        }

        public static class ForSemeru
        implements GetLoadedClassesRetrieverFunction {
            protected Function<ClassLoader, Hashtable<String, Object>> classNameBasedLockSupplier;
            protected Field classNameBasedLockField;

            public ForSemeru(Map<Object, Object> context) {
                ObjectProvider functionProvider = ObjectProvider.get(context);
                GetDeclaredFieldFunction getDeclaredFieldFunction = functionProvider.getOrBuildObject(GetDeclaredFieldFunction.class, context);
                this.classNameBasedLockField = (Field)getDeclaredFieldFunction.apply(ClassLoader.class, "classNameBasedLock");
                this.classNameBasedLockSupplier = this.buildClassNameBasedLockSupplierSupplier(context);
            }

            protected Function<ClassLoader, Hashtable<String, Object>> buildClassNameBasedLockSupplierSupplier(final Map<Object, Object> context) {
                return new Function<ClassLoader, Hashtable<String, Object>>(){
                    protected Unsafe unsafe;
                    protected Long classNameBasedLockHashTable;
                    {
                        this.unsafe = (Unsafe)ObjectProvider.get(context).getOrBuildObject(UnsafeSupplier.class, context).get();
                        this.classNameBasedLockHashTable = this.unsafe.objectFieldOffset(ForSemeru.this.classNameBasedLockField);
                    }

                    @Override
                    public Hashtable<String, Object> apply(ClassLoader classLoader) {
                        return (Hashtable)this.unsafe.getObject(classLoader, this.classNameBasedLockHashTable);
                    }
                };
            }

            @Override
            public CleanableSupplier<Collection<Class<?>>> apply(final ClassLoader classLoader) {
                return new CleanableSupplier<Collection<Class<?>>>(){
                    Hashtable<String, Object> classNameBasedLock;
                    Collection<Class<?>> loadedClasses = ConcurrentHashMap.newKeySet();

                    @Override
                    public Collection<Class<?>> get() {
                        Hashtable<Object, Object> loadedClassesHS = null;
                        Hashtable<String, Object> loadedClassesHSTemp = this.getClassNameBasedLock();
                        while (loadedClassesHS == null) {
                            try {
                                if (loadedClassesHSTemp != null) {
                                    loadedClassesHS = new Hashtable<String, Object>(loadedClassesHSTemp);
                                    continue;
                                }
                                loadedClassesHS = new Hashtable();
                            }
                            catch (ConcurrentModificationException concurrentModificationException) {}
                        }
                        for (Map.Entry entry : loadedClassesHS.entrySet()) {
                            try {
                                this.loadedClasses.add(Class.forName((String)entry.getKey()));
                            }
                            catch (Throwable throwable) {}
                        }
                        return this.loadedClasses;
                    }

                    @Override
                    public void clear() {
                        if (this.classNameBasedLock != null) {
                            this.classNameBasedLock.clear();
                        }
                        this.loadedClasses.clear();
                    }

                    private Hashtable<String, Object> getClassNameBasedLock() {
                        if (this.classNameBasedLock != null) {
                            return this.classNameBasedLock;
                        }
                        this.classNameBasedLock = ForSemeru.this.classNameBasedLockSupplier.apply(classLoader);
                        return this.classNameBasedLock;
                    }
                };
            }
        }
    }
}

