/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.util;

import io.github.toolfactory.jvm.util.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class Properties {
    public static Map<Long, java.util.Properties> loadFromResources(String resRelPath, String propertyName, ClassLoader ... classLoaders) throws IOException {
        HashMap<URL, InputStream> resources = new HashMap<URL, InputStream>();
        for (ClassLoader classLoader : classLoaders) {
            resources.putAll(Resources.getAsInputStreams(classLoader, resRelPath));
        }
        TreeMap<Long, java.util.Properties> orderedProperties = new TreeMap<Long, java.util.Properties>();
        for (Map.Entry entry : resources.entrySet()) {
            java.util.Properties props = new java.util.Properties();
            InputStream inputStream = (InputStream)entry.getValue();
            try {
                props.load((InputStream)entry.getValue());
                String propValue = props.getProperty(propertyName);
                if (propValue == null) {
                    propValue = "1";
                }
                orderedProperties.put(Long.parseLong(propValue), props);
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        return orderedProperties;
    }

    public static java.util.Properties loadFromResourceWithHigherPropertyValue(ClassLoader resourceClassLoader, String resRelPath, String propertyName, ClassLoader ... classLoaders) throws IOException {
        NavigableMap orderedProperties = ((TreeMap)Properties.loadFromResources(resRelPath, propertyName, classLoaders)).descendingMap();
        return (java.util.Properties)orderedProperties.entrySet().iterator().next().getValue();
    }

    public static java.util.Properties loadFromResourcesAndMerge(String resRelPath, String propertyName, ClassLoader ... classLoaders) throws IOException {
        Map<Long, java.util.Properties> orderedProperties = Properties.loadFromResources(resRelPath, propertyName, classLoaders);
        java.util.Properties properties = new java.util.Properties();
        for (Map.Entry<Long, java.util.Properties> entry : orderedProperties.entrySet()) {
            properties.putAll((Map<?, ?>)entry.getValue());
        }
        properties.remove(propertyName);
        return properties;
    }
}

