/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.catalog.GetDeclaredFieldFunction;
import io.github.toolfactory.jvm.function.catalog.UnsafeSupplier;
import io.github.toolfactory.jvm.function.template.Function;
import io.github.toolfactory.jvm.util.ObjectProvider;
import io.github.toolfactory.narcissus.Narcissus;
import java.lang.reflect.Field;
import java.util.Map;
import sun.misc.Unsafe;

public interface GetLoadedPackagesFunction
extends Function<ClassLoader, Map<String, ?>> {

    public static interface Native
    extends GetLoadedPackagesFunction {

        public static class ForJava7
        implements Native {
            Field packagesField;

            public ForJava7(Map<Object, Object> context) {
                ObjectProvider functionProvider = ObjectProvider.get(context);
                GetDeclaredFieldFunction getDeclaredFieldFunction = functionProvider.getOrBuildObject(GetDeclaredFieldFunction.class, context);
                this.packagesField = (Field)getDeclaredFieldFunction.apply(ClassLoader.class, "packages");
            }

            @Override
            public Map<String, ?> apply(ClassLoader classLoader) {
                return (Map)Narcissus.getField((Object)classLoader, (Field)this.packagesField);
            }
        }
    }

    public static class ForJava7
    implements GetLoadedPackagesFunction {
        protected Unsafe unsafe;
        protected Long fieldOffset;

        public ForJava7(Map<Object, Object> context) {
            ObjectProvider functionProvider = ObjectProvider.get(context);
            this.unsafe = (Unsafe)functionProvider.getOrBuildObject(UnsafeSupplier.class, context).get();
            GetDeclaredFieldFunction getDeclaredFieldFunction = functionProvider.getOrBuildObject(GetDeclaredFieldFunction.class, context);
            this.fieldOffset = this.unsafe.objectFieldOffset((Field)getDeclaredFieldFunction.apply(ClassLoader.class, "packages"));
        }

        @Override
        public Map<String, ?> apply(ClassLoader classLoader) {
            return (Map)this.unsafe.getObject(classLoader, this.fieldOffset);
        }
    }
}

