/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.catalog.BuiltinClassLoaderClassSupplier;
import io.github.toolfactory.jvm.function.catalog.DeepConsulterSupplyFunction;
import io.github.toolfactory.jvm.function.catalog.ThrowExceptionFunction;
import io.github.toolfactory.jvm.function.template.BiFunction;
import io.github.toolfactory.jvm.util.ObjectProvider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface GetResourcesAsInputStreamsFunction
extends BiFunction<String, ClassLoader[], Map<URL, InputStream>> {

    public static class ForJava9
    extends ForJava7 {
        public ForJava9(Map<Object, Object> context) throws Throwable {
            super(context);
        }

        @Override
        protected BiFunction<ClassLoader, String, Collection<URL>> buildResourceFinder(final Map<Object, Object> context) throws Throwable {
            final ObjectProvider functionProvider = ObjectProvider.get(context);
            final MethodHandles.Lookup consulter = (MethodHandles.Lookup)functionProvider.getOrBuildObject(DeepConsulterSupplyFunction.class, context).apply(Class.class);
            return new BiFunction<ClassLoader, String, Collection<URL>>(){
                Class<?> builtinClassLoaderClass;
                MethodHandle findResourcesOnClassPathMethod;
                MethodHandle findMiscResourceMethodHandle;
                {
                    this.builtinClassLoaderClass = (Class)functionProvider.getOrBuildObject(BuiltinClassLoaderClassSupplier.class, context).get();
                    this.findResourcesOnClassPathMethod = consulter.findVirtual(this.builtinClassLoaderClass, "findResourcesOnClassPath", MethodType.methodType(Enumeration.class, String.class));
                    this.findMiscResourceMethodHandle = consulter.findVirtual(this.builtinClassLoaderClass, "findMiscResource", MethodType.methodType(List.class, String.class));
                }

                @Override
                public Collection<URL> apply(ClassLoader classLoader, String resourceRelativePath) {
                    try {
                        if (this.builtinClassLoaderClass.isAssignableFrom(classLoader.getClass())) {
                            ArrayList<URL> resources = new ArrayList<URL>();
                            resources.addAll(Collections.list((Enumeration)this.findResourcesOnClassPathMethod.invokeWithArguments(classLoader, resourceRelativePath)));
                            resources.addAll((Collection)this.findMiscResourceMethodHandle.invokeWithArguments(classLoader, resourceRelativePath));
                            return resources;
                        }
                        return Collections.list(classLoader.getResources(resourceRelativePath));
                    }
                    catch (Throwable exc) {
                        return (Collection)ForJava9.this.throwExceptionFunction.apply(exc, new Object[0]);
                    }
                }
            };
        }
    }

    public static class ForJava7
    extends Abst {
        public ForJava7(Map<Object, Object> context) throws Throwable {
            super(context);
        }

        @Override
        protected BiFunction<ClassLoader, String, Collection<URL>> buildResourceFinder(Map<Object, Object> context) throws Throwable {
            return new BiFunction<ClassLoader, String, Collection<URL>>(){

                @Override
                public Collection<URL> apply(ClassLoader classLoader, String resourceRelativePath) {
                    try {
                        return Collections.list(classLoader.getResources(resourceRelativePath));
                    }
                    catch (Throwable exc) {
                        return (Collection)ForJava7.this.throwExceptionFunction.apply(exc, new Object[0]);
                    }
                }
            };
        }
    }

    public static abstract class Abst
    implements GetResourcesAsInputStreamsFunction {
        protected ThrowExceptionFunction throwExceptionFunction;
        protected BiFunction<ClassLoader, String, Collection<URL>> resourceFinder;

        public Abst(Map<Object, Object> context) throws Throwable {
            ObjectProvider functionProvider = ObjectProvider.get(context);
            this.throwExceptionFunction = functionProvider.getOrBuildObject(ThrowExceptionFunction.class, context);
            this.resourceFinder = this.buildResourceFinder(context);
        }

        protected abstract BiFunction<ClassLoader, String, Collection<URL>> buildResourceFinder(Map<Object, Object> var1) throws Throwable;

        @Override
        public Map<URL, InputStream> apply(String resourceRelativePath, ClassLoader[] resourceClassLoaders) {
            if (resourceClassLoaders == null || resourceClassLoaders.length == 0) {
                resourceClassLoaders = new ClassLoader[]{Thread.currentThread().getContextClassLoader()};
            }
            LinkedHashMap<URL, InputStream> streams = new LinkedHashMap<URL, InputStream>();
            for (ClassLoader classLoader : resourceClassLoaders) {
                Collection<URL> resources = this.resourceFinder.apply(classLoader, resourceRelativePath);
                Iterator<URL> itr = resources.iterator();
                while (resources != null && itr.hasNext()) {
                    URL resourceURL = itr.next();
                    try {
                        streams.put(resourceURL, resourceURL.openStream());
                    }
                    catch (IOException exc) {
                        return (Map)this.throwExceptionFunction.apply(exc, new Object[0]);
                    }
                }
            }
            return streams;
        }
    }
}

