/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.util;

import io.github.toolfactory.jvm.Info;
import io.github.toolfactory.jvm.function.template.Supplier;
import io.github.toolfactory.jvm.util.Strings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;

public class ObjectProvider {
    private final List<String> classNameItems = new CopyOnWriteArrayList<String>();
    private Map<String, List<String>> jVMVendorToClassSuffix = new LinkedHashMap<String, List<String>>();
    private static final String CLASS_NAME = ObjectProvider.class.getName();
    private int jVMVersion;
    private String vendor;

    public ObjectProvider(int ... versions) {
        this.jVMVendorToClassSuffix.put("Oracle Corporation", new ArrayList());
        this.jVMVendorToClassSuffix.put("International Business Machines Corporation", Arrays.asList("ForSemeru"));
        this.jVMVersion = Info.Provider.getInfoInstance().getVersion();
        this.vendor = System.getProperty("java.vendor");
        TreeSet<Integer> registeredVersions = new TreeSet<Integer>();
        for (int i = 0; i < versions.length; ++i) {
            if (this.jVMVersion < versions[i]) continue;
            registeredVersions.add(versions[i]);
        }
        for (Integer version : registeredVersions.descendingSet().toArray(new Integer[registeredVersions.size()])) {
            this.classNameItems.add("ForJava" + version);
        }
    }

    public <T> T getOrBuildObject(Class<? super T> clazz, Map<Object, Object> context) {
        List<String> classNameOptionalItems = this.jVMVendorToClassSuffix.get(this.vendor);
        if (classNameOptionalItems != null) {
            try {
                context.put("classNameOptionalItems", classNameOptionalItems);
                return this.getOrBuildObjectInternal(clazz, context);
            }
            catch (Throwable exc) {
                throw new BuildingException(Strings.compile("Exception occurred while retrieving the implentation of class {} (jvm architecture: {}, jvm version: {}, jvm vendor: {})", clazz.getName(), Info.Provider.getInfoInstance().is64Bit() ? "x64" : "x86", this.jVMVersion, this.vendor), exc);
            }
        }
        BuildingException mainException = null;
        for (Map.Entry<String, List<String>> jVMVendorToClassSuffix : this.jVMVendorToClassSuffix.entrySet()) {
            try {
                context.put("classNameOptionalItems", jVMVendorToClassSuffix.getValue());
                return this.getOrBuildObjectInternal(clazz, context);
            }
            catch (Throwable exc) {
                if (!jVMVendorToClassSuffix.getKey().equals("Oracle Corporation")) continue;
                mainException = new BuildingException(Strings.compile("Exception occurred while retrieving the implentation of class {} (jvm architecture: {}, jvm version: {}, jvm vendor: {})", clazz.getName(), Info.Provider.getInfoInstance().is64Bit() ? "x64" : "x86", this.jVMVersion, jVMVendorToClassSuffix.getKey()), exc);
            }
        }
        throw mainException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean putClassNameOptionalItem(List<String> classNameOptionalItems, String value) {
        if (!classNameOptionalItems.contains(value)) {
            List<String> list = classNameOptionalItems;
            synchronized (list) {
                if (!classNameOptionalItems.contains(value)) {
                    classNameOptionalItems.clear();
                    classNameOptionalItems.add(value);
                    return true;
                }
            }
        }
        return false;
    }

    private <T> T getOrBuildObjectInternal(Class<? super T> clazz, Map<Object, Object> context) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        String className = clazz.getName();
        LinkedHashSet<String> searchedClasses = new LinkedHashSet<String>();
        T object = ObjectProvider.getObject(clazz, context);
        if (object != null) {
            return object;
        }
        context.put(CLASS_NAME, this);
        List classNameOptionalItems = (List)context.get("classNameOptionalItems");
        List<String> classNameItems = Arrays.asList(new String[classNameOptionalItems.size() + 2]);
        classNameItems.set(0, className);
        for (int i = 0; i < classNameOptionalItems.size(); ++i) {
            classNameItems.set(i + 2, (String)classNameOptionalItems.get(i));
        }
        classNameItems = new ArrayList<String>(classNameItems);
        while (classNameItems.size() > 1) {
            for (String classNameItem : this.classNameItems) {
                try {
                    classNameItems.set(1, classNameItem);
                    object = this.retrieveClass(classNameItems, searchedClasses, "$").getDeclaredConstructor(Map.class).newInstance(context);
                    context.put(className, object);
                    return object;
                }
                catch (ClassNotFoundException exc) {
                }
            }
            classNameItems.remove(classNameItems.size() - 1);
        }
        if (!Modifier.isAbstract(clazz.getModifiers()) && !clazz.isInterface()) {
            try {
                return clazz.getDeclaredConstructor(Map.class).newInstance(context);
            }
            catch (Throwable exc) {
                throw new BuildingException("Unable to build the related object of " + clazz.getName(), exc);
            }
        }
        Class<T> superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            try {
                return this.getOrBuildObject(superClass, context);
            }
            catch (BuildingException exc) {
                throw new BuildingException("Unable to build the related object of " + clazz.getName() + ": " + Strings.join(", ", searchedClasses) + " have been searched without success", exc);
            }
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces.length > 0) {
            for (Class<?> interf : interfaces) {
                try {
                    return (T)this.getOrBuildObject(interf, context);
                }
                catch (BuildingException buildingException) {
                }
            }
        }
        throw new BuildingException("Unable to build the related object of " + clazz.getName() + ": " + Strings.join(", ", searchedClasses) + " have been searched without success");
    }

    private <T> Class<? super T> retrieveClass(List<String> classNameItems, Collection<String> notFoundClasses, String separator) throws ClassNotFoundException {
        Collection<String> allClassNameCombinations = this.retrieveAllClassNameCombinations(classNameItems, separator);
        for (String className : allClassNameCombinations) {
            try {
                Class<?> cls = Class.forName(className);
                if (Modifier.isAbstract(cls.getModifiers()) || cls.isInterface()) {
                    notFoundClasses.add(className);
                    continue;
                }
                return Class.forName(className);
            }
            catch (ClassNotFoundException exc) {
                notFoundClasses.add(className);
            }
        }
        throw new ClassNotFoundException();
    }

    Collection<String> retrieveAllClassNameCombinations(List<String> classNameItems, String separator) {
        ArrayList<String> finalStringColl = new ArrayList<String>();
        LinkedHashSet<String> classNames = new LinkedHashSet<String>();
        ArrayList combinationsToBeReprocessed = new ArrayList();
        for (int i = classNameItems.size(); i > 0; --i) {
            List<String> list = classNameItems.subList(0, i);
            String firstPart = Strings.join("", list);
            if (!list.isEmpty()) {
                finalStringColl.add(firstPart);
            }
            List<String> secondPartList = classNameItems.subList(i, classNameItems.size());
            String secondPart = Strings.join("", secondPartList);
            if (!secondPartList.isEmpty()) {
                finalStringColl.add(secondPart);
            }
            classNames.add(Strings.join(separator, finalStringColl));
            if (secondPartList.size() > 1) {
                ArrayList<String> toBeReprocessed = new ArrayList<String>();
                String firstPartOfSecondPart = secondPartList.get(0);
                toBeReprocessed.add(firstPart + separator + firstPartOfSecondPart);
                toBeReprocessed.addAll(secondPartList.subList(1, secondPartList.size()));
                combinationsToBeReprocessed.add(toBeReprocessed);
            }
            finalStringColl.clear();
        }
        for (List list : combinationsToBeReprocessed) {
            classNames.addAll(this.retrieveAllClassNameCombinations(list, separator));
        }
        return classNames;
    }

    public static <F> F getObject(Class<? super F> clazz, Map<Object, Object> context) {
        Object objectFound = context.get(clazz.getName());
        if (objectFound != null) {
            return (F)objectFound;
        }
        for (Object object : context.values()) {
            if (!clazz.isAssignableFrom(object.getClass())) continue;
            return (F)object;
        }
        return null;
    }

    public static ObjectProvider get(Map<Object, Object> context) {
        return (ObjectProvider)context.get(CLASS_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putIfAbsent(Map<Object, Object> context, Supplier<ObjectProvider> objectProvider) {
        ObjectProvider objectProviderInMap = (ObjectProvider)context.get(CLASS_NAME);
        if (objectProviderInMap == null) {
            Map<Object, Object> map = context;
            synchronized (map) {
                objectProviderInMap = (ObjectProvider)context.get(CLASS_NAME);
                if (objectProviderInMap == null) {
                    context.put(CLASS_NAME, objectProvider.get());
                }
            }
        }
    }

    public static class BuildingException
    extends RuntimeException {
        private static final long serialVersionUID = -7606794206649872816L;

        public BuildingException(String message, Throwable cause) {
            super(message, cause);
        }

        public BuildingException(String message) {
            super(message);
        }
    }
}

