/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.catalog.UnsafeSupplier;
import io.github.toolfactory.jvm.function.template.Consumer;
import io.github.toolfactory.jvm.util.ObjectProvider;
import io.github.toolfactory.jvm.util.Strings;
import io.github.toolfactory.narcissus.Narcissus;
import java.util.Map;
import sun.misc.Unsafe;

public interface ThrowExceptionFunction
extends Consumer<Throwable> {
    public <T> T apply(Object var1, Object ... var2);

    public static interface Native
    extends ThrowExceptionFunction {

        public static class ForJava7
        extends Abst
        implements Native {
            public ForJava7(Map<Object, Object> context) {
            }

            @Override
            public void accept(Throwable exception) {
                Narcissus.sneakyThrow((Throwable)exception);
            }
        }
    }

    public static class ForJava7
    extends Abst {
        protected Unsafe unsafe;

        public ForJava7(Map<Object, Object> context) {
            this.unsafe = (Unsafe)ObjectProvider.get(context).getOrBuildObject(UnsafeSupplier.class, context).get();
        }

        @Override
        public void accept(Throwable exception) {
            this.unsafe.throwException(exception);
        }
    }

    public static abstract class Abst
    implements ThrowExceptionFunction {
        @Override
        public <T> T apply(Object exceptionOrMessage, Object ... placeHolderReplacements) {
            Throwable exception = null;
            if (exceptionOrMessage instanceof String) {
                StackTraceElement[] stackTraceOfException = null;
                exception = placeHolderReplacements == null || placeHolderReplacements.length == 0 ? new Exception((String)exceptionOrMessage) : new Exception(Strings.compile((String)exceptionOrMessage, placeHolderReplacements));
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                stackTraceOfException = new StackTraceElement[stackTrace.length - 2];
                System.arraycopy(stackTrace, 2, stackTraceOfException, 0, stackTraceOfException.length);
                exception.setStackTrace(stackTraceOfException);
            } else {
                exception = (Throwable)exceptionOrMessage;
            }
            this.accept(exception);
            return null;
        }
    }
}

